/**
 * 
 */
package com.yeejoin.amos.supervision.business.dao;

import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * hql助手类
 * 
 * @author as-youjun
 *
 */
public class DaoHelper {

	/**
	 * 构造方法
	 */
	private DaoHelper() {
		LoggerFactory.getLogger(this.getClass()).debug("constructor");
	}

	/**
	 * 转换成in语句
	 * 
	 * @param objs
	 * @return
	 */
	public static String buildInStr(List<?> objs) {
		StringBuilder sb = new StringBuilder();
		objs.forEach(item -> {
			if ((item instanceof Integer) || (item instanceof Long)) {
				sb.append(item.toString()).append(",");
			} else if (item instanceof String) {
				sb.append("'").append(item.toString()).append("',");
			}
		});
		String s = sb.toString();
		s = s.substring(0, s.length() - 1);
		return s;
	}

	/**
	 * 构造in条件
	 * 
	 * @param size
	 * @return
	 */
	public static String buildInStr(int size) {
		if (size <= 0) {
			return "";
		}
		StringBuilder sb = new StringBuilder();
		sb.append("(");
		for (int i = 0; i < size; i++) {
			sb.append("?,");
		}
		String s = sb.toString();
		s = s.substring(0, s.length() - 1);
		s += ")";
		return s;
	}

	/**
	 * 构建查询数量结果sql
	 * 
	 * @return
	 */
	public static String buildCountResultSql() {
		return "select count(1) as totalNum ";
	}

}
