package com.yeejoin.amos.supervision.business.service.intfc;

import java.util.List;
import java.util.Map;

import com.yeejoin.amos.supervision.business.vo.DangerTimeAxisVo;
import org.springframework.data.domain.Page;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.bo.RoleBo;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.supervision.business.dto.DangerExecuteSubmitDto;
import com.yeejoin.amos.supervision.business.param.LatentDangerExcuteParam;
import com.yeejoin.amos.supervision.business.param.LatentDangerListParam;
import com.yeejoin.amos.supervision.business.param.LatentDangerNormalParam;
import com.yeejoin.amos.supervision.business.param.LatentDangerPatrolParam;
import com.yeejoin.amos.supervision.business.param.PageParam;
import com.yeejoin.amos.supervision.business.util.CommonResponse;
import com.yeejoin.amos.supervision.core.common.response.DangerListResponse;

/**
 * @author keyong
 * @title: ILatentDangerService
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2021/1/26 14:44
 */
public interface ILatentDangerService {

    CommonResponse saveNormal(LatentDangerNormalParam latentDangerParam, String userId, String userRealName,
                              String departmentId, String departmentName, String companyId, String orgCode, RoleBo role);

    CommonResponse savePatrol(LatentDangerPatrolParam latentDangerPatrolParam, String userId, String userRealName,
                              String departmentId, String departmentName, String companyId, String orgCode, RoleBo role);

    CommonResponse list(String toke, String product, String appKey, LatentDangerListParam latentDangerListParam, AgencyUserModel user, String loginOrgCode, String deptId);

    DangerExecuteSubmitDto execute(LatentDangerExcuteParam latentDangerExcuteParam, String userId,
                                   String userRealName, String departmentId, String departmentName, RoleBo role);

    CommonResponse detail(String id, String userId,boolean isFinish);

    CommonResponse getByInstanceId(String instanceId);

    DangerExecuteSubmitDto excuteCallBack(String instanceId, Integer actionType, String remark, String token, String userId,
                                          String userRealName, String departmentId, String departmentName);

    void updateDangerStateOfOvertime();

    CommonResponse listFlowRecord(String token, String product, String appKey, Long id);

    void sendLatentDangerExcuteResult(DangerExecuteSubmitDto executeSubmitDto);

    void freshRiskJudgmentLangerCount(LatentDangerExcuteParam latentDangerExcuteParam);

    /**
     * 获取隐患等级字典值
     *
     * @return
     */
    Object getDangerLevel(String token, String product, String appKey, String dictCode);

    /**
     * 根据等级字符串获取等级字典对象
     *
     * @param dangerLevelStr 等级（"1","2","0"）
     * @return
     */
    JSONObject getDangerLevelJsonObject(String dangerLevelStr, String token, String product, String appKey, String dictCode);

    /**
     * 根据隐患id获取评审信息
     *
     * @param dangerId
     * @return
     */
    JSONObject getReviewInfo(Long dangerId);

    Page<DangerListResponse> listDanger(PageParam pageParam);

    List<DangerListResponse> export(PageParam pageParam);

    List<DangerTimeAxisVo> queryExecuteLog(Integer dateTime);

    /**
     * 根据参数获取巡检隐患信息
     *
     * @param param
     * @return
     */
    JSONObject getPatrolDangerInfo(JSONObject param);

    /**
     * 根据参数修改巡检检查项
     *
     * @param param
     * @return
     */
    JSONObject getPatrolDangerCheck(JSONObject param);

    /**
     * 查询隐患信息
     * @return
     */
    Map<String, Object> getLatentDanger(Long latentDangerId);
}
