package com.yeejoin.amos.boot.module.cas.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.amos.boot.module.cas.api.dto.IdxBizXnzsDto;
import com.yeejoin.amos.boot.module.cas.api.dto.ResultDto;
import com.yeejoin.amos.boot.module.cas.api.entity.IdxBizXnzs;
import com.yeejoin.amos.boot.module.cas.api.mapper.IdxBizXnzsMapper;
import com.yeejoin.amos.boot.module.cas.api.service.IIdxBizXnzsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import springfox.documentation.spring.web.json.Json;

import java.util.*;

/**
 *  服务实现类
 *
 * @author wanglong
 * @date 2022-09-14
 */
@Service
public class IdxBizXnzsServiceImpl extends BaseService<IdxBizXnzsDto, IdxBizXnzs,IdxBizXnzsMapper> implements IIdxBizXnzsService {
    @Autowired
    private IdxBizXnzsMapper idxBizXnzsMapper;

    private static final Logger log = LoggerFactory.getLogger(IdxBizXnzsServiceImpl.class);

    @Override
    public JSONObject select() {
        /**
         * 预返回数据
         */
        JSONObject message = new JSONObject();
        List<IdxBizXnzsDto> xnzsDtoList = idxBizXnzsMapper.select();

        List<String> axisData = new ArrayList<>();
//        List<List<Double>> seriesDataList=new ArrayList<>();
        List<JSONObject> seriesDataList = new ArrayList<>();

        String []  borderColor = {"#5966e6","#e7533b","#00c190","#8f57da","#f59c59","#19d3f3","#ff6692","#b6e880","#413a68","#f5c551","#4857c2","#ed553b","#01bb8d","#a561f3" };
        String [] color = {"#354599","#7b393a","#047569","#584099","#835f4a","#15a7c7","#834166","#5e825c","#835a9c","#a18a49","#354599","#7b393b","#037569","#6f4ab4"};
        int i = 0;
        for(IdxBizXnzsDto bizXnzsDto : xnzsDtoList){
//            List<Double> list=new ArrayList<>();
            JSONObject firstJson = new JSONObject();
            JSONObject secondJson = new JSONObject();
            JSONObject thirdly = new JSONObject();
            axisData.add(bizXnzsDto.getAxisData());

            JSONArray json = new JSONArray();


            Double[] doubles = {bizXnzsDto.getOne(),bizXnzsDto.getTwo(),bizXnzsDto.getThree(),bizXnzsDto.getFour()};
            thirdly.put("borderWidth","2");
            thirdly.put("borderColor",borderColor[i]);
            thirdly.put("color",color[i]);
            secondJson.put("normal",thirdly);
            i = i+1;
            Arrays.sort(doubles);

            json.add(doubles[0]);
            json.add((doubles[0]+doubles[1])/2);
            json.add((doubles[1]+doubles[2])/2);
            json.add((doubles[2]+doubles[3])/2);
            json.add(doubles[3]);
            firstJson.put("value",json);
            firstJson.put("itemStyle",secondJson);
            seriesDataList.add(firstJson);
//            seriesDataList.add(list);
        }

        message.put("axisData",axisData);
        message.put("seriesData",seriesDataList);


        return message;
    }

    /**
     * 查询政务大列
     * @return
     */
    @Override
    public JSONObject selectZwdl() {
        /**
         * 预返回数据
         */
        JSONObject message =  new JSONObject();
        List<String> axisData=new ArrayList<>();
//        List<List<Double>> seriesDataList=new ArrayList<>();
        List<JSONObject> seriesDataList = new ArrayList<>();
        /**
         * 颜色
         */
        String []  borderColor = {"#5966e6","#e7533b","#00c190","#8f57da","#f59c59","#19d3f3","#ff6692","#b6e880","#413a68","#f5c551","#4857c2","#ed553b","#01bb8d","#a561f3" };
        String [] color = {"#354599","#7b393a","#047569","#584099","#835f4a","#15a7c7","#834166","#5e825c","#835a9c","#a18a49","#354599","#7b393b","#037569","#6f4ab4"};
        int i =0;
        /**
         * 获取政务大列数据
         */
        List<IdxBizXnzsDto> zwdlDto = idxBizXnzsMapper.selectZwdl();

        /**
         * 组装返回数据
         */
            for(IdxBizXnzsDto idxBizXnzsDto : zwdlDto ) {
                /**
                 * 子数据
                 */
                JSONObject firstJson = new JSONObject();
                JSONObject secondJson = new JSONObject();
                JSONObject thirdly = new JSONObject();
            //预返回箱线图数据
//            List<Double> list = new ArrayList<>();
                JSONArray json = new JSONArray();
            //添加政务大类
            axisData.add(idxBizXnzsDto.getAxisData());

            //添加最近四季度
            Double[] ottf = {idxBizXnzsDto.getOne(),idxBizXnzsDto.getTwo(),idxBizXnzsDto.getThree(), idxBizXnzsDto.getFour()};
                thirdly.put("borderWidth","2");
                thirdly.put("borderColor",borderColor[i]);
                thirdly.put("color",color[i]);
                secondJson.put("normal",thirdly);
                i = i+1;
            //排序(从小到大)
            Arrays.sort(ottf);

            /**
             * 添加箱线图数据
             */
                json.add(ottf[0]);
                json.add((ottf[0]+ottf[1])/2);
                json.add((ottf[1]+ottf[2])/2);
                json.add((ottf[2]+ottf[3])/2);
                json.add(ottf[3]);
                firstJson.put("value",json);
                firstJson.put("itemStyle",secondJson);
                seriesDataList.add(firstJson);

        }

        message.put("seriesData",seriesDataList);
        message.put("axisData",axisData);

        return message;
    }
}
