package com.yeejoin.amos.boot.module.tzs.flc.api.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 气瓶终端用户
 *
 * @author system_generator
 * @date 2022-04-21
 */
@Data
@EqualsAndHashCode()
@Accessors(chain = true)
@TableName("tz_end_user")
public class EndUser {

	private static final long serialVersionUID = 1L;

	@TableId(value = "sequence_nbr", type = IdType.ID_WORKER)
	protected Long sequenceNbr;

	@TableField(value = "rec_date", fill = FieldFill.INSERT_UPDATE)
	protected Date recDate;

	@TableField(value = "rec_user_id", fill = FieldFill.INSERT_UPDATE)
	protected String recUserId;

	/**
	 * 客户编号
	 */
	@TableField("custom_code")
	private String customCode;

	/**
	 * 客户名称
	 */
	@TableField("custom_name")
	private String customName;

	/**
	 * 客户类型
	 */
	@TableField("custom_type")
	private String customType;

	/**
	 * 开户类型
	 */
	@TableField("account_type")
	private String accountType;

	/**
	 * 联系人
	 */
	@TableField("contact")
	private String contact;

	/**
	 * 联系电话
	 */
	@TableField("contact_phone")
	private String contactPhone;

	/**
	 * 客户地址
	 */
	@TableField("address")
	private String address;

	/**
	 * 充装单位
	 */
	@TableField("filling_unit")
	private String fillingUnit;

	/**
	 * 所属机构
	 */
	@TableField("affiliation")
	private String affiliation;

	/**
	 * 上次下单时间
	 */
	@TableField("last_order_date")
	private Date lastOrderDate;

	/**
	 * 配送员
	 */
	@TableField("delivery")
	private String delivery;

	/**
	 * 配送员电话
	 */
	@TableField("delivery_phone")
	private String deliveryPhone;

	/**
	 * 钢瓶码
	 */
	@TableField("cylinder_code")
	private String cylinderCode;

	/**
	 * 芯片号
	 */
	@TableField("chip_code")
	private String chipCode;

	/**
	 * 经度
	 */
	@TableField("longitude")
	private String longitude;

	/**
	 * 纬度
	 */
	@TableField("latitude")
	private String latitude;

}
