package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 勘察信息
 *
 * @author system_generator
 * @date 2023-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "hygf_survey_information",autoResultMap = true)
public class SurveyInformation extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 勘察编号
     */
	@TableField("survey_number")
    private String surveyNumber;

    /**
     * 电站类型
     */
	@TableField("power_station_type")
    private String powerStationType;

    /**
     * 开发方名称
     */
	@TableField("developer_name")
    private String developerName;

    /**
     * 开发方code
     */
	@TableField("developer_code")
    private String developerCode;

    /**
     *  业务员id
     */
	@TableField("salesman_id")
    private String salesmanId;

    /**
     * 业务员名称
     */
	@TableField("salesman")
    private String salesman;

    /**
     * 制单人
     */
	@TableField("creator")
    private String creator;

    /**
     * 制单时间
     */
	@TableField("creator_time")
    private Date creatorTime;

    /**
     * 业主类型
     */
	@TableField("owner_type")
    private String ownerType;

    /**
     *  审核状态 0未审核,1审核中，2审核结束
     */
	@TableField("review")
    private Integer review;

}
