package com.yeejoin.amos.boot.module.hygf.api.fegin;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.feign.MultipartSupportConfig;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@FeignClient(value = "AMOS-IDX", path = "idx", configuration = {MultipartSupportConfig.class})
public interface IdxFeginService {

    /**
     *通用表单提交 数据填报
     */
    @RequestMapping(value = "/table/submit", method = RequestMethod.POST)
    FeignClientResult<String> submit(@RequestParam(value = "pageId") long pageId,
                                     @RequestParam(value = "taskId",required = false) String taskId,
                                     @RequestParam(value = "planInstanceId", required = false) String planInstanceId,
                                     @RequestParam(value = "bizField", required = false) String bizField,
                                     @RequestParam(value = "topic", required = false) String topic,
                                     @RequestParam(value = "tableName", required = false) String tableName,
                                     @RequestBody Map<String, Object> kv) throws Exception;
    /**
     *通用表单提交 数据填报
     */
    @RequestMapping(value = "/report/form/getRecordData/{id}", method = RequestMethod.GET)
    FeignClientResult<JSONObject> getRecord(@PathVariable("id") String id);


    @RequestMapping(value = "/table/submit", method = RequestMethod.POST)
    FeignClientResult<String> tokenSubmit(
                                    @RequestHeader(name="appKey",required = true) String appKey,
                                    @RequestHeader(name="product",required = true) String product,
                                    @RequestHeader(name="token",required = true) String token,
                                     @RequestParam(value = "pageId") long pageId,
                                     @RequestParam(value = "taskId",required = false) String taskId,
                                     @RequestParam(value = "planInstanceId", required = false) String planInstanceId,
                                     @RequestParam(value = "bizField", required = false) String bizField,
                                     @RequestParam(value = "topic", required = false) String topic,
                                     @RequestParam(value = "tableName", required = false) String tableName,
                                     @RequestBody Map<String, Object> kv) throws Exception;




    /**
     *通用表单提交 数据填报
     */
    @RequestMapping(value = "/report/form/getRecordData/{id}", method = RequestMethod.GET)
    FeignClientResult<JSONObject> getRecordtoken(
            @RequestHeader(name="appKey",required = true) String appKey,
            @RequestHeader(name="product",required = true) String product,
            @RequestHeader(name="token",required = true) String token,
            @PathVariable("id") String id);
}
