package com.yeejoin.amos.boot.module.jxiop.biz.feign;

import com.alibaba.fastjson.JSONObject;
import feign.Response;
import feign.Util;
import feign.codec.ErrorDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;

/**
 * @author fengwang
 * @date 2022-07-28.
 */
public class FeignErrorDecoder implements ErrorDecoder {

    private static final Logger log = LoggerFactory.getLogger(FeignErrorDecoder.class);

    @Override
    public Exception decode(String methodKey, Response response) {
        String msg = null;
        try {
            msg = Util.toString(response.body().asReader(Util.UTF_8));
            JSONObject object = JSONObject.parseObject(msg);
            throw new RuntimeException(object.get("devMessage").toString());
        } catch (IOException e) {
            log.error("feign 调用失败" + e.getMessage());
        }
        throw new RuntimeException(methodKey + "远程调用失败");
    }
}
