package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.module.jxiop.api.entity.MapRegion;
import com.yeejoin.amos.boot.module.jxiop.api.entity.Region;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.CoreValuesDto;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.StationCacheInfoDto;
import com.yeejoin.amos.boot.module.jxiop.biz.feign.CoreFeignClient;
import com.yeejoin.amos.boot.module.jxiop.biz.service.CoreCommonService;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
public class CoreCommonServiceImpl implements CoreCommonService {

    private final CoreFeignClient coreFeignClient;

    @Override
    public List<CoreValuesDto> getValuesByStationNamesAndPointsNames(String stationNames, String pointsNames) {
        FeignClientResult<List<Object>> feignClientResult = coreFeignClient.getValues(stationNames, pointsNames);
        List<Object> list = feignClientResult.getResult();
        List<CoreValuesDto> result = new ArrayList<>();
        list.forEach(o -> {
            CoreValuesDto coreValuesDto = JSONObject.parseObject(JSONObject.toJSONString(o), CoreValuesDto.class);
            coreValuesDto.setDataMap(coreValuesDto.getData().stream().flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b)));
            result.add(coreValuesDto);
        });
        return result;
    }

    @Override
    public Double getSumOfByPointName(List<CoreValuesDto> coreValuesDtoList, String pointName) {
        AtomicReference<Double> result = new AtomicReference<>(0.0);
        coreValuesDtoList = coreValuesDtoList.stream().filter(coreValuesDto -> coreValuesDto.getDataMap().size() > 0 && coreValuesDto.getDataMap().containsKey(pointName)).collect(Collectors.toList());
        coreValuesDtoList.forEach(coreValuesDto -> {
            result.set(result.get() + Double.parseDouble(coreValuesDto.getDataMap().get(pointName).toString()));
        });
        return result.get();
    }

    @Override
    public Double getAverageOfByPointName(List<CoreValuesDto> coreValuesDtoList, String pointName) {
        AtomicReference<Double> result = new AtomicReference<>(0.0);
        coreValuesDtoList = coreValuesDtoList.stream().filter(coreValuesDto -> coreValuesDto.getDataMap().size() > 0 && coreValuesDto.getDataMap().containsKey(pointName)).collect(Collectors.toList());
        coreValuesDtoList.forEach(coreValuesDto -> {
            result.set(result.get() + Double.parseDouble(coreValuesDto.getDataMap().get(pointName).toString()));
        });
        return result.get() / coreValuesDtoList.size();
    }

}
