package com.yeejoin.amos.api.openapi.face.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 安全追溯-压力管道
 *
 * @author cpp
 * @date 2023-04-06 15:21:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="MidEquipTechParamPipelineDto", description="安全追溯-压力管道Dto")
public class MidEquipTechParamPipelineModel extends AbstractBaseModel {
    private static final long serialVersionUID = 1L;


            @ApiModelProperty(value = "监管码")
        private String supervisoryCode;

            @ApiModelProperty(value = "$column.comments")
        private String instanceId;
            @ApiModelProperty(value = "$column.comments")
        private String status;
            @ApiModelProperty(value = "工程(装置)名称")
        private String deviceName;
            @ApiModelProperty(value = "管道类别")
        private String pipelineClass;
            @ApiModelProperty(value = "管道名称（登记单元）")
        private String pipeName;
            @ApiModelProperty(value = "管道编号")
        private String pipelineNumber;
            @ApiModelProperty(value = "设备级别")
        private String deviceLevel;
            @ApiModelProperty(value = "设计标准")
        private String designStandard;
            @ApiModelProperty(value = "管道图号")
        private String pipeDrawNumber;
            @ApiModelProperty(value = "公称直径")
        private BigDecimal nominalDiameter;
            @ApiModelProperty(value = "公称壁厚")
        private BigDecimal wallThickness;
            @ApiModelProperty(value = "管道长度")
        private BigDecimal pipeLength;
            @ApiModelProperty(value = "起始位置起点")
        private String startePosition;
            @ApiModelProperty(value = "压力")
        private BigDecimal pressure;
            @ApiModelProperty(value = "温度")
        private BigDecimal temperature;
            @ApiModelProperty(value = "介质")
        private String medium;
            @ApiModelProperty(value = "备注")
        private String remarks;


            @ApiModelProperty(value = "管道信息")
        private String pipeInfo;

    
}
