package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.changeVehicleRegistrationUnit;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.jg.api.entity.JgChangeVehicleRegistrationUnit;
import com.yeejoin.amos.boot.module.jg.api.entity.JgChangeVehicleRegistrationUnitEq;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgChangeVehicleRegistrationUnitEqServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgChangeVehicleRegistrationUnitServiceImpl;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Getter
public class ChangeVehicleRegistrationUnitEditUpdateService {

    private final JgChangeVehicleRegistrationUnitServiceImpl mainService;

    private final JgChangeVehicleRegistrationUnitEqServiceImpl eqService;

    public Set<String> getEqsByApplyNo(String applyNo) {
        JgChangeVehicleRegistrationUnit JgChangeVehicleRegistrationUnit = getOneByApplyNoSingle(applyNo);
        List<JgChangeVehicleRegistrationUnitEq> eqs = eqService.list(new LambdaQueryWrapper<JgChangeVehicleRegistrationUnitEq>().eq(JgChangeVehicleRegistrationUnitEq::getUnitChangeId, JgChangeVehicleRegistrationUnit.getSequenceNbr()).select(JgChangeVehicleRegistrationUnitEq::getEquId ,BaseEntity::getSequenceNbr));
        return eqs.stream().map(JgChangeVehicleRegistrationUnitEq::getEquId).collect(Collectors.toSet());
    }

    public JgChangeVehicleRegistrationUnit getOneByApplyNo(String applyNo) {
        return mainService.getOne(new LambdaQueryWrapper<JgChangeVehicleRegistrationUnit>().eq(JgChangeVehicleRegistrationUnit::getApplyNo, applyNo));
    }

    private JgChangeVehicleRegistrationUnit getOneByApplyNoSingle(String applyNo) {
        return mainService.getOne(new LambdaQueryWrapper<JgChangeVehicleRegistrationUnit>().eq(JgChangeVehicleRegistrationUnit::getApplyNo, applyNo).select(BaseEntity::getSequenceNbr));
    }

}