package com.yeejoin.amos.boot.module.common.api.dto;

import com.alibaba.fastjson.JSONArray;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.biz.common.dto.DataDictionaryDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 单位资质证书表
 *
 * @author system_generator
 * @date 2025-07-21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "BaseEnterpriseCertDto", description = "单位资质证书表")
public class BaseEnterpriseCertDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "单位编码")
    private String unitCode;

    @ApiModelProperty(value = "证书类型")
    private String certType;

    @ApiModelProperty(value = "证书类型code")
    private String certTypeCode;

    @ApiModelProperty(value = "证书编号（核准证编号）")
    private String certNo;

    @ApiModelProperty(value = "有效期至")
    private Date expiryDate;

    @ApiModelProperty(value = "发证日期")
    private Date issueDate;

    @ApiModelProperty(value = "发证机关")
    private String approvedOrgan;

    @ApiModelProperty(value = "发证机关code")
    private String approvedOrganCode;

    @ApiModelProperty(value = "企业资质证书照片")
    private JSONArray qualificationCertificateAttachment;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "许可项目信息")
    List<DataDictionaryDto> itemCodes;

    @ApiModelProperty(value = "机构类别")
    private String agencyType;

    @ApiModelProperty(value = "分类-哪个身份创建的证书")
    private String unitType;

    @ApiModelProperty(value = "证的状态：报检预留字段，如启用、停用、超期等")
    private Integer certState;

    @ApiModelProperty(value = "机构分类")
    private String agencyClassify;
}
