package com.yeejoin.amos.api.openapi.face.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 单位信息
 * </p>
 *
 * @author 子杨
 * @since 2021-12-17
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SpecialUnitModel extends AbstractBaseModel {

    private static final long serialVersionUID = 1L;
    /**
     * 单位ID
     */
    private String unitId;
    /**
     * 单位名称
     */
    private String unitName;
    /**
     * 社会统一信用代码
     */
    private String creditCode;
    /**
     * 单位类型
     */
    private String unitType;
    /**
     * 地区代码
     */
    private String regionCode;
    /**
     * 邮政编码
     */
    private String postalCode;
    /**
     * 单位详细地址
     */
    private String address;
    /**
     * 法定代表人
     */
    private String legalRepresentative;
    /**
     * 法人联系电话
     */
    private String legalPhone;
    /**
     * 单位电话
     */
    private String unitPhone;
    /**
     * 单位传真
     */
    private String unitFax;
    /**
     * 电子邮箱
     */
    private String email;
    /**
     * 单位网址
     */
    private String unitWebsite;
    /**
     * 联系人
     */
    private String contacts;
    /**
     * 联系人电话
     */
    private String contactsPhone;
    /**
     * 安全管理部门
     */
    private String safeManageOrg;
    /**
     * 安全管理人员
     */
    private String safeManagePeople;
    /**
     * 安管人员联系电话
     */
    private String safeManagePeoplePhone;

}
