package com.yeejoin.amos.boot.module.tcm.flc.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 气瓶标签信息
 *
 * @author system_generator
 * @date 2022-03-04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="CylinderTagsDto", description="气瓶标签信息")
public class CylinderTagsDto  extends BaseDto {

   private static final long serialVersionUID = 1L;



 @ApiModelProperty(value = "id")

 private Long sequenceNbr;

 @ApiModelProperty(value = "气瓶唯一标识码")
 private String sequenceCode;

 @ApiModelProperty(value = "二维码编号")
 @TableField("qrCode")
 private String qrCode;

 @ApiModelProperty(value = "电子标签编号")
 private String electronicLabelCode;

 @ApiModelProperty(value = "创建时间")
 private Date recDate;

 @ApiModelProperty(value = "操作人员")
 private String recUserId;

 @ApiModelProperty(value = "同步时间  yyyy-MM-dd HH24:mi:ss")
 private Date syncDate;

 @ApiModelProperty(value = "0-新增   1-更新  2-删除")
 private Integer syncState;

 @ApiModelProperty(value = "对接公司编码")
 private String appId;

 @ApiModelProperty(value = "数据完整度")
 private Double integrity;

 @ApiModelProperty(value = "气瓶钢印标识")
 private String gasCylinderStamp;
}
