package com.yeejoin.amos.boot.module.jg.api.common;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.yeejoin.amos.boot.module.jg.api.dto.EquipInfoExcelDto;
import lombok.experimental.UtilityClass;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 批量版本控制
 * <p>
 * 每个下载模板新建名为“版本信息”的隐藏sheet, sheet内维护模板的版本信息, 每次上传前与模板的版本进行对比，不一致则返回错误信息
 * <p>
 * ProjectName: amos-boot-biz
 * PackageName: com.yeejoin.amos.boot.module.jg.api.common
 *
 * @author yangyang
 * @version v1.0
 * @date 2025/7/4 13:44
 */
@UtilityClass
public class DataDockTemplateVersionUtils {

    /**
     * 错误提示
     */
    public static final String ERROR_MESSAGE = "模板结构已调整，请下载最新模板，并根据最新格式整理数据后上传，以确保数据导入成功！";

    public static final Map<String, String> VERSION_MAP = new HashMap<>();

    static {
        VERSION_MAP.put("工业管道设备", "V1.0.0");
        VERSION_MAP.put("公用管道设备", "V1.0.0");
        VERSION_MAP.put("历史无证_压力容器设备_氧舱", "V1.0.1");
        VERSION_MAP.put("历史无证设备_场内机动车辆", "V1.0.1");
        VERSION_MAP.put("历史无证设备_电梯设备", "V1.0.1");
        VERSION_MAP.put("历史无证设备_管道设备", "V1.0.0");
        VERSION_MAP.put("历史无证设备_锅炉设备", "V1.0.0");
        VERSION_MAP.put("历史无证设备_起重机械设备", "V1.0.0");
        VERSION_MAP.put("历史无证设备_索道设备", "V1.0.1");
        VERSION_MAP.put("历史无证设备_压力容器设备_固定式", "V1.0.1");
        VERSION_MAP.put("历史无证设备_压力容器设备", "V1.0.0");
        VERSION_MAP.put("历史无证设备_游乐设施设备", "V1.0.0");
        VERSION_MAP.put("历史有证_场内机动车辆", "V1.0.0");
        VERSION_MAP.put("历史有证_电梯设备", "V1.0.1");
        VERSION_MAP.put("历史有证_管道设备", "V1.0.0");
        VERSION_MAP.put("历史有证_锅炉设备", "V1.0.0");
        VERSION_MAP.put("历史有证_起重机械设备", "V1.0.0");
        VERSION_MAP.put("历史有证_索道设备", "V1.0.0");
        VERSION_MAP.put("历史有证_压力容器设备_固定式", "V1.0.1");
        VERSION_MAP.put("历史有证_压力容器设备_氧舱", "V1.0.1");
        VERSION_MAP.put("历史有证_压力容器设备", "V1.0.0");
        VERSION_MAP.put("历史有证_游乐设施设备", "V1.0.0");
        VERSION_MAP.put("新设备_场内机动车辆", "V1.0.0");
        VERSION_MAP.put("新设备_电梯设备", "V1.0.1");
        VERSION_MAP.put("新设备_管道设备", "V1.0.0");
        VERSION_MAP.put("新设备_锅炉设备", "V1.0.0");
        VERSION_MAP.put("新设备_起重机械设备", "V1.0.0");
        VERSION_MAP.put("新设备_索道设备", "V1.0.0");
        VERSION_MAP.put("新设备_压力容器设备_固定式", "V1.0.1");
        VERSION_MAP.put("新设备_压力容器设备_氧舱", "V1.0.1");
        VERSION_MAP.put("新设备_游乐设施设备", "V1.0.0");
        VERSION_MAP.put("压力容器设备", "V1.0.3");
        VERSION_MAP.put("长输管道设备", "V1.0.0");
    }

    /**
     * 比较版本号是否一致
     *
     * @param key     key
     * @param version version
     * @return {@link  boolean}
     * @author yangyang
     * @date 2025/7/4 15:17
     */
    public static boolean isSameVersion(String key, String version) {
        if (ValidationUtil.isEmpty(key) || ValidationUtil.isEmpty(version)) {
            return false;
        }
        if (!VERSION_MAP.containsKey(key)) {
            return false;
        }
        return version.equals(VERSION_MAP.get(key));
    }

    /**
     * 校验上传的文件是否使用正确版本的模板
     *
     *
     * @param file file
     * @author yangyang
     * @date 2025/7/4 15:19
     */
    public static String checkTemplateVersion(MultipartFile file) throws IOException {
        byte[] fileBytes = file.getBytes();
        ExcelReader excelReader = EasyExcel.read(new ByteArrayInputStream(fileBytes)).build();
        List<ReadSheet> sheetList = excelReader.excelExecutor().sheetList(); // 获取所有 sheet

        return checkTemplateVersion(file, sheetList);
    }

    public static String checkTemplateVersion(MultipartFile file, List<ReadSheet> sheetList) throws IOException {
        byte[] fileBytes = file.getBytes();
        List<String> errorMessages = new ArrayList<>(1);
        boolean foundVersionSheet = false;
        for (ReadSheet readSheet : sheetList) {
            String sheetName = readSheet.getSheetName();
            if (!sheetName.contains("版本信息")) {
                continue;
            }
            foundVersionSheet = true;
            int sheetNo = readSheet.getSheetNo();
            EasyExcel.read(new ByteArrayInputStream(fileBytes), EquipInfoExcelDto.class, new AnalysisEventListener<EquipInfoExcelDto>() {
                @Override
                public void invoke(EquipInfoExcelDto data, AnalysisContext context) {
                    if (!DataDockTemplateVersionUtils.isSameVersion(data.getTemplateKey(), data.getTemplateVersion())) {
                        errorMessages.add(DataDockTemplateVersionUtils.ERROR_MESSAGE);
                    }
                }

                @Override
                public void doAfterAllAnalysed(AnalysisContext context) {

                }

            }).headRowNumber(1).sheet(sheetNo, sheetName).doRead();
        }
        if (!foundVersionSheet) {
            errorMessages.add("检测到您使用的模板已过期，为避免数据导入错误，请下载最新模板，并根据新格式整理数据后重新上传！");
        }
        return ValidationUtil.isEmpty(errorMessages) ? "" : errorMessages.get(0);
    }
}
