package com.yeejoin.amos.boot.module.jyjc.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * ProjectName: amos-boot-biz
 * PackageName: com.yeejoin.amos.boot.module.jyjc.api.enums
 *
 * @author yangyang
 * @version v1.0
 * @date 2023/12/15 16:25
 */
@Getter
@AllArgsConstructor
public enum BizTypeEnum {

    SUPERVISE("supervise", "监督检验","115"),
    FIRST_INSPECTION("firstinspect", "定(首)检","116"),
    DETECTION("detection", "电梯检测","117"),
    BUSINESS_OPEN("businessOpen", "检验检测业务开通","114"),
    ENTRUST("entrust", "委托检验","122");

    private String code;
    private String name;
    private String num;

    public static List<String> getEnumNameList() {
        List<String> codeList = new ArrayList<String>();
        for (BizTypeEnum c : BizTypeEnum.values()) {
            codeList.add(c.getCode());
        }
        return codeList;
    }


    public static String getNameByCode(String code) {
        for (BizTypeEnum c : BizTypeEnum.values()) {
            if (c.getCode().equals(code)){
                return c.getName();
            }
        }
        return null;
    }

    public static BizTypeEnum getInstance(String code) {
        for (BizTypeEnum c : BizTypeEnum.values()) {
            if (c.getCode().equals(code)){
                return c;
            }
        }
        return null;
    }

    public static String getNumByCode(String code) {
        for (BizTypeEnum c : BizTypeEnum.values()) {
            if (c.getCode().equals(code)){
                return c.getNum();
            }
        }
        return null;
    }

    public static String getNameByNum(String num) {
        for (BizTypeEnum c : BizTypeEnum.values()) {
            if (c.getNum().equals(num)){
                return c.getName();
            }
        }
        return null;
    }
}
