package com.yeejoin.amos.boot.module.tzs.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 救援过程表
 *
 * @author kongfm
 * @date 2021-08-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="RescueProcessDto", description="救援过程表")
public class RescueProcessDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "警情id")
    private Long alertId;

    @ApiModelProperty(value = "是否派遣")
    private Boolean dispatchStatus;

    @ApiModelProperty(value = "派遣时间")
    private Date dispatchTime;

    @ApiModelProperty(value = "派遣人id")
    private String dispatchUserId;

    @ApiModelProperty(value = "派遣人名称")
    private String dispatchUserName;

    @ApiModelProperty(value = "是否到达")
    private Boolean arriveStatus;

    @ApiModelProperty(value = "到达时间")
    private Date arriveTime;

    @ApiModelProperty(value = "到达记录人id")
    private String arriveUserId;

    @ApiModelProperty(value = "到达记录人名称")
    private String arriveUserName;

    @ApiModelProperty(value = "到达反馈方式")
    private String arriveFeedbackType;

    @ApiModelProperty(value = "是否伤亡")
    private Boolean casualtiesStatus;

    @ApiModelProperty(value = "伤亡情况")
    private String casualtiesInfo;

    @ApiModelProperty(value = "是否救援成功")
    private Boolean rescueStatus;

    @ApiModelProperty(value = "救援完成时间")
    private Date rescueTime;

    @ApiModelProperty(value = "救援记录人id")
    private String rescueUserId;

    @ApiModelProperty(value = "救援记录人名称")
    private String rescueUserName;

    @ApiModelProperty(value = "救援反馈方式")
    private String rescueFeedbackType;

    @ApiModelProperty(value = "是否超时")
    private Boolean isTimeout;

    @ApiModelProperty(value = "到达反馈方式code")
    private String arriveFeedbackCode;

    @ApiModelProperty(value = "救援反馈方式code")
    private String rescueFeedbackCode;

}
