package com.yeejoin.amos.knowledgebase.face.service;


import com.yeejoin.amos.knowledgebase.face.model.KnowledgeTagValueModel;
import com.yeejoin.amos.knowledgebase.face.orm.dao.TagValueMapper;
import com.yeejoin.amos.knowledgebase.face.orm.entity.KnowledgeTagValue;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.exception.BaseException;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.Collection;
import java.util.List;


/**
 * <p>
 * 值标签的实例值 服务类
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */
@Component
public class TagValueService extends BaseService<KnowledgeTagValueModel, KnowledgeTagValue, TagValueMapper> {


    public static final String VALUE_TAG_FIELD_SINGLEVALUE = "singleValue";//单值字段名
    public static final String VALUE_TAG_FIELD_RANGE_MAX = "rangeMax";//范围值 上界
    public static final String VALUE_TAG_FIELD_RANGE_MIN = "rangeMin";//范围值 下界
    public static final String VALUE_TAG_FIELD_TEXT = "text";//文本值
    public static final String VALUE_TAG_FIELD_DATE_H = "dateH";//时间,年月日时分秒
    public static final String VALUE_TAG_FIELD_ENUM_NAME = "enumName";// 枚举类型字段名


    @Transactional(rollbackFor = {Exception.class, BaseException.class})
    public List<KnowledgeTagValueModel> saveInstanceValue(Long instanceSeq, List<KnowledgeTagValueModel> valueModels, String unit) {

        this.deleteByInstanceId(instanceSeq);
        if (!ValidationUtil.isEmpty(valueModels)) {
            for (KnowledgeTagValueModel model : valueModels) {
                model.setAgencyCode(RequestContext.getAgencyCode());
                model.setInstanceSeq(instanceSeq);
                model.setUnit(unit);
                this.createWithModel(model);
            }
        }
        return valueModels;
    }


    public boolean deleteByInstanceId(Long instanceSeq) {
        List<KnowledgeTagValueModel> list = queryByInstance(instanceSeq);
        if (!ValidationUtil.isEmpty(list)) {
            for (KnowledgeTagValueModel model : list) {
                this.deleteBySeq(model.getSequenceNbr());
            }
        }
        return true;
    }


    public List<KnowledgeTagValueModel> queryByInstance(Long instanceSeq) {
        return this.queryForList("", false, instanceSeq);
    }

    public List<KnowledgeTagValueModel> queryTagValuesByDocId(Long docSeq) {
        return Bean.toModels(this.getBaseMapper().queryTagValuesByDocId(docSeq), KnowledgeTagValueModel.class);
    }

    public List<KnowledgeTagValueModel> queryTagValuesByDocIds(Collection<Long> docSeqList) {
        return Bean.toModels(this.getBaseMapper().queryTagValuesByDocIds(docSeqList), KnowledgeTagValueModel.class);
    }
}
