package com.yeejoin.amos.patrol.business.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.amos.patrol.business.service.intfc.IAppService;
import com.yeejoin.amos.patrol.business.util.CommonResponse;
import com.yeejoin.amos.patrol.business.util.CommonResponseUtil;
import com.yeejoin.amos.patrol.common.enums.CheckStatisticsTypeEnum;
import com.yeejoin.amos.patrol.common.enums.PlanTaskExecution;
import com.yeejoin.amos.patrol.common.enums.PlanTaskFinishStatusEnum;
import com.yeejoin.amos.patrol.common.enums.TaskStatisticsTypeEnum;
import com.yeejoin.amos.patrol.core.framework.Permission;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;


@RestController
@RequestMapping(value = "/api/common")
@Api(tags="公共接口api")
public class CommonController  extends AbstractBaseController{
	
	/*@Autowired
	IUserService userService;*/
	@Autowired
	private IAppService iAppService;
	
	@Permission
	@ApiOperation(value = "任务统计口径类型", notes = "任务统计口径类型")
	@RequestMapping(value = "/taskgetStatisticsType", method = RequestMethod.GET)
	public CommonResponse getTaskStatisticsType() {
		return CommonResponseUtil.success(TaskStatisticsTypeEnum.getEnumList());
	}
	
	@Permission
	@ApiOperation(value = "巡检统计口径类型", notes = "巡检统计口径类型")
	@RequestMapping(value = "/checkStatisticsType", method = RequestMethod.GET)
	public CommonResponse getCheckStatisticsType() {
		return CommonResponseUtil.success(CheckStatisticsTypeEnum.getEnumList());
	}
	
	@Permission
	@ApiOperation(httpMethod = "GET", value = "计划任务完成种类", notes = "计划任务完成种类")
	@RequestMapping(value = "/planTaskFinishStatus", method = RequestMethod.GET)
	public CommonResponse getPlanTaskFinishStatus() {
		return CommonResponseUtil.success(PlanTaskFinishStatusEnum.getEnumList());
	}
	
	@Permission
	@ApiOperation(value = "计划任务执行情况种类", notes = "计划任务执行情况种类")
	@RequestMapping(value = "/planTaskExecution", method = RequestMethod.GET)
	public CommonResponse getPlanTaskExecution() {
		return CommonResponseUtil.success(PlanTaskExecution.getEnumList());
	}
	
	@Permission
	@ApiOperation(value = "获取app最新版本信息", notes = "获取app最新版本信息")
	@RequestMapping(value = "/queryAppVersion", method = RequestMethod.GET)
	//@Authorization(ingore=true)
	public CommonResponse getAppLastVersion() {
		return CommonResponseUtil.success(iAppService.queryAppLastVersion());
	}
	
}
