package com.yeejoin.amos.boot.module.tzs.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.tzs.api.dto.DispatchPaperDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.DispatchPaperFormDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.DispatchPaper;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.DispatchPaperServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

/**
 * 派遣单
 *
 * @author system_generator
 * @date 2021-08-03
 */
@RestController
@Api(tags = "派遣单Api")
@RequestMapping(value = "/tzs/dispatch-paper")
public class DispatchPaperController extends BaseController {

    @Autowired
    DispatchPaperServiceImpl dispatchPaperServiceImpl;

	@Autowired
	RedisUtils redisUtils;

    /**
     * 新增派遣单
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增派遣单", notes = "新增派遣单")
	public ResponseModel<DispatchPaperFormDto> save(@RequestBody DispatchPaperFormDto dispatchPaperFormDto) {
		if (ValidationUtil.isEmpty(dispatchPaperFormDto)
				|| ValidationUtil.isEmpty(dispatchPaperFormDto.getDispatchPaper()))
			throw new BadRequest("参数校验失败.");
		ReginParams reginParams =
				JSONObject.parseObject(null != redisUtils.get(buildKey(getToken())) ?
						redisUtils.get(buildKey(getToken())).toString() : null, ReginParams.class);
		//获取当前登录人公司
		String orgCode= reginParams.getCompany().getOrgCode();
		DispatchPaper dispatchPaper = dispatchPaperFormDto.getDispatchPaper();
		dispatchPaper.setOrgCode(orgCode);
		dispatchPaperFormDto.setDispatchPaper(dispatchPaper);
		dispatchPaperFormDto = dispatchPaperServiceImpl.createDispatchPaper(dispatchPaperFormDto);
	    return ResponseHelper.buildResponse(dispatchPaperFormDto);
	}

	/**
	 * 根据警情id查询
	 *
	 * @param id
	 * @return
	 */
	@TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/alert/{id}")
	@ApiOperation(httpMethod = "GET", value = "根据警情id查询", notes = "根据警情id查询")
	public ResponseModel<Object> selectById(@PathVariable Long id) {

		return ResponseHelper.buildResponse(dispatchPaperServiceImpl.selectDispatchPaperDtoByAlertId(id));

	}



	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新派遣单", notes = "根据sequenceNbr更新派遣单")
	public ResponseModel<DispatchPaperDto> updateBySequenceNbrDispatchPaper(@RequestBody DispatchPaperDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(dispatchPaperServiceImpl.updateWithModel(model));
	}




}
