package com.yeejoin.amos.boot.module.tzs.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.DispatchTaskServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tzs.api.dto.DispatchTaskDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 派遣任务
 *
 * @author system_generator
 * @date 2021-08-03
 */
@RestController
@Api(tags = "派遣任务Api")
@RequestMapping(value = "/tzs/dispatch-task")
public class DispatchTaskController extends BaseController {

    @Autowired
    DispatchTaskServiceImpl dispatchTaskServiceImpl;

    /**
     * 新增派遣任务
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增派遣任务", notes = "新增派遣任务")
	public ResponseModel<Boolean> save(@RequestBody DispatchTaskDto model) {
		Boolean flag = dispatchTaskServiceImpl.createDispatchTask(model);
	    return ResponseHelper.buildResponse(flag);
	}

	/**
	 * 根据派遣单位类型和警情id 获取任务模板
	 * @param orgTypeCode
	 * @param alertId
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{orgTypeCode}/{alertId}")
	@ApiOperation(httpMethod = "GET",value = "根据派遣单位类型和警情id 获取任务信息",  notes = "根据派遣单位类型和警情id 获取任务信息")
	public ResponseModel<DispatchTaskDto> selectOne(@PathVariable String orgTypeCode, @PathVariable Long alertId) {
		return ResponseHelper.buildResponse(dispatchTaskServiceImpl.getTaskInfo(orgTypeCode,alertId));
	}

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个派遣任务",  notes = "根据sequenceNbr查询单个派遣任务")
	public ResponseModel<DispatchTaskDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(dispatchTaskServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "派遣任务分页查询",  notes = "派遣任务分页查询")
	public ResponseModel<Page<DispatchTaskDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<DispatchTaskDto> page = new Page<DispatchTaskDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(dispatchTaskServiceImpl.queryForDispatchTaskPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "派遣任务列表全部数据查询",   notes = "派遣任务列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<DispatchTaskDto>> selectForList() {
	    return ResponseHelper.buildResponse(dispatchTaskServiceImpl.queryForDispatchTaskList());
	}
}
