package com.yeejoin.amos.boot.module.tzs.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.RescueProcessServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tzs.api.dto.RescueProcessDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 救援过程表
 *
 * @author system_generator
 * @date 2021-08-03
 */
@RestController
@Api(tags = "救援过程表Api")
@RequestMapping(value = "/tzs/rescue-process")
public class RescueProcessController extends BaseController {

    @Autowired
    RescueProcessServiceImpl rescueProcessServiceImpl;

    /**
     * 新增救援过程表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增救援过程表", notes = "新增救援过程表")
	public ResponseModel<RescueProcessDto> save(@RequestBody RescueProcessDto model) {
	    model = rescueProcessServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新救援过程表", notes = "根据sequenceNbr更新救援过程表")
	public ResponseModel<RescueProcessDto> updateBySequenceNbrRescueProcess(@RequestBody RescueProcessDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(rescueProcessServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除救援过程表", notes = "根据sequenceNbr删除救援过程表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(rescueProcessServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个救援过程表",  notes = "根据sequenceNbr查询单个救援过程表")
	public ResponseModel<RescueProcessDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(rescueProcessServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "救援过程表分页查询",  notes = "救援过程表分页查询")
	public ResponseModel<Page<RescueProcessDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<RescueProcessDto> page = new Page<RescueProcessDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(rescueProcessServiceImpl.queryForRescueProcessPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "救援过程表列表全部数据查询",   notes = "救援过程表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<RescueProcessDto>> selectForList() {
	    return ResponseHelper.buildResponse(rescueProcessServiceImpl.queryForRescueProcessList());
	}
}
