package com.yeejoin.amos.boot.module.tzs.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.VoiceRecordFileServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tzs.api.dto.VoiceRecordFileDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 通话记录附件
 *
 * @author system_generator
 * @date 2021-08-03
 */
@RestController
@Api(tags = "通话记录附件Api")
@RequestMapping(value = "/tzs/voice-record-file")
public class VoiceRecordFileController extends BaseController {

    @Autowired
    VoiceRecordFileServiceImpl voiceRecordFileServiceImpl;

    /**
     * 新增通话记录附件
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增通话记录附件", notes = "新增通话记录附件")
	public ResponseModel<VoiceRecordFileDto> save(@RequestBody VoiceRecordFileDto model) {
	    model = voiceRecordFileServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新通话记录附件", notes = "根据sequenceNbr更新通话记录附件")
	public ResponseModel<VoiceRecordFileDto> updateBySequenceNbrVoiceRecordFile(@RequestBody VoiceRecordFileDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(voiceRecordFileServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除通话记录附件", notes = "根据sequenceNbr删除通话记录附件")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(voiceRecordFileServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个通话记录附件",  notes = "根据sequenceNbr查询单个通话记录附件")
	public ResponseModel<VoiceRecordFileDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(voiceRecordFileServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "通话记录附件分页查询",  notes = "通话记录附件分页查询")
	public ResponseModel<Page<VoiceRecordFileDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<VoiceRecordFileDto> page = new Page<VoiceRecordFileDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(voiceRecordFileServiceImpl.queryForVoiceRecordFilePage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "通话记录附件列表全部数据查询",   notes = "通话记录附件列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<VoiceRecordFileDto>> selectForList() {
	    return ResponseHelper.buildResponse(voiceRecordFileServiceImpl.queryForVoiceRecordFileList());
	}
}
