package com.yeejoin.amos.boot.module.tzs.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tzs.api.dto.AlertFormInitDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.DispatchPaperDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.DispatchPaperFormDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.AlertFormValue;
import com.yeejoin.amos.boot.module.tzs.api.entity.DispatchPaper;
import com.yeejoin.amos.boot.module.tzs.api.enums.DispatchPaperEnums;
import com.yeejoin.amos.boot.module.tzs.api.mapper.DispatchPaperMapper;
import com.yeejoin.amos.boot.module.tzs.api.service.IDispatchPaperService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 派遣单服务实现类
 *
 * @author system_generator
 * @date 2021-08-03
 */
@Service
public class DispatchPaperServiceImpl extends BaseService<DispatchPaperDto,DispatchPaper,DispatchPaperMapper> implements IDispatchPaperService {

    @Autowired
    private AlertFormValueServiceImpl iAlertFormValueService;

    @Autowired
    private AlertFormServiceImpl alertFormServiceImpl;

    /**
     * 分页查询
     */
    public Page<DispatchPaperDto> queryForDispatchPaperPage(Page<DispatchPaperDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<DispatchPaperDto> queryForDispatchPaperList()   {
        return this.queryForList("" , false);
    }

    /**
     *
     * <pre>
     * 保存派遣单信息
     * </pre>
     *
     * @param dispatchPaperFormDto
     * @return
     */
    @Transactional(rollbackFor = RuntimeException.class)
    public DispatchPaperFormDto createDispatchPaper(DispatchPaperFormDto dispatchPaperFormDto) {
        try {
            // 派遣单基本信息
            DispatchPaper dispatchPaper = dispatchPaperFormDto.getDispatchPaper();
            dispatchPaper.setDispatchTime(new Date());
            dispatchPaper.setIsDelete(false);

            this.save(dispatchPaper);

            // 动态表单
            List<AlertFormValue> paperFormValuelist = dispatchPaperFormDto.getDynamicFormAlert();
            // 填充警情主键
            paperFormValuelist.stream().forEach(paperFormValue -> {
                paperFormValue.setAlertCalledId(dispatchPaper.getSequenceNbr());
                paperFormValue.setAlertTypeCode(DispatchPaperEnums.getEnum(dispatchPaper.getAlertCode()).getDynamicCode());
            });
            // 保存动态表单数据
            iAlertFormValueService.saveBatch(paperFormValuelist);
            dispatchPaperFormDto.setDispatchPaper(dispatchPaper);
            dispatchPaperFormDto.setDynamicFormAlert(paperFormValuelist);

            return dispatchPaperFormDto;
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("派遣失败，系统异常!");
        }
    }

    @Override
    public Object selectDispatchPaperDtoByAlertId(Long alertId) {
        // 根据警情id 获取 派遣单信息
        DispatchPaper dispatchPaper =selectDispatchPaperByAlertId(alertId);
        // 封装dto
        DispatchPaperFormDto dispatchPaperFormDto = new DispatchPaperFormDto();
        dispatchPaperFormDto.setDispatchPaper(dispatchPaper);
        QueryWrapper<AlertFormValue> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("alert_called_id", dispatchPaper.getSequenceNbr()).eq("alert_type_code",dispatchPaper.getAlertCode());
        // 派遣单动态表单数据
        List<AlertFormValue> list = iAlertFormValueService.list(queryWrapper);
        dispatchPaperFormDto.setDynamicFormAlert(list);
        return dispatchPaperFormDto;


    }

    @Override
    public DispatchPaper createDispatchPaper(Long alertId, String alertCode) {

        // 创建基本信息
        DispatchPaper dispatchPaper = new DispatchPaper();
        dispatchPaper.setAlertCode(alertCode);
        dispatchPaper.setAlertId(alertId);

        dispatchPaper.setDispatchTime(new Date());
        dispatchPaper.setIsDelete(false);

        this.save(dispatchPaper);

        // 根据类型创建动态表单信息
        String dynamicCode = DispatchPaperEnums.getEnum(alertCode).getDynamicCode();
        List<AlertFormInitDto>  alertFormInitDtoList = alertFormServiceImpl.getFormlist(dynamicCode);
        List<AlertFormValue> paperFormValuelist = new ArrayList<AlertFormValue>(alertFormInitDtoList.size());
        // 填充警情主键
        alertFormInitDtoList.stream().forEach(initDto -> {
            initDto.getFormItemDescr().setAlertCalledId(dispatchPaper.getSequenceNbr());
            initDto.getFormItemDescr().setAlertTypeCode(DispatchPaperEnums.getEnum(dispatchPaper.getAlertCode()).getDynamicCode());
            paperFormValuelist.add(initDto.getFormItemDescr());
        });
        // 保存动态表单数据
        iAlertFormValueService.saveBatch(paperFormValuelist);
        return dispatchPaper;
    }

    @Override
    public DispatchPaper selectDispatchPaperByAlertId(Long alertId) {
        QueryWrapper<DispatchPaper> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("alert_id", alertId);
        // 警情动态表单数据
        DispatchPaper dispatchPaper  = this.getOne(queryWrapper);
        return dispatchPaper;
    }

}