package com.yeejoin.amos.boot.module.tzs.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tzs.api.dto.AlertCalledDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.DispatchTaskDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.DispatchPaper;
import com.yeejoin.amos.boot.module.tzs.api.entity.DispatchTask;
import com.yeejoin.amos.boot.module.tzs.api.entity.Elevator;
import com.yeejoin.amos.boot.module.tzs.api.mapper.DispatchTaskMapper;
import com.yeejoin.amos.boot.module.tzs.api.service.IDispatchTaskService;
import com.yeejoin.amos.boot.module.tzs.biz.utils.BeanDtoVoUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;

/**
 * 派遣任务服务实现类
 *
 * @author system_generator
 * @date 2021-08-03
 */
@Service
public class DispatchTaskServiceImpl extends BaseService<DispatchTaskDto,DispatchTask,DispatchTaskMapper> implements IDispatchTaskService {


    @Autowired
    DispatchPaperServiceImpl dispatchPaperServiceImpl;

    @Autowired
    AlertCalledServiceImpl alertCalledServiceImpl;

    @Autowired
    ElevatorServiceImpl elevatorServiceImpl;

    /**
     * 分页查询
     */
    public Page<DispatchTaskDto> queryForDispatchTaskPage(Page<DispatchTaskDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<DispatchTaskDto> queryForDispatchTaskList()   {
        return this.queryForList("" , false);
    }

    @Override
    public Boolean createDispatchTask(DispatchTaskDto dispatchTaskDto) {
        boolean flag = false;
        // 判断派遣单是否存在 如果不存在先创建派遣单
        DispatchPaper dispatchPaper = dispatchPaperServiceImpl.selectDispatchPaperByAlertId(dispatchTaskDto.getAlertId());
        if(dispatchPaper == null) {
            dispatchPaper = dispatchPaperServiceImpl.createDispatchPaper(dispatchTaskDto.getAlertId(), dispatchTaskDto.getAlertCode());
        }
        // 创建派遣单
        DispatchTask dispatchTask = BeanDtoVoUtils.convert(dispatchTaskDto, DispatchTask.class);
        dispatchTask.setPaperId(dispatchPaper.getSequenceNbr());
        flag = this.save(dispatchTask);
        return flag;
    }

    @Override
    public DispatchTaskDto getTaskInfo(String orgTypeCode, Long alertId) {
        DispatchTaskDto dispatchTaskDto = new DispatchTaskDto();
        // 根据类型和警情带出负责人信息
        AlertCalledDto alertCalledDto = alertCalledServiceImpl.queryBySeq(alertId);
        // 设备类型 和 编码 确定设备的使用单位或者维保单位
        String getEquipmentClassificationCode = alertCalledDto.getEquipmentClassificationCode();
        String deviceId = alertCalledDto.getDeviceId();

        // 目前只有电梯类型
        QueryWrapper<Elevator> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("rescue_code", deviceId);
        // 警情动态表单数据
        Elevator elevator  = elevatorServiceImpl.getOne(queryWrapper);

        dispatchTaskDto.setOrgTypeCode(orgTypeCode);
        dispatchTaskDto.setAlertId(alertId);
        switch (orgTypeCode) {
            case "useUnit": // 使用单位
            case "levelOneUnit": // 一级响应
                dispatchTaskDto.setResponseOrgId(elevator.getUseUnitId());
                dispatchTaskDto.setResponseOrgName(elevator.getUseUnit());
                break;
            case "repairUnit": // 维保单位
            case "levelTwoUnit": // 二级响应
                dispatchTaskDto.setResponseOrgId(elevator.getMaintainUnitId());
                dispatchTaskDto.setResponseOrgName(elevator.getMaintainUnit());
                dispatchTaskDto.setResponseUserId(elevator.getMaintainLeaderId());
                dispatchTaskDto.setResponseUserName(elevator.getMaintainLeader());
                dispatchTaskDto.setResponseUserTel(elevator.getMaintainLeaderPhone());
                break;
            case "levelThreeUnit": // 三级响应

                break;
        }

        // 获取模板 拼接json


        return null;
    }
}