package com.yeejoin.equipmanage.common.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;




public interface ImportFile {
	
	long importFile(Workbook book) throws UploadException;
	
	Workbook downloadImportFile();
	
	/**
	 * 判断给定列中，是否有重复数据
	 * 
	 * @param sheet
	 * @param cellNum
	 * @param startRow
	 */
	default void duplicateCellCheck(Sheet sheet, int cellNum, int startRow) throws UploadException {
		List<String> value_1 = new ArrayList<>();
		Set<String> value_2 = new HashSet<>();
		if (sheet.getLastRowNum() < startRow) {
			return;
		}
		for(int i = startRow; i <= sheet.getLastRowNum(); i++) {
			Row row = sheet.getRow(i);
			if (cellNum > row.getLastCellNum()) {
				return;
			}
			
			Cell cell = row.getCell(cellNum);
			
			if (cell.getCellType() == HSSFCell.CELL_TYPE_STRING) {
				if (null != cell && StringUtil.isNotEmpty(cell.getStringCellValue())) {
					ParsePropertyUtil.setting(value_1::add, () -> cell.getStringCellValue());
					ParsePropertyUtil.setting(value_2::add, () -> cell.getStringCellValue());
				}
			
			}  else {
				throw new UploadException("请严格按照模板来上传！");
			}
			
			
			
		}
		
		if (value_1.size() != value_2.size()) {
			value_2.forEach(v -> value_1.remove(v));
			throw new UploadException(String.format("上传的excel中的%s是重复数据，请修改后重新上传！", value_1));
		}
	}
}

