package com.yeejoin.equipmanage.controller;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.equipmanage.common.entity.dto.TopographyLineDTO;
import com.yeejoin.equipmanage.common.entity.dto.TopographyNodeDTO;
import com.yeejoin.equipmanage.common.entity.dto.TopographyTreeDTO;
import com.yeejoin.equipmanage.common.enums.TopoNodeTypeEnum;
import com.yeejoin.equipmanage.service.impl.TopographyService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author 子杨
 * @since 2021-10-14
 */

@RestController
@Api(tags = "网络拓扑Api")
@RequestMapping(value = "/topography")
public class TopographyController
{

	private final Logger logger = LogManager.getLogger(TopographyController.class);
	
	@Autowired
	private TopographyService topographyService;

//	/**
//     * 拓扑图-树
//     *
//     * @param type 节点类型
//     * @return 
//     */
//    @TycloudOperation(ApiLevel = UserType.AGENCY)
//    @ApiOperation(value = "拓扑图-树", notes = "拓扑图-树")
//    @RequestMapping(value = "/tree", method = RequestMethod.GET)
//    public ResponseModel<List<TopographyTreeDTO>> tree() {
//    	//获取当前登录人的公司code
//    	ReginParams reginParams	=getSelectedOrgInfo();
//    	List<TopographyTreeDTO> list = topographyService.getTree(reginParams.getCompany().getOrgCode(),TopoNodeTypeEnum.PAMS.getType());
//        return ResponseHelper.buildResponse(list);
//    }
//    
//    
//    /**
//     * 拓扑图
//     *
//     * @param type 节点类型
//     * @return 
//     */
//    @GetMapping(value = "/nodes/{treeid}", produces = "application/json;charset=UTF-8")
//    @TycloudOperation(ApiLevel = UserType.AGENCY)
//    @ApiOperation(value = "拓扑图", notes = "拓扑图")
//    public ResponseModel<Map<String,Object>>  getNodesByTreeid(@ApiParam(value = "树id", required = false) @PathVariable String treeid) {
//    	//获取当前登录人的公司code
//    	ReginParams reginParams	=getSelectedOrgInfo();	
//    	List<TopographyNodeDTO> nodes = topographyService.getNodes(reginParams.getCompany().getOrgCode(),treeid,TopoNodeTypeEnum.PAMS.getType());
//    	List<TopographyLineDTO> links = topographyService.getLinks(reginParams.getCompany().getOrgCode(),treeid,TopoNodeTypeEnum.PAMS.getType());
//    	Map<String,Object> results = new HashMap<>();
//    	results.put("nodeData", nodes);
//    	results.put("linkData", links);
//    	return ResponseHelper.buildResponse(results);
//    }
//    
//    /**
//     * 自建系统树
//     *
//     * @param type 节点类型
//     * @return 
//     */
//    @GetMapping(value = "/selftree", produces = "application/json;charset=UTF-8")
//    @TycloudOperation(ApiLevel = UserType.AGENCY)
//    @ApiOperation(value = "拓扑图-树", notes = "拓扑图-树")
//    public CommonResponse selfTree() {
//    	//获取当前登录人的公司code
//    	ReginParams reginParams	=getSelectedOrgInfo();
//    	List<TopographyTreeDTO> list = topographyService.getTree(reginParams.getCompany().getOrgCode(),TopoNodeTypeEnum.自建系统.getType());
//        return ResponseHelper.buildResponse(list);
//    }
//    
//    /**
//     * 自建系统拓扑图
//     *
//     * @param type 节点类型
//     * @return 
//     */
//    @GetMapping(value = "/selfnodes/{treeid}", produces = "application/json;charset=UTF-8")
//    @TycloudOperation(ApiLevel = UserType.AGENCY)
//    @ApiOperation(value = "拓扑图", notes = "拓扑图")
//    public CommonResponse getSelfNodesByTreeid(@ApiParam(value = "树id", required = false) @PathVariable String treeid) {
//    	//获取当前登录人的公司code
//    	ReginParams reginParams	=getSelectedOrgInfo();	
//    	List<TopographyNodeDTO> nodes = topographyService.getNodes("%#"+reginParams.getCompany().getOrgCode(),treeid,TopoNodeTypeEnum.自建系统.getType());
//    	List<TopographyLineDTO> links = topographyService.getLinks(reginParams.getCompany().getOrgCode(),treeid,TopoNodeTypeEnum.自建系统.getType());
//    	Map<String,Object> results = new HashMap<>();
//    	results.put("nodeData", nodes);
//    	results.put("linkData", links);
//    	return ResponseHelper.buildResponse(results);
//    }
//    
//    
//    /**
//     * 保存自建系统
//     *
//     * @param type 节点类型
//     * @return 
//     */
//    @PostMapping(value = "/selfnodes", produces = "application/json;charset=UTF-8")
//    @TycloudOperation(ApiLevel = UserType.AGENCY)
//    @ApiOperation(value = "保存动环拓扑图", notes = "保存动环拓扑图")
//    public CommonResponse saveselfnodes(@ApiParam(value = "", required = false) @RequestBody JSONObject topography) {
//    	JSONArray nodes = topography.getJSONArray("nodeData");
//    	List<TopographyNodeDTO> nodeData = JSON.parseArray(JSON.toJSONString(nodes), TopographyNodeDTO.class);
//    	
//    	        //获取当前登录人的公司code
//    			ReginParams reginParams	=getSelectedOrgInfo();
//    			if(reginParams.getDepartment()!=null){
//    				topographyService.saveNodes(topographyService.getSelfOrgCode(),nodeData);
//    			}else{
//    				topographyService.saveNodes(topographyService.getSelfOrgCode(),nodeData);
//    				
//    			}
//    	
//    	return ResponseHelper.buildResponse();
//    }
//    
//    
//    /**
//     * 保存拓扑图
//     *
//     * @param type 节点类型
//     * @return 
//     */
//    @PostMapping(value = "/nodes", produces = "application/json;charset=UTF-8")
//    @TycloudOperation(ApiLevel = UserType.AGENCY)
//    @ApiOperation(value = "保存拓扑图", notes = "保存拓扑图")
//    public CommonResponse saveNodes(@ApiParam(value = "", required = false) @RequestBody JSONObject topography) {
//    	JSONArray nodes = topography.getJSONArray("nodeData");
//    	List<TopographyNodeDTO> nodeData = JSON.parseArray(JSON.toJSONString(nodes), TopographyNodeDTO.class);
//    	 //获取当前登录人的公司code
//		ReginParams reginParams	=getSelectedOrgInfo();
//		if(reginParams.getDepartment()!=null){
//			topographyService.saveNodes(reginParams.getDepartment().getOrgCode(),nodeData);
//		}else{
//			topographyService.saveNodes(reginParams.getCompany().getOrgCode(),nodeData);
//			
//		}    	
//		return ResponseHelper.buildResponse();
//    }
//    
//    /**
//     * 异常
//     *
//     * @return 
//     * @throws Exception 
//     */
//    @PostMapping(value = "/testAbnormal", produces = "application/json;charset=UTF-8")
//    @TycloudOperation(ApiLevel = UserType.AGENCY)
//    @ApiOperation(value = "推送异常", notes = "推送异常")
//    public CommonResponse testAbnormal(@RequestBody AbnormalParam param) throws Exception {
//    	topographyService.testAbnormal(param);
//        return ResponseHelper.buildResponse();
//    }
    
    /**
     * 网络拓扑图-树
     *
     * @param type 节点类型
     * @return 
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "网络拓扑图-树", notes = "网络拓扑图-树")
    @RequestMapping(value = "/webTree", method = RequestMethod.GET)
    public ResponseModel<Collection<TopographyTreeDTO>> webTree() {  	
    	//获取当前登录人的公司code
    	Collection<TopographyTreeDTO> list = topographyService.getTree(TopoNodeTypeEnum.网络拓扑图.getType());
        return ResponseHelper.buildResponse(list);
    }
    
    /**
     * 网络拓扑图
     *
     * @param type 节点类型
     * @return 
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "网络拓扑图", notes = "拓扑图")
    @RequestMapping(value = "/webNodes/{treeid}", method = RequestMethod.GET)
    public ResponseModel<Map<String,Object>> webNodes(@ApiParam(value = "树id", required = false) @PathVariable String treeid) {
    	
    	//获取当前登录人的公司code
    	List<TopographyNodeDTO> nodes = topographyService.getNodes(treeid, TopoNodeTypeEnum.网络拓扑图.getType());
    	List<TopographyLineDTO> links = topographyService.getLinks(treeid, TopoNodeTypeEnum.网络拓扑图.getType());
    	Map<String,Object> results = new HashMap<>();
    	results.put("nodeData", nodes);
    	results.put("linkData", links);
    	return ResponseHelper.buildResponse(results);
    }
    
//    @DeleteMapping("/webTree/{treeid}")
//	    @TycloudOperation(ApiLevel = UserType.AGENCY)
//    @ApiOperation(value = "删除树数据", notes = "删除树数据")
//	public CommonResponse delWebTree(@ApiParam(value = "树id", required = false) @PathVariable String treeid) {
//    	topographyService.delWebTree(treeid);
//    	//获取当前登录人的公司code
//    	ReginParams reginParams	=getSelectedOrgInfo();
//		return ResponseHelper.buildResponse(topographyService.getTree(reginParams.getCompany().getOrgCode(),TopoNodeTypeEnum.网络拓扑图.getType()));
//	}
//	
//	@PostMapping("/addWebTree")
//	    @TycloudOperation(ApiLevel = UserType.AGENCY)
//    @ApiOperation(value = "添加树数据", notes = "添加树数据")
//	public CommonResponse addWebTree(@RequestBody TopographyTreeDTO tree) {
//		//获取当前登录人的公司code
//		ReginParams reginParams	=getSelectedOrgInfo();
//		if(reginParams.getDepartment()!=null){
//			tree.setOrgCode(reginParams.getDepartment().getOrgCode());
//		}else{
//			tree.setOrgCode(reginParams.getCompany().getOrgCode());
//		}
//		
//		topographyService.addWebTree(tree);
//		
//		return ResponseHelper.buildResponse(topographyService.getTree(reginParams.getCompany().getOrgCode(),TopoNodeTypeEnum.网络拓扑图.getType()));
//	}
	
	/**
     * 保存网络拓扑图
     *
     * @param type 节点类型
     * @return 
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "保存网络拓扑图", notes = "保存网络拓扑图")
    @RequestMapping(value = "/webNodes", method = RequestMethod.POST)
    public ResponseModel<Boolean> saveWebNodes(@ApiParam(value = "", required = false) @RequestBody JSONObject topography) {
    	JSONArray nodes = topography.getJSONArray("nodeData");
    	List<TopographyNodeDTO> nodeData = JSON.parseArray(JSON.toJSONString(nodes), TopographyNodeDTO.class);
		topographyService.saveNodes(nodeData);
    	return ResponseHelper.buildResponse(true);
    }
    
    /**
     * 节点详情
     *
     * @param type 节点类型
     * @return 
     */
    @SuppressWarnings("rawtypes")
	    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "节点详情", notes = "节点详情")
    @RequestMapping(value = "/nodeDetail/{nodeid}", method = RequestMethod.GET)
    public ResponseModel<List<Map>> nodeDetail(@ApiParam(value = "nodeid", required = false) @PathVariable String nodeid) {
    	List<Map> nodeDetail = topographyService.getNodeDetail(nodeid);
    	return ResponseHelper.buildResponse(nodeDetail);
    }
    
//    /**
//     * 动环拓扑图-树
//     *
//     * @param type 节点类型
//     * @return 
//     */
//    @GetMapping(value = "/donghuanTree", produces = "application/json;charset=UTF-8")
//    @TycloudOperation(ApiLevel = UserType.AGENCY)
//    @ApiOperation(value = "动环拓扑图-树", notes = "动环拓扑图-树")
//    public CommonResponse donghuanTree() {
//    	//获取当前登录人的公司code
//    	ReginParams reginParams	=getSelectedOrgInfo();
//    	List<TopographyTreeDTO> list = topographyService.getTree("%#"+reginParams.getCompany().getOrgCode(),TopoNodeTypeEnum.动环监控.getType());
//        return ResponseHelper.buildResponse(list);
//    }
//    
//    /**
//     * 动环拓扑图
//     *
//     * @param type 节点类型
//     * @return 
//     */
//    @GetMapping(value = "/donghuanNodes/{treeid}", produces = "application/json;charset=UTF-8")
//    @TycloudOperation(ApiLevel = UserType.AGENCY)
//    @ApiOperation(value = "动环拓扑图", notes = "拓扑图")
//    public CommonResponse donghuanNodes(@ApiParam(value = "树id", required = false) @PathVariable String treeid) {
//    	//获取当前登录人的公司code
//    	ReginParams reginParams	=getSelectedOrgInfo();
//    	List<TopographyNodeDTO> nodes = topographyService.getNodes("%#"+reginParams.getCompany().getOrgCode(),treeid,TopoNodeTypeEnum.动环监控.getType());
//    	List<TopographyLineDTO> links = topographyService.getLinks(reginParams.getCompany().getOrgCode(),treeid,TopoNodeTypeEnum.动环监控.getType());
//    	Map<String,Object> results = new HashMap<>();
//    	results.put("nodeData", nodes);
//    	results.put("linkData", links);
//    	return ResponseHelper.buildResponse(results);
//    }
//    
//    /**
//     * 保存动环拓扑图
//     *
//     * @param type 节点类型
//     * @return 
//     */
//    @PostMapping(value = "/donghuanNodes", produces = "application/json;charset=UTF-8")
//    @TycloudOperation(ApiLevel = UserType.AGENCY)
//    @ApiOperation(value = "保存动环拓扑图", notes = "保存动环拓扑图")
//    public CommonResponse savedonghuanNodes(@ApiParam(value = "", required = false) @RequestBody JSONObject topography) {
//    	JSONArray nodes = topography.getJSONArray("nodeData");
//    	List<TopographyNodeDTO> nodeData = JSON.parseArray(JSON.toJSONString(nodes), TopographyNodeDTO.class);
//    	
//    	       //获取当前登录人的公司code
//    			ReginParams reginParams	=getSelectedOrgInfo();
//    			if(reginParams.getDepartment()!=null){
//    				topographyService.saveNodes(topographyService.getSelfOrgCode(),nodeData);
//    			}else{
//    				topographyService.saveNodes(topographyService.getSelfOrgCode(),nodeData);
//    				
//    			}
//    	
//    	return ResponseHelper.buildResponse();
//    }
//    
//    /**
//     * 获取设备监控拓扑图
//     *
//     * @param type 节点类型
//     * @return 
//     */
//    @GetMapping(value = "/deviceNodes", produces = "application/json;charset=UTF-8")
//    @TycloudOperation(ApiLevel = UserType.AGENCY)
//    @ApiOperation(value = "设备监控拓扑图", notes = "设备监控拓扑图")
//    public CommonResponse deviceNodes() {
//    	//获取当前登录人的公司code
//    	ReginParams reginParams	=getSelectedOrgInfo();
//    	List<Map> nodes = topographyService.getDeviceNodes(reginParams.getCompany().getOrgCode());    	
//    	List<TopographyLineDTO> links = topographyService.getDeviceLinks(reginParams.getCompany().getOrgCode());
//    	Map<String,Object> results = new HashMap<>();
//    	results.put("nodeData", nodes);
//    	results.put("linkData", links);
//    	return ResponseHelper.buildResponse(results);
//    }
//    
//    /**
//     * 保存设备监控拓扑图
//     *
//     * @param type 节点类型
//     * @return 
//     */
//    @PostMapping(value = "/deviceNodes", produces = "application/json;charset=UTF-8")
//    @TycloudOperation(ApiLevel = UserType.AGENCY)
//    @ApiOperation(value = "保存设备监控拓扑图", notes = "保存设备监控拓扑图")
//    public CommonResponse saveDeviceNodes(@ApiParam(value = "", required = false) @RequestBody JSONObject topography) {
//    	JSONArray nodes = topography.getJSONArray("nodeData");
//    	List<TopographyNodeDTO> nodeData = JSON.parseArray(JSON.toJSONString(nodes), TopographyNodeDTO.class);
//    	
//    	
//    	//获取当前登录人的公司code
//		ReginParams reginParams	=getSelectedOrgInfo();
//		if(reginParams.getDepartment()!=null){
//			topographyService.saveNodes(topographyService.getSelfOrgCode(),nodeData);
//		}else{
//			topographyService.saveNodes(topographyService.getSelfOrgCode(),nodeData);
//			
//		}
//    	return ResponseHelper.buildResponse();
//    }
//
//	/**
//	 *查询-树
//	 *
//	 * @param type 类型
//	 * @return
//	 */
//	@GetMapping(value = "/treeByType/{type}", produces = "application/json;charset=UTF-8")
//	    @TycloudOperation(ApiLevel = UserType.AGENCY)
//    @ApiOperation(value = "查询-树", notes = "查询-树")
//	public CommonResponse treeByType(@ApiParam(value = "查询类型：1-网络拓扑图；2-PAMS；3-动环监控；4-设备监控；5-自建系统；6-金融城域网；7-虚拟云平台监控", required = true)
//										 @PathVariable int type) {
//		//获取当前登录人的公司code
//		ReginParams reginParams	=getSelectedOrgInfo();
//		List<TopographyTreeDTO> list = topographyService.getTree("%#"+reginParams.getCompany().getOrgCode(), type);
//		return ResponseHelper.buildResponse(list);
//	}
//
//	/**
//	 * 查询拓扑图
//	 *
//	 * @param type 节点类型
//	 * @return
//	 */
//	@GetMapping(value = "/getNodesByTypeAndTreeId/{type}/{treeId}", produces = "application/json;charset=UTF-8")
//	    @TycloudOperation(ApiLevel = UserType.AGENCY)
//    @ApiOperation(value = "拓扑图", notes = "拓扑图")
//	public CommonResponse getNodesByTypeAndTreeId(@ApiParam(value = "类型", required = true) @PathVariable int type,
//			@ApiParam(value = "树id", required = false) @PathVariable String treeId) {
//		//获取当前登录人的公司code
//		ReginParams reginParams	=getSelectedOrgInfo();
//		List<TopographyNodeDTO> nodes = topographyService.getNodes("%#" + reginParams.getCompany().getOrgCode(),treeId,type);
//		List<TopographyLineDTO> links = topographyService.getLinks("%#" + reginParams.getCompany().getOrgCode(),treeId,type);
//		Map<String,Object> results = new HashMap<>();
//		results.put("nodeData", nodes);
//		results.put("linkData", links);
//		return ResponseHelper.buildResponse(results);
//	}
//
//	/**
//	 * 保存自建系统
//	 *
//	 * @param type 节点类型
//	 * @return
//	 */
//	@PostMapping(value = "/saveNodesByType/{type}", produces = "application/json;charset=UTF-8")
//	    @TycloudOperation(ApiLevel = UserType.AGENCY)
//    @ApiOperation(value = "保存动环拓扑图", notes = "保存动环拓扑图")
//	public CommonResponse saveNodesByType(@ApiParam(value = "类型", required = true) @PathVariable int type,
//										  @ApiParam(value = "", required = false) @RequestBody JSONObject topography) {
//		JSONArray nodes = topography.getJSONArray("nodeData");
//		List<TopographyNodeDTO> nodeData = JSON.parseArray(JSON.toJSONString(nodes), TopographyNodeDTO.class);
//		//获取当前登录人的公司code
//		ReginParams reginParams	=getSelectedOrgInfo();
//		if(reginParams.getDepartment()!=null){
//			topographyService.saveNodes(topographyService.getSelfOrgCode(),nodeData);
//		}else{
//			topographyService.saveNodes(topographyService.getSelfOrgCode(),nodeData);
//		}
//		return CommonResponseUtil.success();
//	}
	
}
