package com.yeejoin.equipmanage.fegin;

import java.util.List;
import java.util.Map;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.feign.MultipartSupportConfig;
import com.yeejoin.equipmanage.common.dto.MenuFromDto;
import com.yeejoin.equipmanage.common.dto.UserDto;
import com.yeejoin.equipmanage.common.dto.WaterResourceDto;
import com.yeejoin.equipmanage.common.dto.WaterResourceTypeDto;

/**
 * @ProjectName: EquipManageRoot
 * @Package: com.yeejoin.equipmanage.fegin
 * @ClassName: JcsFeign
 * @Author: Jianqiang Gao
 * @Description: JcsFeign
 * @Date: 2021/7/20 10:39
 * @Version: 1.0
 */
@FeignClient(name = "${jcs.fegin.name}", configuration = {MultipartSupportConfig.class})
public interface JcsFeign {

    @RequestMapping(value = "/jcs/water-resource/select_list", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel<List<WaterResourceDto>> selectList(
    		@RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token,
            @RequestParam(value = "name", required = false) String name, 
            @RequestParam(value = "sequenceNbr", required = false) Long sequenceNbr,
            @RequestParam(value = "belongFightingSystemId", required = false) Long belongFightingSystemId, 
            @RequestParam(value = "belongBuildingId", required = false) Long belongBuildingId,
            @RequestParam(value = "belongBuilding", required = false) String belongBuilding, 
            @RequestParam(value = "resourceType", required = false) String resourceType);

    @RequestMapping(value = "/jcs/water-resource/page", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel<Page<WaterResourceDto>> queryForPage(
    		@RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token,
            @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int size,
            @RequestParam(value = "name") String name,
            @RequestParam(value = "belongBuildingId") List<Long> belongBuildingId,
            @RequestParam(value = "belongFightingSystemId")  Long belongFightingSystemId,
            @RequestParam(value = "sequenceNbr")  Long sequenceNbr,
            @RequestParam(value = "classifyId")  String classifyId
    );

    @RequestMapping(value = "/jcs/equip/fireSystem_waterResource/list", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel<List<MenuFromDto>> getFireSystemWaterResourceList(
    		@RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token
    );

    @RequestMapping(value = "/jcs/water-resource/resource_type_list", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel<List<WaterResourceTypeDto>> selectResourceTypeList(
    		@RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token
    );

    @RequestMapping(value = "/jcs/common/maintenance-company/companyList", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel<List<Map<String, Object>>> selectCompanyList(
    		@RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token
    );

    @RequestMapping(value = "/jcs/org-usr/{userId}/userInfo", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel<List<UserDto>> getUserInfo(
            @RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token,
            @PathVariable(value = "userId")  String userId);

    @RequestMapping(value = "/jcs/excel/exportForEquipment", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel<String[]> getEquipmentInfo(
            @RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token,
            @RequestParam(value = "type", required = false) String type,
            @RequestParam(value = "method", required = false) String method);
    
    /**
     * 
     * <pre>
     * 根据值班区域ID查询当前值班人
     * </pre>
     *
     * @param dutyAreaId
     * @return
     */
    @RequestMapping(value = "/jcs/common/duty-person/findByDutyAreaId/{dutyAreaId}", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel<Object> findByDutyAreaId(@PathVariable(value = "dutyAreaId") Long dutyAreaId);

    /**
     * 获取机场单位
     */
    @RequestMapping(value = "/jcs/org-usr/getUnit/{id}", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel<JSONObject> getUnitById(
            @RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token,
            @PathVariable(value = "id")  String id);

    /**
     * 获取机场人员
     * @return
     */
    @RequestMapping(value = "/jcs/org-person/getPersonByUserId/{userId}", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel<JSONObject> getPersonByUserId(
            @RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token,
            @PathVariable(value = "userId")  String userId);
}
