package com.yeejoin.equipmanage.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.equipmanage.common.entity.*;
import com.yeejoin.equipmanage.common.entity.vo.BuildingListVO;
import com.yeejoin.equipmanage.common.entity.vo.EquiplistSpecificBySystemVO;
import com.yeejoin.equipmanage.common.entity.vo.PointTreeVo;
import com.yeejoin.equipmanage.common.vo.BuildingTreeAndEquipVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @author ZeHua Li
 * @date 2020/11/12 15:38
 * @since v2.0
 */
@Mapper
public interface BuildingMapper extends BaseMapper<Building> {
    /**
     * 获取建筑分类新增页面的装备分类列表
     * (该接口未使用)
     * @param code
     * @return
     */
    List<EquipmentCategory> getFireArchitectureEnumList(String code);
    IPage<BuildingListVO> getExamineList(IPage<Building> page, Long regionId);


    /**
     * 绑定建筑和画布关系
     * @param map
     * @return
     */
    int insetSourceScene(Map<String ,Object > map);

    /**
     * 插入建筑画布绑定装备
     * @param sceneId
     * @param pointInScene
     * @return
     */
    int setSceneId(@Param("sceneId") Long sceneId, @Param("pointInScene")String pointInScene,@Param("videoInScene")String videoInScene);

    /**
     * 获取建筑画布下装备id
     * @param id
     * @return
     */
    String getPointInScene(Long id);

    String getVPointInScene(Long id);

    /**
     * 获取建筑画布下装备
     * @param ids
     * @return
     */
    List<EquiplistSpecificBySystemVO> getEquipBySceneId( @Param("ids") String[] ids);
    List<EquiplistSpecificBySystemVO> getVideoBySceneId( @Param("ids") String[] ids);
    /**
     * 根据类型获取名下画布集合
     * @param id
     * @param groupType
     * @return
     */
    List<SourceScene> getScenesList(@Param("id")Long id, @Param("groupType")String groupType);

    /**
     * 获取建筑树主干
     * @return
     */
    List<PointTreeVo> getBuildList();

    /**
     * 获取建筑树主干
     * @return
     */
    List<PointTreeVo> get3dBuildList();

    /**
     * 确定房间绑定关系（归属楼层还是建筑）
     * @param id
     * @return
     */
    Long isBuildingRoom(@Param("id")Long id);

    /**
     * 获取库存装备
     * @param id
     * @param groupType
     * @return
     */
    Long getEquipmentCount(@Param("id")Long id, @Param("groupType")String groupType);

    /**
     * 获取房间数或楼层数
     * @param id
     * @param groupType
     * @return
     */
    Long  getFloorOrRoomCount(@Param("id")Long id, @Param("groupType")String groupType);

    /**
     * 获取房间树
     * @param id
     * @return
     */
    Long  getRoomCount(@Param("id")Long id );

    /**
     * 获取所有楼层装备数
     * @return
     */
    List<FormInstance> getAllfloorCount(@Param("id")Long id);

    Long selectParentId(Long id);
    String selectSystemId(String  id);
    String getSpeids (Long id);
    WarehouseStructure selectWare(String id);

    /**
     * 获取建筑树和装备
     * @return
     */
    List<BuildingTreeAndEquipVO> getBuildingtreeAndEquip();

    /**
     * 获取建筑树和装备子节点
     * @return
     */
    List<BuildingTreeAndEquipVO> getSonBuildingTree();
    /**
     * 获取建筑树和装备子节点
     * @return
     */
    List<BuildingTreeAndEquipVO> getSonBuildingTree1();
    /**
     * 获取建筑树和装备子节点
     * @return
     */
    List<BuildingTreeAndEquipVO> getSonBuildingTree2();
}
