package com.yeejoin;

import java.net.InetAddress;
import java.net.UnknownHostException;

import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableAsync;
import org.typroject.tyboot.core.restful.exception.GlobalExceptionHandler;

import com.yeejoin.amos.boot.biz.common.utils.oConvertUtils;

@SpringBootApplication
@EnableDiscoveryClient
@MapperScan({ "org.typroject.tyboot.demo.face.orm.dao*", "org.typroject.tyboot.face.*.orm.dao*",
	"org.typroject.tyboot.core.auth.face.orm.dao*", "org.typroject.tyboot.component.*.face.orm.dao*",
	"com.yeejoin.amos.boot.module.*.api.mapper", "com.yeejoin.amos.boot.biz.common.dao.mapper",
	"com.yeejoin.equipmanage.mapper"})
@ComponentScan({"org.typroject", "com.yeejoin.amos", "com.yeejoin.equipmanage"})
@EnableFeignClients
@EnableAsync
public class AmostEquipApplication {

    private static final Logger logger = LoggerFactory.getLogger(AmostEquipApplication.class);

    public static void main(String[] args) throws UnknownHostException {
    	ConfigurableApplicationContext context = SpringApplication.run(AmostEquipApplication.class, args);
		Environment env = context.getEnvironment();
		String ip = InetAddress.getLocalHost().getHostAddress();
		String port = env.getProperty("server.port");
		String path = oConvertUtils.getString(env.getProperty("server.servlet.context-path"));
		GlobalExceptionHandler.setAlwaysOk(true);
		logger.info("\n----------------------------------------------------------\n\t"
				+ "Application Amos-Biz-Boot is running! Access URLs:\n\t" + "Swagger文档: \thttp://" + ip + ":" + port
				+ path + "/doc.html\n" + "----------------------------------------------------------");
    }
}
