package com.yeejoin.amos.api.householdapi.face.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.google.common.collect.Lists;
import com.qiniu.util.Json;
import com.yeejoin.amos.api.householdapi.Utils.GoodWeRequestUtil;
import com.yeejoin.amos.api.householdapi.constant.GoLangConstant;
import com.yeejoin.amos.api.householdapi.constant.GoodWeConstant;
import com.yeejoin.amos.api.householdapi.face.dto.*;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpInverter;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpInverterElectricity;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.hygf.JpStation;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.*;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpInverterElectricityMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpInverterMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.hygf.JpStationMapper;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.tdengine.*;
import com.yeejoin.amos.api.householdapi.face.service.GoodWeDataAcquisitionService;
import com.yeejoin.amos.openapi.enums.PVProducerInfoEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.server.Jsp;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
public class GoodWeDataAcquisitionServiceImpl implements GoodWeDataAcquisitionService {
    @Autowired
    GoodWeRequestUtil goodWeRequestUtil;
    @Autowired
    GoodWeStationMonitorListMapper goodWeStationMonitorListMapper;
    @Autowired
    GoodWeStationDetailMapper goodWeStationDetailMapper;
    @Autowired
    JpStationMapper jpStationMapper;

    @Autowired
    private JpInverterMapper jpInverterMapper;
    @Autowired
    private HYGFJPStationPowerHistoryMapper hygfjpStationPowerHistoryMapper;
    //户用光伏逆变器历史mapper
    @Autowired
    private HYGFJPInverterHistoryMapper hygfjpInverterHistoryMapper;
    //户用光伏采集器历史mapper
    @Autowired
    private HYGFJPCollectorHistoryMapper hygfjpCollectorHistoryMapper;
    //户用光伏逆变器告警
    @Autowired
    private HYGFJPInverterWarnMapper hygfjpInverterWarnMapper;
    //户用光伏逆变器历史mapper
    @Autowired
    private HYGFJPInverterElecHistoryMapper hygfjpInverterElecHistoryMapper;
    //户用光伏日发电量
    @Autowired
    private JpInverterElectricityMapper jpInverterElectricityMapper;
    @Autowired
    private TdHYGFInverterDayGenerateMapper tdHYGFInverterDayGenerateMapper;
    @Autowired
    private TdHYGFInverterMonthGenerateMapper tdHYGFInverterMonthGenerateMapper;
    @Autowired
    private TdHYGFInverterYearGenerateMapper tdHYGFInverterYearGenerateMapper;
    @Autowired
    private HYGFJPDayPowerMapper hygfjpDayPowerMapper;
    @Autowired
    private TdHYGFStationDayGenerateMapper tdHYGFStationDayGenerateMapper;
    @Autowired
    private TdHYGFStationMonthGenerateMapper tdHYGFStationMonthGenerateMapper;
    @Autowired
    private TdHYGFStationYearGenerateMapper tdHYGFStationYearGenerateMapper;

    @Autowired
    private TdHYGFInverterTotalGenerateMapper tdHYGFInverterTotalGenerateMapper;

    @Override
    public void stationList() {
        HashMap<String, Object> requestInfo = new HashMap<>();
        requestInfo.put("page_index", 1);
        requestInfo.put("page_size", 200);
        String requstParam = JSON.toJSONString(requestInfo);
        String today = DateUtil.today();
        String hour = new Date().getHours() + ":00";
        List<GoodWeStationMonitorDto> goodWeStationLists = goodWeRequestUtil.getResPonse(GoodWeConstant.stationListStatusUrl, GoodWeConstant.requestPost, requstParam, GoodWeConstant.resovleRule_data_list, GoodWeStationMonitorDto.class);
        if (goodWeStationLists.size() > 0) {
            goodWeStationLists.forEach(goodWeStationMonitorDto -> {
                GoodWeStationMonitorList goodWeStationList = new GoodWeStationMonitorList();
                BeanUtil.copyProperties(goodWeStationMonitorDto, goodWeStationList);
                goodWeStationList.setCreatedTime(System.currentTimeMillis());
                goodWeStationMonitorListMapper.insert(goodWeStationList);
                JpStation jpStation = jpStationMapper.selectOne(new QueryWrapper<JpStation>().eq("third_code", PVProducerInfoEnum.GDW.getCode()).eq("third_station_id", goodWeStationList.getPowerstation_id()));
                if (ObjectUtils.isEmpty(jpStation)) {
                    jpStation = new JpStation();
                }
                jpStation.setThirdStationId(goodWeStationList.getPowerstation_id());
                jpStation.setThirdCode(PVProducerInfoEnum.GDW.getCode());
                jpStation.setSnCode(goodWeStationList.getPowerstation_id());
                jpStation.setCapacity(goodWeStationList.getCapacity());
                jpStation.setName(goodWeStationList.getStationname());
                jpStation.setPrice(0.42);
                jpStation.setAddress(goodWeStationList.getAddress());
                jpStation.setLatitude(goodWeStationList.getLatitude());
                jpStation.setLongitude(goodWeStationList.getLongitude());
                jpStation.setUserName(goodWeStationList.getOwner_name());
                jpStation.setUserPhone(goodWeStationList.getOwner_phone());
                jpStation.setStationContact(goodWeStationList.getOwner_name());
                jpStation.setModuleCount(0);
                jpStation.setRealTimePower(goodWeStationList.getPac() * GoodWeConstant.wToKw);
                jpStation.setState(GoodWeConstant.stationStaus.get(goodWeStationList.getStatus()));
                jpStation.setDayGenerate(goodWeStationList.getEday());
                jpStation.setDayIncome(goodWeStationList.getEday_income());
                jpStation.setAccumulatedPower(goodWeStationList.getEtotal());
                jpStation.setCumulativeIncome(goodWeStationList.getEtotal_income());
                if (ObjectUtils.isEmpty(jpStation.getSequenceNbr())) {
                    jpStation.setCreateTime(new Date(goodWeStationList.getCreatedTime()));
                    if (ObjectUtils.isNotEmpty(goodWeStationList.getTurnon_time())) {
                        jpStation.setAccessTime(new Date(goodWeStationList.getTurnon_time()));
                    }

                    jpStationMapper.insert(jpStation);
                } else {
                    jpStationMapper.updateById(jpStation);
                }
                HYGFJPStationPowerHistory hygfjpStationPowerHistory = new HYGFJPStationPowerHistory();
                hygfjpStationPowerHistory.setCreatedTime(System.currentTimeMillis());
                hygfjpStationPowerHistory.setThirdStationId(jpStation.getThirdStationId());
                hygfjpStationPowerHistory.setPower(jpStation.getRealTimePower());
                hygfjpStationPowerHistory.setThirdCode(jpStation.getThirdCode());
                hygfjpStationPowerHistory.setTime(System.currentTimeMillis());
                hygfjpStationPowerHistoryMapper.insert(hygfjpStationPowerHistory);
                HYGFJPDayPower hygfjpDayPower = hygfjpDayPowerMapper.selectOne(
                        new QueryWrapper<HYGFJPDayPower>().
                                eq("tation_id", jpStation.getThirdStationId()).
                                eq("year_month_day", today).
                                eq("hour", hour)
                );
                if (org.springframework.util.ObjectUtils.isEmpty(hygfjpDayPower)) {
                    hygfjpDayPower = new HYGFJPDayPower();
                }
                hygfjpDayPower.setTationId(goodWeStationList.getPowerstation_id());
                hygfjpDayPower.setHour(hour);
                hygfjpDayPower.setYearMonthDay(today);
                hygfjpDayPower.setPower(jpStation.getRealTimePower());
                if (org.springframework.util.ObjectUtils.isEmpty(hygfjpDayPower.getCreatedTime())) {
                    hygfjpDayPower.setCreatedTime(System.currentTimeMillis());
                    hygfjpDayPowerMapper.insert(hygfjpDayPower);
                } else {
                    hygfjpDayPowerMapper.insert(hygfjpDayPower);
                }
                Date today1 = new Date();
                //户用场站日发电量
                TdHYGFStationDayGenerate tdHYGFStationDayGenerate = tdHYGFStationDayGenerateMapper.selectOne(new QueryWrapper<TdHYGFStationDayGenerate>()
                        .eq("third_station_id", jpStation.getThirdStationId())
                        .eq("day_time", DateUtil.format(today1, "yyyy-MM-dd"))
                        .eq("year_month", DateUtil.format(today1, "yyyy-MM")));
                if (org.springframework.util.ObjectUtils.isEmpty(tdHYGFStationDayGenerate)) {
                    tdHYGFStationDayGenerate = new TdHYGFStationDayGenerate();
                }
                tdHYGFStationDayGenerate.setThirdStationId(jpStation.getThirdStationId());
                tdHYGFStationDayGenerate.setDayTime(DateUtil.format(today1, "yyyy-MM-dd"));
                tdHYGFStationDayGenerate.setYearMonth(DateUtil.format(today1, "yyyy-MM"));
                tdHYGFStationDayGenerate.setGenerate(jpStation.getDayGenerate());
                tdHYGFStationDayGenerate.setFullhour(goodWeStationList.getTo_hour());
                tdHYGFStationDayGenerate.setIncome(jpStation.getDayIncome());
                if (org.springframework.util.ObjectUtils.isEmpty(tdHYGFStationDayGenerate.getCreatedTime())) {
                    tdHYGFStationDayGenerate.setCreatedTime(System.currentTimeMillis());
                    tdHYGFStationDayGenerateMapper.insert(tdHYGFStationDayGenerate);
                } else {
                    tdHYGFStationDayGenerateMapper.insert(tdHYGFStationDayGenerate);
                }
                //户用场站月发电量
                TdHYGFStationMonthGenerate tdHYGFStationMonthGenerate = tdHYGFStationMonthGenerateMapper.selectOne(new QueryWrapper<TdHYGFStationMonthGenerate>()
                        .eq("third_station_id", jpStation.getThirdStationId())
                        .eq("month_time", DateUtil.format(today1, "yyyy-MM"))
                        .eq("year", DateUtil.format(today1, "yyyy")));
                if (org.springframework.util.ObjectUtils.isEmpty(tdHYGFStationMonthGenerate)) {
                    tdHYGFStationMonthGenerate = new TdHYGFStationMonthGenerate();
                }
                tdHYGFStationMonthGenerate.setThirdStationId(jpStation.getThirdStationId());
                tdHYGFStationMonthGenerate.setMonthTime(DateUtil.format(today1, "yyyy-MM"));
                tdHYGFStationMonthGenerate.setYear(DateUtil.format(today1, "yyyy"));
                tdHYGFStationMonthGenerate.setGenerate(jpStation.getMonthGenerate());
                if (ObjectUtils.isNotEmpty(jpStation.getMonthGenerate())) {
                    tdHYGFStationMonthGenerate.setFullhour(jpStation.getMonthGenerate() / jpStation.getCapacity());
                }
                tdHYGFStationMonthGenerate.setIncome(jpStation.getMonthIncome());
                if (org.springframework.util.ObjectUtils.isEmpty(tdHYGFStationMonthGenerate.getCreatedTime())) {
                    tdHYGFStationMonthGenerate.setCreatedTime(System.currentTimeMillis());
                    tdHYGFStationMonthGenerateMapper.insert(tdHYGFStationMonthGenerate);
                } else {
                    tdHYGFStationMonthGenerateMapper.insert(tdHYGFStationMonthGenerate);
                }
                //户用场站年发电量
                TdHYGFStationYearGenerate tdHYGFStationYearGenerate = tdHYGFStationYearGenerateMapper.selectOne(new QueryWrapper<TdHYGFStationYearGenerate>()
                        .eq("third_station_id", jpStation.getThirdStationId())
                        .eq("year_time", DateUtil.format(today1, "yyyy"))
                        .eq("year", DateUtil.format(today1, "yyyy")));
                if (org.springframework.util.ObjectUtils.isEmpty(tdHYGFStationYearGenerate)) {
                    tdHYGFStationYearGenerate = new TdHYGFStationYearGenerate();
                }
                tdHYGFStationYearGenerate.setThirdStationId(jpStation.getThirdStationId());
                tdHYGFStationYearGenerate.setYearTime(DateUtil.format(today1, "yyyy"));
                tdHYGFStationYearGenerate.setYear(DateUtil.format(today1, "yyyy"));
                tdHYGFStationYearGenerate.setGenerate(jpStation.getYearGenerate());
                tdHYGFStationYearGenerate.setFullhour(jpStation.getYearGenerate() / jpStation.getCapacity());
                tdHYGFStationYearGenerate.setIncome(jpStation.getYearIncome());
                if (org.springframework.util.ObjectUtils.isEmpty(tdHYGFStationYearGenerate.getCreatedTime())) {
                    tdHYGFStationYearGenerate.setCreatedTime(System.currentTimeMillis());
                    tdHYGFStationYearGenerateMapper.insert(tdHYGFStationYearGenerate);
                } else {
                    tdHYGFStationYearGenerateMapper.insert(tdHYGFStationYearGenerate);
                }
            });
        }
    }

    @Override
    public void stationDetail() {
        List<String> stationIds = goodWeStationMonitorListMapper.getStationIds();
        stationIds.forEach(stationId -> {
            HashMap<String, Object> requestInfo = new HashMap<>();
            String requstParam = JSON.toJSONString(requestInfo);
            String apiurl = GoodWeConstant.stationDetailUrl + "?id=" + stationId;
            List<GoodWeStationDetail> goodWeStationDetails = goodWeRequestUtil.getResPonse(apiurl, GoodWeConstant.requestGet, requstParam, GoodWeConstant.resovleRule_data, GoodWeStationDetail.class);
            if (goodWeStationDetails.size() > 0) {
                goodWeStationDetails.forEach(goodWeStationDetail -> {
                    goodWeStationDetail.setCreatedTime(System.currentTimeMillis());
                    goodWeStationDetailMapper.insert(goodWeStationDetail);
                    JpStation jpStation = jpStationMapper.selectOne(new QueryWrapper<JpStation>().eq("third_code", PVProducerInfoEnum.GDW.getCode()).eq("third_station_id", goodWeStationDetail.getPowerstation_id()));
                    if (ObjectUtils.isEmpty(jpStation)) {
                        jpStation = new JpStation();
                    }
                    jpStation.setUserName(goodWeStationDetail.getOwner_name());
                    jpStation.setUserPhone(goodWeStationDetail.getOwner_phone());
                    jpStation.setStationContact(goodWeStationDetail.getOwner_name());
                    jpStation.setAccessTime(DateUtil.parse(goodWeStationDetail.getTurnon_time(), DatePattern.NORM_DATETIME_PATTERN));
                    if (!ObjectUtils.isEmpty(jpStation.getSequenceNbr())) {
                        jpStationMapper.updateById(jpStation);
                    }
                });
            }
        });

    }

    @Override
    public void stationMonthGen() {
        List<String> stationIds = goodWeStationMonitorListMapper.getStationIds();
        stationIds.forEach(stationId -> {
            String currentMonth = DateUtil.format(new Date(), "yyyyMM");
            HashMap<String, Object> requestInfo = new HashMap<>();
            requestInfo.put("id", stationId);
            requestInfo.put("date", DateUtil.today());
            requestInfo.put("count", 0);
            requestInfo.put("type", 1);
            String requstParam = JSON.toJSONString(requestInfo);
            List<GoodWEGenStation> goodWEGenStations = goodWeRequestUtil.getResPonse(GoodWeConstant.stationGenUrl, GoodWeConstant.requestPost, requstParam, GoodWeConstant.resovleRule_data, GoodWEGenStation.class);
            List<GoodWEGenStation> currentMonthGenStations = goodWEGenStations.stream().filter(goodWEGenStation -> goodWEGenStation.getDate().equals(currentMonth)).collect(Collectors.toList());
            currentMonthGenStations.forEach(goodWEGenStation -> {
                JpStation jpStation = jpStationMapper.selectOne(new QueryWrapper<JpStation>().eq("third_code", PVProducerInfoEnum.GDW.getCode()).eq("third_station_id", stationId));
                if (ObjectUtils.isNotEmpty(jpStation)) {
                    jpStation.setMonthGenerate(Double.parseDouble(goodWEGenStation.getPower()));
                    jpStation.setMonthIncome(jpStation.getMonthGenerate() * 0.42);
                    jpStationMapper.updateById(jpStation);
                }
            });
        });
    }

    @Override
    public void stationYearGen() {
        List<String> stationIds = goodWeStationMonitorListMapper.getStationIds();
        stationIds.forEach(stationId -> {
            String currentYear = DateUtil.format(new Date(), "yyyy");
            HashMap<String, Object> requestInfo = new HashMap<>();
            requestInfo.put("id", stationId);
            requestInfo.put("date", DateUtil.today());
            requestInfo.put("count", 0);
            requestInfo.put("type", 2);
            String requstParam = JSON.toJSONString(requestInfo);
            List<GoodWEGenStation> goodWEGenStations = goodWeRequestUtil.getResPonse(GoodWeConstant.stationGenUrl, GoodWeConstant.requestPost, requstParam, GoodWeConstant.resovleRule_data, GoodWEGenStation.class);
            List<GoodWEGenStation> currentMonthGenStations = goodWEGenStations.stream().filter(goodWEGenStation -> goodWEGenStation.getDate().equals(currentYear)).collect(Collectors.toList());
            currentMonthGenStations.forEach(goodWEGenStation -> {
                JpStation jpStation = jpStationMapper.selectOne(new QueryWrapper<JpStation>().eq("third_code", PVProducerInfoEnum.GDW.getCode()).eq("third_station_id", stationId));
                if (ObjectUtils.isNotEmpty(jpStation)) {
                    jpStation.setYearGenerate(Double.parseDouble(goodWEGenStation.getPower()));
                    jpStation.setYearIncome(jpStation.getYearGenerate() * 0.42);
                    jpStationMapper.updateById(jpStation);
                }
            });
        });
    }


    @Override
    public void collectorList() {

    }

    @Override
    public void collectorDetail() {

    }

    @Override
    public void inverterList() {
        List<String> stationIds = goodWeStationMonitorListMapper.getStationIds();
        stationIds.stream().forEach(stationId -> {
            HashMap<String, Object> requestInfo = new HashMap<>();
            requestInfo.put("page_index", 1);
            requestInfo.put("page_size", 100);
            requestInfo.put("pw_id", stationId);
            String requstParam = JSON.toJSONString(requestInfo);
            List<GoodWeINverterDetailDto> inverterDetailDtoList = goodWeRequestUtil.getResPonse(GoodWeConstant.queryInventerUrl
                    , GoodWeConstant.requestPost, requstParam, GoodWeConstant.resovleRule_data_list, GoodWeINverterDetailDto.class);
            inverterDetailDtoList.forEach(goodWeINverterDetailDto -> {
//                System.out.println(goodWeINverterDetailDto.getIt_sn());
                JpInverter jpInverter = jpInverterMapper.selectOne(new QueryWrapper<JpInverter>().
                        eq("third_station_id", goodWeINverterDetailDto.getPw_id()).
                        eq("third_code", PVProducerInfoEnum.GDW.getCode()).
                        eq("sn_code", goodWeINverterDetailDto.getIt_sn()));
                if (org.springframework.util.ObjectUtils.isEmpty(jpInverter)) {
                    jpInverter = new JpInverter();
                }
                jpInverter.setName(goodWeINverterDetailDto.getIt_name());
                jpInverter.setSnCode(goodWeINverterDetailDto.getIt_sn());
                jpInverter.setUpdateTime(new Date());
                jpInverter.setId(String.valueOf(goodWeINverterDetailDto.getId()));
                jpInverter.setCapacity(goodWeINverterDetailDto.getIt_capacity());
                jpInverter.setThirdStationId(goodWeINverterDetailDto.getPw_id());
                jpInverter.setThirdCode(PVProducerInfoEnum.GDW.getCode());
                jpInverter.setStationName(goodWeINverterDetailDto.getIt_name());
                jpInverter.setRecDate(new Date());
                if (!org.springframework.util.ObjectUtils.isEmpty(jpInverter.getSequenceNbr())) {
                    jpInverterMapper.updateById(jpInverter);
                } else {
                    jpInverterMapper.insert(jpInverter);
                }
            });
        });
    }

    @Override
    public void inverterDetail() {
        List<String> goodweSnList = jpInverterMapper.getGoodWeSnCodes();
        List<List<String>> splitList = Lists.partition(goodweSnList, 50);
        HashMap<String, Object> requestInfo = new HashMap<>();
        String requstParam = JSON.toJSONString(requestInfo);
        for (int i = 0; i < splitList.size(); i++) {
            String requestSns = splitList.get(i).stream().map(s -> "sns=" + s).collect(Collectors.joining("&"));
            String apiUrl = GoodWeConstant.getInventersDatas + "?" + requestSns;
            List<GoodWeInverterCurrentDataDto> list = goodWeRequestUtil.getResPonse(apiUrl, GoodWeConstant.requestGet, requstParam, GoodWeConstant.resovleRule_data_list, GoodWeInverterCurrentDataDto.class);
            list.forEach(goodWeInverterCurrentDataDto -> {
                JpInverter jpInverter = jpInverterMapper.selectOne(new QueryWrapper<JpInverter>().
                        eq("third_code", PVProducerInfoEnum.GDW.getCode()).
                        eq("sn_code", goodWeInverterCurrentDataDto.getSn()));
                jpInverter.setIgbtTemperature(String.valueOf(goodWeInverterCurrentDataDto.getTempperature()));
                jpInverter.setDayPowerGeneration(goodWeInverterCurrentDataDto.getEday());
                jpInverter.setCapacity(goodWeInverterCurrentDataDto.getCapacity());
                jpInverterMapper.updateById(jpInverter);
                JSONObject hanlderResult = JSONObject.parseObject(JSON.toJSONString(goodWeInverterCurrentDataDto.getD()));
                for (int k = 1; k < 3; k++) {
                    JpInverterElectricity jpInverterElectricity = jpInverterElectricityMapper.selectOne(new QueryWrapper<JpInverterElectricity>().
                            eq("sn_code", goodWeInverterCurrentDataDto.getSn()).
                            eq("type", "交流").
                            eq("name", "AC" + k)
                    );
                    if (org.springframework.util.ObjectUtils.isEmpty(jpInverterElectricity)) {
                        jpInverterElectricity = new JpInverterElectricity();
                    }
                    jpInverterElectricity.setInverterId(jpInverter.getId());
                    jpInverterElectricity.setSnCode(goodWeInverterCurrentDataDto.getSn());
                    jpInverterElectricity.setThirdCode(PVProducerInfoEnum.GDW.getCode());
                    jpInverterElectricity.setThirdStationId(jpInverter.getThirdStationId());
                    jpInverterElectricity.setType("交流");
                    jpInverterElectricity.setName("AC" + k);
                    jpInverterElectricity.setVoltage(Double.valueOf(hanlderResult.get("vac" + k).toString()));
                    jpInverterElectricity.setCurrent(Double.valueOf(hanlderResult.get("iac" + k).toString()));
                    if (org.springframework.util.ObjectUtils.isEmpty(jpInverterElectricity.getSequenceNbr())) {
                        jpInverterElectricityMapper.insert(jpInverterElectricity);
                    } else {
                        jpInverterElectricityMapper.updateById(jpInverterElectricity);
                    }
                }
                for (int k1 = 1; k1 < 4; k1++) {
                    JpInverterElectricity jpInverterElectricity = jpInverterElectricityMapper.selectOne(new QueryWrapper<JpInverterElectricity>().
                            eq("sn_code", goodWeInverterCurrentDataDto.getSn()).
                            eq("type", "直流").
                            eq("name", "PV" + k1)
                    );
                    if (org.springframework.util.ObjectUtils.isEmpty(jpInverterElectricity)) {
                        jpInverterElectricity = new JpInverterElectricity();
                    }
                    jpInverterElectricity.setInverterId(jpInverter.getId());
                    jpInverterElectricity.setSnCode(goodWeInverterCurrentDataDto.getSn());
                    jpInverterElectricity.setThirdCode(PVProducerInfoEnum.GDW.getCode());
                    jpInverterElectricity.setThirdStationId(jpInverter.getThirdStationId());
                    jpInverterElectricity.setType("直流");
                    jpInverterElectricity.setName("PV" + k1);
                    jpInverterElectricity.setVoltage(Double.valueOf(hanlderResult.get("vpv" + k1).toString()));
                    jpInverterElectricity.setCurrent(Double.valueOf(hanlderResult.get("ipv" + k1).toString()));
//                    jpInverterElectricity.setPower(Double.valueOf(hanlderResult.get("pow" + k1).toString()));
                    if (org.springframework.util.ObjectUtils.isEmpty(jpInverterElectricity.getSequenceNbr())) {
                        jpInverterElectricityMapper.insert(jpInverterElectricity);
                    } else {
                        jpInverterElectricityMapper.updateById(jpInverterElectricity);
                    }
                }
                HYGFJPInverterElecHistory hygfjpInverterElecHistory = new HYGFJPInverterElecHistory();
                hygfjpInverterElecHistory.setThirdStationId(jpInverter.getThirdStationId());
                hygfjpInverterElecHistory.setCreatedTime(System.currentTimeMillis());
                hygfjpInverterElecHistory.setSnCode(goodWeInverterCurrentDataDto.getSn());
                hygfjpInverterElecHistory.setUAcCurrent(goodWeInverterCurrentDataDto.getD().getIac1());
                hygfjpInverterElecHistory.setVAcCurrent(goodWeInverterCurrentDataDto.getD().getIac2());
                hygfjpInverterElecHistory.setWAcCurrent(goodWeInverterCurrentDataDto.getD().getIac3());
                hygfjpInverterElecHistory.setUAcVoltage(goodWeInverterCurrentDataDto.getD().getVac1());
                hygfjpInverterElecHistory.setVAcVoltage(goodWeInverterCurrentDataDto.getD().getVac2());
                hygfjpInverterElecHistory.setWAcVoltage(goodWeInverterCurrentDataDto.getD().getVac3());
                hygfjpInverterElecHistory.setThirdCode(PVProducerInfoEnum.GDW.getCode());
                hygfjpInverterElecHistory.setTime(System.currentTimeMillis());
                hygfjpInverterElecHistoryMapper.insert(hygfjpInverterElecHistory);
                // 逆变器历史
                String today = DateUtil.today();
                HYGFJPInverterHistory hygfjpInverterHistory = hygfjpInverterHistoryMapper.selectOne(new QueryWrapper<HYGFJPInverterHistory>()
                        .eq("sn_code", goodWeInverterCurrentDataDto.getSn())
                        .eq("date", today));
                if (org.springframework.util.ObjectUtils.isEmpty(hygfjpInverterHistory)) {
                    hygfjpInverterHistory = new HYGFJPInverterHistory();
                }
                hygfjpInverterHistory.setDate(today);
                hygfjpInverterHistory.setThirdStationId(jpInverter.getThirdStationId());
                hygfjpInverterHistory.setInverterId(jpInverter.getId());
                hygfjpInverterHistory.setSnCode(goodWeInverterCurrentDataDto.getSn());
                hygfjpInverterHistory.setThirdCode(PVProducerInfoEnum.GDW.getCode());
                if(ObjectUtils.isNotEmpty(jpInverter.getCapacity())&&ObjectUtils.isNotEmpty(jpInverter.getDayPowerGeneration())){
                    hygfjpInverterHistory.setGenerationHours(jpInverter.getDayPowerGeneration()/jpInverter.getCapacity());
                }

                hygfjpInverterHistory.setPowerGeneration(goodWeInverterCurrentDataDto.getEday());
                if (org.springframework.util.ObjectUtils.isEmpty(hygfjpInverterHistory.getCreatedTime())) {
                    hygfjpInverterHistory.setCreatedTime(System.currentTimeMillis());
                    hygfjpInverterHistoryMapper.insert(hygfjpInverterHistory);
                } else {
                    hygfjpInverterHistoryMapper.insert(hygfjpInverterHistory);
                }
                //-----------------------户用光伏日报表----------------------
                TdHYGFInverterDayGenerate tdHYGFInverterDayGenerate = new TdHYGFInverterDayGenerate();
                tdHYGFInverterDayGenerate.setCreatedTime(System.currentTimeMillis());
                tdHYGFInverterDayGenerate.setName(jpInverter.getName());
                tdHYGFInverterDayGenerate.setThirdStationId(String.valueOf(jpInverter.getThirdStationId()));
                tdHYGFInverterDayGenerate.setSnCode(jpInverter.getSnCode().trim());
                tdHYGFInverterDayGenerate.setWorkStatus(jpInverter.getState());
                D d = goodWeInverterCurrentDataDto.getD();
                //交流电压
                tdHYGFInverterDayGenerate.setDcv1(d.getVac1());
                tdHYGFInverterDayGenerate.setDcv2(d.getVac2());
                tdHYGFInverterDayGenerate.setDcv3(d.getVac3());
                //交流电流
//                tdHYGFInverterDayGenerate.setDcv4(inverterDetailDto.getUAc4());
                tdHYGFInverterDayGenerate.setDcc1(d.getIac1());
                tdHYGFInverterDayGenerate.setDcc2(d.getIac2());
                tdHYGFInverterDayGenerate.setDcc3(d.getIac3());
//                tdHYGFInverterDayGenerate.setDcc4(inverterDetailDto.getIAc4());
                //直流电压
                tdHYGFInverterDayGenerate.setAcv1(d.getVpv1());
                tdHYGFInverterDayGenerate.setAcv2(d.getVpv2());
                tdHYGFInverterDayGenerate.setAcv3(d.getVpv3());
                tdHYGFInverterDayGenerate.setAcv4(d.getVpv4());
                //直流电流
                tdHYGFInverterDayGenerate.setAcc1(d.getIpv1());
                tdHYGFInverterDayGenerate.setAcc2(d.getIpv2());
                tdHYGFInverterDayGenerate.setAcc3(d.getIpv3());
                tdHYGFInverterDayGenerate.setAcc4(d.getIpv4());
                //功率
//                tdHYGFInverterDayGenerate.setPv1(inverterDetailDto.getPow1());
//                tdHYGFInverterDayGenerate.setPv2(inverterDetailDto.getPow2());
//                tdHYGFInverterDayGenerate.setPv3(inverterDetailDto.getPow3());
//                tdHYGFInverterDayGenerate.setPv4(inverterDetailDto.getPow4());

//                tdHYGFInverterDayGenerate.setTotalPower(inverterDetailDto.getPac());
//                tdHYGFInverterDayGenerate.setFrequency(String.valueOf(inverterDetailDto.getFac()));
//                tdHYGFInverterDayGenerate.setPowerFactor(inverterDetailDto.getPowerFactor());
                tdHYGFInverterDayGenerate.setDayGen(jpInverter.getDayPowerGeneration());

                tdHYGFInverterDayGenerate.setMonthGen(jpInverter.getMonthPowerGeneration());
                tdHYGFInverterDayGenerate.setYearGen(jpInverter.getYearPowerGeneration());
                tdHYGFInverterDayGenerate.setTotalGen(jpInverter.getTotalPowerGeneration());
                tdHYGFInverterDayGenerate.setIgbtTemp(goodWeInverterCurrentDataDto.getTempperature());
                tdHYGFInverterDayGenerate.setIncome(null);
                if(ObjectUtils.isNotEmpty(jpInverter.getCapacity())&&ObjectUtils.isNotEmpty(jpInverter.getDayPowerGeneration())){
                tdHYGFInverterDayGenerate.setFullhour(jpInverter.getDayPowerGeneration() / jpInverter.getCapacity());}
                tdHYGFInverterDayGenerateMapper.insert(tdHYGFInverterDayGenerate);
                //户用场站月发电量
                Date today1 = new Date();
                TdHYGFInverterMonthGenerate tdHYGFInverterMonthGenerate = tdHYGFInverterMonthGenerateMapper.selectOne(new QueryWrapper<TdHYGFInverterMonthGenerate>()
                        .eq("third_station_id", jpInverter.getThirdStationId())
                        .eq("sn_code", jpInverter.getSnCode())
                        .eq("day_time", DateUtil.format(today1, "yyyy-MM-dd"))
                        .eq("year_month", DateUtil.format(today1, "yyyy-MM")));
                if (org.springframework.util.ObjectUtils.isEmpty(tdHYGFInverterMonthGenerate)) {
                    tdHYGFInverterMonthGenerate = new TdHYGFInverterMonthGenerate();
                }
                tdHYGFInverterMonthGenerate.setThirdStationId(jpInverter.getThirdStationId());
                tdHYGFInverterMonthGenerate.setSnCode(jpInverter.getSnCode().trim());
                tdHYGFInverterMonthGenerate.setName(jpInverter.getName());
                tdHYGFInverterMonthGenerate.setDayTime(DateUtil.format(today1, "yyyy-MM-dd"));
                tdHYGFInverterMonthGenerate.setYearMonth(DateUtil.format(today1, "yyyy-MM"));
                tdHYGFInverterMonthGenerate.setGenerate(jpInverter.getDayPowerGeneration());
                if(ObjectUtils.isNotEmpty(jpInverter.getCapacity())&&ObjectUtils.isNotEmpty(jpInverter.getDayPowerGeneration())){
                tdHYGFInverterMonthGenerate.setFullhour(jpInverter.getDayPowerGeneration() / jpInverter.getCapacity());}

                if (org.springframework.util.ObjectUtils.isEmpty(tdHYGFInverterMonthGenerate.getCreatedTime())) {
                    tdHYGFInverterMonthGenerate.setCreatedTime(System.currentTimeMillis());
                    tdHYGFInverterMonthGenerateMapper.insert(tdHYGFInverterMonthGenerate);
                } else {
                    tdHYGFInverterMonthGenerateMapper.insert(tdHYGFInverterMonthGenerate);
                }
                //户用场站年发电量
                TdHYGFInverterYearGenerate tdHYGFInverterYearGenerate = tdHYGFInverterYearGenerateMapper.selectOne(new QueryWrapper<TdHYGFInverterYearGenerate>()
                        .eq("third_station_id", jpInverter.getThirdStationId())
                        .eq("sn_code", jpInverter.getSnCode())
                        .eq("month_time", DateUtil.format(today1, "yyyy-MM"))
                        .eq("year", DateUtil.format(today1, "yyyy")));
                if (org.springframework.util.ObjectUtils.isEmpty(tdHYGFInverterYearGenerate)) {
                    tdHYGFInverterYearGenerate = new TdHYGFInverterYearGenerate();
                }
                tdHYGFInverterYearGenerate.setThirdStationId(jpInverter.getThirdStationId());
                tdHYGFInverterYearGenerate.setSnCode(jpInverter.getSnCode().trim());
                tdHYGFInverterYearGenerate.setMonthTime(DateUtil.format(today1, "yyyy-MM"));
                tdHYGFInverterYearGenerate.setYear(DateUtil.format(today1, "yyyy"));
                tdHYGFInverterYearGenerate.setGenerate(jpInverter.getMonthPowerGeneration());
                if(ObjectUtils.isNotEmpty(jpInverter.getCapacity())&&ObjectUtils.isNotEmpty(jpInverter.getMonthPowerGeneration())){
                tdHYGFInverterYearGenerate.setFullhour(jpInverter.getMonthPowerGeneration() / jpInverter.getCapacity());
                }
                tdHYGFInverterYearGenerate.setName(jpInverter.getName());
                if (org.springframework.util.ObjectUtils.isEmpty(tdHYGFInverterYearGenerate.getCreatedTime())) {
                    tdHYGFInverterYearGenerate.setCreatedTime(System.currentTimeMillis());
                    tdHYGFInverterYearGenerateMapper.insert(tdHYGFInverterYearGenerate);
                } else {
                    tdHYGFInverterYearGenerateMapper.insert(tdHYGFInverterYearGenerate);
                }
                //户用场站年发电量
                TdHYGFInverterTotalGenerate tdHYGFInverterTotalGenerate = tdHYGFInverterTotalGenerateMapper.selectOne(new QueryWrapper<TdHYGFInverterTotalGenerate>()
                        .eq("third_station_id", jpInverter.getThirdStationId())
                        .eq("sn_code", jpInverter.getSnCode())
                        .eq("year_time", DateUtil.format(today1, "yyyy"))
                        .eq("year", DateUtil.format(today1, "yyyy")));
                if (org.springframework.util.ObjectUtils.isEmpty(tdHYGFInverterTotalGenerate)) {
                    tdHYGFInverterTotalGenerate = new TdHYGFInverterTotalGenerate();
                }
                tdHYGFInverterTotalGenerate.setThirdStationId(jpInverter.getThirdStationId());
                tdHYGFInverterTotalGenerate.setName(null == jpInverter.getName() ? null : jpInverter.getName());
                tdHYGFInverterTotalGenerate.setSnCode(jpInverter.getSnCode().trim());
                tdHYGFInverterTotalGenerate.setYearTime(DateUtil.format(today1, "yyyy"));
                tdHYGFInverterTotalGenerate.setYear(DateUtil.format(today1, "yyyy"));
                tdHYGFInverterTotalGenerate.setGenerate(jpInverter.getYearPowerGeneration());
                if(ObjectUtils.isNotEmpty(jpInverter.getCapacity())&&ObjectUtils.isNotEmpty(jpInverter.getYearPowerGeneration())) {
                    tdHYGFInverterTotalGenerate.setFullhour(jpInverter.getYearPowerGeneration() / jpInverter.getCapacity());
                }

                if (org.springframework.util.ObjectUtils.isEmpty(tdHYGFInverterTotalGenerate.getCreatedTime())) {
                    tdHYGFInverterTotalGenerate.setCreatedTime(System.currentTimeMillis());
                    tdHYGFInverterTotalGenerateMapper.insert(tdHYGFInverterTotalGenerate);
                } else {
                    tdHYGFInverterTotalGenerateMapper.insert(tdHYGFInverterTotalGenerate);
                }
            });

        }
    }

    @Override
    public void inverterMonthGen() {
        List<String> sns =jpInverterMapper.getGoodWeSnCodes() ;
        String currentMonth = DateUtil.format(new Date(), "yyyyMM");
        sns.forEach(sn -> {
            HashMap<String, Object> requestInfo = new HashMap<>();
            requestInfo.put("sn", sn);
            requestInfo.put("date", DateUtil.today());
            requestInfo.put("count", 0);
            requestInfo.put("type", 1);
            String requstParam = JSON.toJSONString(requestInfo);
            String apiUrl = GoodWeConstant.getinverterGenURl+"?sn="+sn+"&date="+DateUtil.today()+"&count=0&type=1";
            List<GoodWEGenStation> goodWEGenStations = goodWeRequestUtil.getResPonse(apiUrl, GoodWeConstant.requestGet, requstParam, GoodWeConstant.resovleRule_data, GoodWEGenStation.class);
            List<GoodWEGenStation> currentMonthGenStations = goodWEGenStations.stream().filter(goodWEGenStation -> goodWEGenStation.getDate().equals(currentMonth)).collect(Collectors.toList());
            currentMonthGenStations.forEach(goodWEGenStation -> {
                JpInverter jpInverter = jpInverterMapper.selectOne(new QueryWrapper<JpInverter>().eq("third_code", PVProducerInfoEnum.GDW.getCode()).eq("sn_code", sn));
                if (ObjectUtils.isNotEmpty(jpInverter)) {
                    jpInverter.setMonthPowerGeneration(Double.parseDouble(goodWEGenStation.getPower()));
                    jpInverterMapper.updateById(jpInverter);
                }
            });
        });
    }

    @Override
    public void inverterYearGen() {
        String currentYear = DateUtil.format(new Date(), "yyyy");
        List<String> sns =jpInverterMapper.getGoodWeSnCodes() ;
        sns.forEach(sn -> {
            HashMap<String, Object> requestInfo = new HashMap<>();
            requestInfo.put("sn", sn);
            requestInfo.put("date", DateUtil.today());
            requestInfo.put("count", 0);
            requestInfo.put("type", 2);
            String requstParam = JSON.toJSONString(requestInfo);
            String apiUrl = GoodWeConstant.getinverterGenURl+"?sn="+sn+"&date="+DateUtil.today()+"&count=0&type=2";
            List<GoodWEGenStation> goodWEGenStations = goodWeRequestUtil.getResPonse(apiUrl, GoodWeConstant.requestGet, requstParam, GoodWeConstant.resovleRule_data, GoodWEGenStation.class);
            List<GoodWEGenStation> currentMonthGenStations = goodWEGenStations.stream().filter(goodWEGenStation -> goodWEGenStation.getDate().equals(currentYear)).collect(Collectors.toList());
            currentMonthGenStations.forEach(goodWEGenStation -> {
                JpInverter jpInverter  = jpInverterMapper.selectOne(new QueryWrapper<JpInverter>().eq("third_code", PVProducerInfoEnum.GDW.getCode()).eq("sn_code", sn));
                if (ObjectUtils.isNotEmpty(jpInverter)) {
                    jpInverter.setYearPowerGeneration(Double.parseDouble(goodWEGenStation.getPower()));
                    jpInverterMapper.updateById(jpInverter);
                }
            });
        });
    }

    @Override
    public void inverAlramInfo() {
        HashMap<String, Object> requestInfo = new HashMap<>();
        String today = DateUtil.today();
        requestInfo.put("page_index", 1);
        requestInfo.put("page_size", 1000);
        requestInfo.put("starttime", today + " 00:00:00");
        requestInfo.put("endtime", today + " 23:59:59");
        requestInfo.put("status", 2);
        String requstParam = JSON.toJSONString(requestInfo);
        List<GoodWeAlarmDto> alarmList = goodWeRequestUtil.getResPonse(GoodWeConstant.alarmListUrl, GoodWeConstant.requestPost, requstParam, GoodWeConstant.resovleRule_data_list, GoodWeAlarmDto.class);
        alarmList.forEach(goodWeAlarmDto -> {
            if (!ObjectUtils.isEmpty(goodWeAlarmDto.getDevicesn())) {
                HYGFJPInverterWarn hygfjpInverterWarn = hygfjpInverterWarnMapper.selectOne(new QueryWrapper<HYGFJPInverterWarn>()
                        .eq("sn_code", goodWeAlarmDto.getDevicesn())
                        .eq("start_time", goodWeAlarmDto.getHappentime().getMillis())
                        .eq("third_station_id", String.valueOf(goodWeAlarmDto.getStationId()))
                );
                if (ObjectUtils.isEmpty(hygfjpInverterWarn)) {
                    hygfjpInverterWarn = new HYGFJPInverterWarn();
                }
                hygfjpInverterWarn.setTime(System.currentTimeMillis());
                hygfjpInverterWarn.setSnCode(goodWeAlarmDto.getDevicesn());
                hygfjpInverterWarn.setThirdStationId(goodWeAlarmDto.getStationId());
//                hygfjpInverterWarn.setLevel(GoLangConstant.alarmLevel.get(alarmDto.getAlarmLevel()));
                hygfjpInverterWarn.setContent(goodWeAlarmDto.getWarningname());
                hygfjpInverterWarn.setThirdCode(PVProducerInfoEnum.GDW.getCode());
                hygfjpInverterWarn.setTreatment(GoodWeConstant.errorCodeMap.get(goodWeAlarmDto.getError_code()).get(2));
                hygfjpInverterWarn.setStartTime(goodWeAlarmDto.getHappentime().getMillis());
                hygfjpInverterWarn.setRecoverTime(null);
                if (!ObjectUtils.isEmpty(goodWeAlarmDto.getRecoverytime())) {
                    hygfjpInverterWarn.setRecoverTime(goodWeAlarmDto.getRecoverytime().getMillis());
                }
                hygfjpInverterWarn.setTimeLong(null);
                if ((!ObjectUtils.isEmpty(goodWeAlarmDto.getHappentime())) && (!ObjectUtils.isEmpty(goodWeAlarmDto.getRecoverytime()))) {
                    hygfjpInverterWarn.setTimeLong(goodWeAlarmDto.getRecoverytime().getMillis() - goodWeAlarmDto.getHappentime().getMillis());
                }
                hygfjpInverterWarn.setState(GoodWeConstant.warningStaus.get(goodWeAlarmDto.getStatus().toString()));
                if (org.springframework.util.ObjectUtils.isEmpty(hygfjpInverterWarn.getCreatedTime())) {
                    hygfjpInverterWarn.setCreatedTime(System.currentTimeMillis());
                    hygfjpInverterWarnMapper.insert(hygfjpInverterWarn);
                } else {
                    hygfjpInverterWarnMapper.insert(hygfjpInverterWarn);
                }
            }
        });
    }
}
