package com.yeejoin.amos.boot.module.ugp.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 企业信息表
 *
 * @author system_generator
 * @date 2022-09-21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_ugp_company")
public class UgpCompany extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 企业名称
     */
	@TableField("name")
    private String name;

    /**
     * 企业类型
     */
	@TableField("type")
    private String type;

    /**
     * 统一信用代码
     */
	@TableField("credit_code")
    private String creditCode;

    /**
     * 许可证号
     */
	@TableField("license_number")
    private String licenseNumber;

    /**
     * 有效期至
     */
	@TableField("expiration_date")
    private Date expirationDate;

    /**
     * 企业地址
     */
	@TableField("address")
    private String address;

    /**
     * 联系方式
     */
	@TableField("contact_phone")
    private String contactPhone;

    /**
     * 联系人
     */
	@TableField("contact")
    private String contact;

    /**
     * 
     */
	@TableField("remark")
    private String remark;

    /**
     * 统一信用代码证书附件
     */
	@TableField("credit_attch")
    private String creditAttch;

    /**
     * 许可证附件
     */
	@TableField("license_attch")
    private String licenseAttch;

    /**
     * 是否已审核（1已审核，0未审核）
     */
	@TableField("approved")
    private String approved;

    /**
     * 单位机构代码
     */
	@TableField("org_code")
    private String orgCode;

}
