package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.amos.boot.module.hygf.api.entity.MaintenanceFile;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
import java.util.List;

/**
 * 运维人员
 *
 * @author system_generator
 * @date 2024-03-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="MaintenanceDto", description="运维人员")
public class MaintenanceDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "运维人员类型名称")
    private String maintenanceType;

    @ApiModelProperty(value = "运维人员类型code")
    private String maintenanceTypeCode;

    @ApiModelProperty(value = "运维区域名称")
    private String maintenanceArea;

    @ApiModelProperty(value = "运维区域code")
    private String maintenanceAreaCode;

    @ApiModelProperty(value = "运维工种名称")
    private String maintenanceWorkers;

    @ApiModelProperty(value = "运维工种code")
    private String maintenanceWorkersCode;

    @ApiModelProperty(value = "所属区域公司id")
    private Long regionalCompaniesSeq;

    @ApiModelProperty(value = "所属区域公司名称")
    private String regionalCompaniesName;

    @ApiModelProperty(value = "所属区域公司code")
    private String regionalCompaniesCode;

    @ApiModelProperty(value = "业务经销商name")
    private String dealerName;

    @ApiModelProperty(value = "业务经销商id")
    private Long dealerId;

    @ApiModelProperty(value = "平台经销商单位id")
    private Long amosDealerId;

    @ApiModelProperty(value = "平台经销商code")
    private String amosDealerCode;

    @ApiModelProperty(value = "证件号码")
    private String idCard;

    @ApiModelProperty(value = "身份证正面")
    private String idCardFront;

    @ApiModelProperty(value = "身份证反面")
    private String idCardOpposite;

    @ApiModelProperty(value = "业主姓名")
    private String name;

    @ApiModelProperty(value = "联系电话")
    private String telephone;

    @ApiModelProperty(value = "证件类型")
    private String idType;

    @ApiModelProperty(value = "管理员账户名")
    private String adminLoginName;

    @ApiModelProperty(value = "管理员密码")
    private String adminLoginPwd;

//    @ApiModelProperty(value = "低压电工证")
//    private String electricianCertificate;
//
//    @ApiModelProperty(value = "登高证")
//    private String climbingCertificate;
//
//    @ApiModelProperty(value = "低压电工证有效期开始")
//    private Date electricianCertificateStart;
//
//    @ApiModelProperty(value = "低压电工证有效期结束")
//    private Date electricianCertificateEnd;
//
//    @ApiModelProperty(value = "登高证有效期开始")
//    private Date climbingCertificateStart;
//
//    @ApiModelProperty(value = "登高证有效期结束")
//    private Date climbingCertificateEnd;

    @ApiModelProperty(value = "培训状态")
    private String trainingStatus;

    @ApiModelProperty(value = "审核状态")
    private String reviewStatus;

    @ApiModelProperty(value = "平台userId")
    private String amosUserId;

    @ApiModelProperty(value = "是否锁定")
    private String lockStatus;

    @ApiModelProperty(value = "运维区域详细地址")
    private String maintenanceAreaAddress;

    @ApiModelProperty(value = "常住地址code")
    private String permanentAddressCode;

    @ApiModelProperty(value = "常住详细地址")
    private String permanentAddressDetail;

    @ApiModelProperty(value = "常住地址")
    private String permanentAddressName;

    /**
     *
     * 基础人员表
     * */
    private Long foundationId;


    //证书
    List<MaintenanceFile> maintenanceFiles;


    @ApiModelProperty(value = "身份证正面")
    private  List<Object> idCardFrontList;

    @ApiModelProperty(value = "身份证反面")
    private  List<Object> idCardOppositeList;

    @ApiModelProperty(value = "是否签订安全协议")
    private  Integer  isSignAnAgreement ;

}
