package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.hygf.api.dto.TdHygfJpInverterHistoryDto;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.TdHygfJpInverterHistoryServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * 户用光伏监盘逆变器历史表
 *
 * @author system_generator
 * @date 2023-09-19
 */
@RestController
@Api(tags = "户用光伏监盘逆变器历史表Api")
@RequestMapping(value = "/td-hygf-jp-inverter-history")
public class TdHygfJpInverterHistoryController extends BaseController {

	@Autowired
	TdHygfJpInverterHistoryServiceImpl tdHygfJpInverterHistoryServiceImpl;

	/**
	 * 新增户用光伏监盘逆变器历史表
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增户用光伏监盘逆变器历史表", notes = "新增户用光伏监盘逆变器历史表")
	public ResponseModel<TdHygfJpInverterHistoryDto> save(@RequestBody TdHygfJpInverterHistoryDto model) {
		model = tdHygfJpInverterHistoryServiceImpl.createWithModel(model);
		return ResponseHelper.buildResponse(model);
	}

	/**
	 * 根据sequenceNbr更新
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新户用光伏监盘逆变器历史表", notes = "根据sequenceNbr更新户用光伏监盘逆变器历史表")
	public ResponseModel<TdHygfJpInverterHistoryDto> updateBySequenceNbrTdHygfJpInverterHistory(
			@RequestBody TdHygfJpInverterHistoryDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		return ResponseHelper.buildResponse(tdHygfJpInverterHistoryServiceImpl.updateWithModel(model));
	}

	/**
	 * 根据sequenceNbr删除
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@DeleteMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除户用光伏监盘逆变器历史表", notes = "根据sequenceNbr删除户用光伏监盘逆变器历史表")
	public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request,
			@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		return ResponseHelper.buildResponse(tdHygfJpInverterHistoryServiceImpl.removeById(sequenceNbr));
	}

	/**
	 * 根据sequenceNbr查询
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个户用光伏监盘逆变器历史表", notes = "根据sequenceNbr查询单个户用光伏监盘逆变器历史表")
	public ResponseModel<TdHygfJpInverterHistoryDto> selectOne(@PathVariable Long sequenceNbr) {
		return ResponseHelper.buildResponse(tdHygfJpInverterHistoryServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
	 * 列表分页查询
	 *
	 * @param current 当前页
	 * @param current 每页大小
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET", value = "户用光伏监盘逆变器历史表分页查询", notes = "户用光伏监盘逆变器历史表分页查询")
	public ResponseModel<Page<TdHygfJpInverterHistoryDto>> queryForPage(@RequestParam(value = "current") int current,
			@RequestParam(value = "size") int size) {
		Page<TdHygfJpInverterHistoryDto> page = new Page<TdHygfJpInverterHistoryDto>();
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper
				.buildResponse(tdHygfJpInverterHistoryServiceImpl.queryForTdHygfJpInverterHistoryPage(page));
	}

	/**
	 * 列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "户用光伏监盘逆变器历史表列表全部数据查询", notes = "户用光伏监盘逆变器历史表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<TdHygfJpInverterHistoryDto>> selectForList() {
		return ResponseHelper.buildResponse(tdHygfJpInverterHistoryServiceImpl.queryForTdHygfJpInverterHistoryList());
	}

	/**
	 * 列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "户用光伏监盘逆变器历史表列表全部数据查询", notes = "户用光伏监盘逆变器历史表列表全部数据查询")
	@GetMapping(value = "/statistics")
	public ResponseModel<Map<String, Object>> day(@RequestParam(value = "id") String id,
			@RequestParam(value = "type") String type, @RequestParam(value = "date") String date) {
		return ResponseHelper.buildResponse(tdHygfJpInverterHistoryServiceImpl.statistics(id,type,date));
	}

}
