package com.yeejoin.amos.boot.module.jxiop.api.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.api.dto.*;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 场站基础信息表 Mapper 接口
 *
 * @author system_generator
 * @date 2023-04-20
 */
public interface StationBasicMapper extends BaseMapper<StationBasic> {
    //分页
    List<StationBasicDto> queryPage(@Param("current")Long current, @Param("size")Long size,
                                    @Param("stationMasterName") String stationMasterName,
                                    @Param("stationName") String stationName,
                                    @Param("stationType")String stationType,
                                    @Param("orgCode") String orgCode);
    //统计
    List<StationBasicDto> queryPagecount(
            @Param("stationMasterName") String stationMasterName,
            @Param("stationName")String stationName,
            @Param("stationType")String stationType,
            @Param("orgCode")String orgCode);
    //删除
    int deleteList(String ids);
    //导出
    List<ExStationBasicDto> getExStationBasicDto( @Param("stationMasterName") String stationMasterName,
                                                  @Param("stationName")String stationName,
                                                  @Param("stationType")String stationType,
                                                  @Param("orgCode")String orgCode,
                                                  @Param("ids")  String [] ids

    );

    //获取场站列表信息
    List<StationRecordInfo> getStationList(@Param("regionId")String regionId);
    int deleteStationCoordinateByStationid (@Param("sequence_nbr") Long sequence_nbr );
    int getStationPersonByStationID (@Param("sequence_nbr") String sequence_nbr );

    /**
     *  获取场站相关信息
     * @return List<StationTaksDto>
     */
    List<StationTaksDto> getStationBasicDtoList();



    /**
     * 根据所属地区code获取场站列表信息
     * @param regionCode 所属地区code
     */
    List<TreeDto> getStationListByRegionCode(@Param("regionCode")String regionCode);

    /**
     * 根据ProjectOrgCode更新红黄绿码
     * @param analysisResult 更新数据信息
     */
    int updateYardByProjectOrgCode(@Param("list") List<Map<String,String>> analysisResult);

    /**
     * 查询所有场站信息
     */
    List<StationBasicDto> getStationBasicListAll();

}
