package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jxiop.api.dto.IndexDto;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.ColModel;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.DataGridMock;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.ResultsData;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.MonitorFanIndicatorImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.ArrayList;
import java.util.List;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/7/4
 */

@RestController
@Api(tags = "device")
@RequestMapping(value = "/device")
public class DeviceController extends BaseController {

    @Autowired
    MonitorFanIndicatorImpl monitorFanIndicatorImpl;
    @Autowired
    StationBasicMapper stationBasicMapper;

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取每个风机实时告警数据")
    @GetMapping("/nationwide")
    public ResponseModel<ResultsData> getNationWideInfo(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size,@RequestParam(value = "stationBasicId") String stationBasicId,@RequestParam(value = "equipmentNumber" , required = false ) String equipmentNumber) {
        StationBasic stationBasic = stationBasicMapper.selectById(stationBasicId);
        String fanGatewayId = stationBasic.getFanGatewayId();
        ResultsData resultsData=monitorFanIndicatorImpl.getNationWideInfo( current,  size,  fanGatewayId,  equipmentNumber);
        return ResponseHelper.buildResponse(resultsData);
    }



//    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
//    @ApiOperation(value = "获取历史告警数据")
//    @GetMapping("/historyNationwide")
//    public ResponseModel<ResultsData> getLSNationWideInfo(@RequestParam(value = "current") int current,@RequestParam
//            (value = "size") int size,@RequestParam(value = "stationBasicId") String stationBasicId,@RequestParam(value = "equipmentNumber" , required = false ) String equipmentNumber) {
//        ResultsData resultsData=monitorFanIndicatorImpl.getLsNationWideInfo( current,  size,  stationBasicId,  equipmentNumber);
//        return ResponseHelper.buildResponse(resultsData);
//    }


//    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
//    @ApiOperation(value = "监盘大屏 - 获取历史告警数据")
//    @GetMapping("/historyNationwideByPage")
//    public ResponseModel<Page<IndexDto>> historyNationwideByPage(@RequestParam(value = "current") int current,
//                                                              @RequestParam(value = "size") int size,
//                                                              @RequestParam(value = "stationBasicId") String stationBasicId) {
//        Page<IndexDto> resultsData = monitorFanIndicatorImpl.historyNationwideByPage( current,  size,  stationBasicId);
//        return ResponseHelper.buildResponse(resultsData);
//    }




}
