package com.yeejoin.precontrol.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.precontrol.common.entity.CompanyEvaluationLog;
import com.yeejoin.precontrol.common.entity.UserEvaluationLog;
import com.yeejoin.precontrol.common.mapper.CompanyEvaluationLogMapper;
import com.yeejoin.precontrol.common.service.ICompanyEvaluationLogService;
import com.yeejoin.precontrol.common.vo.CompanyEvaluationLogVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 分包商评价记录表 服务实现类
 *
 * @author duanwei
 * @date 2021-01-28
 */
@Service
public class CompanyEvaluationLogServiceImpl extends ServiceImpl<CompanyEvaluationLogMapper, CompanyEvaluationLog> implements ICompanyEvaluationLogService {
    @Autowired
    CompanyEvaluationLogMapper companyEvaluationLogMapper;

    @Override
    public IPage<CompanyEvaluationLog> listByCompanyId(String pageNum, String pageSize, String companyId) {
        Page<CompanyEvaluationLog> pageBean;
        QueryWrapper<CompanyEvaluationLog> companyEvaluationLogQueryWrapper = new QueryWrapper<>();
        companyEvaluationLogQueryWrapper.lambda().eq(CompanyEvaluationLog::getCompanyId, companyId);
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        companyEvaluationLogQueryWrapper.orderByDesc("create_date");
        IPage<CompanyEvaluationLog> page = this.page(pageBean, companyEvaluationLogQueryWrapper);
        return page;
    }

    @Override
    public IPage<CompanyEvaluationLogVo> listVoByCompanyId(String pageNum, String pageSize, String companyId) {
        Page<CompanyEvaluationLogVo> pageBean;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        return companyEvaluationLogMapper.pageList(pageBean, companyId);
    }

    @Override
    public List<CompanyEvaluationLog> listByTaskId(String taskId) {
        QueryWrapper<CompanyEvaluationLog> companyEvaluationLogQueryWrapper = new QueryWrapper<>();
        companyEvaluationLogQueryWrapper.lambda().eq(CompanyEvaluationLog::getTaskId, taskId);
        return this.baseMapper.selectList(companyEvaluationLogQueryWrapper);
    }
}
