package com.yeejoin.amos.boot.module.jg.biz.discardOrder.strategy;

import com.yeejoin.amos.boot.module.jg.api.entity.JgVehicleInformationEq;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgVehicleInformationMapper;
import com.yeejoin.amos.boot.module.jg.biz.discardOrder.factory.support.SupportableDiscardOrderCheck;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgVehicleInformationServiceImpl;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
public class VehicleInformationDiscardOrderCheck implements SupportableDiscardOrderCheck {

    private final JgVehicleInformationMapper jgVehicleInformationMapper;


    @Override
    public boolean support(String clazz) {
        return JgVehicleInformationServiceImpl.class.getSimpleName().equals(clazz);
    }

    @Override
    public Boolean check(List<String> records) {
        if (records.isEmpty()) {
            throw new RuntimeException("单据下不存在气瓶，不能进行作废，请联系管理员！");
        }
        List<JgVehicleInformationEq> eqs = jgVehicleInformationMapper.selectListForSelfDiscard(records);
        if (!eqs.isEmpty()) {
            String msg = String.format("存在设备正在办理或已办理后续业务：%s，不能进行作废！", String.join(",", eqs.stream().map(u -> GenericDiscardOrderCheck.buildErrorMsg(u.getRecUserName())).collect(Collectors.toSet())));
            throw new RuntimeException(msg);
        }
        return true;
    }
}
