package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.entity.TzsBaseEntity;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.biz.common.utils.SnowflakeIdUtil;
import com.yeejoin.amos.boot.module.jg.api.dto.*;
import com.yeejoin.amos.boot.module.jg.api.entity.*;
import com.yeejoin.amos.boot.module.jg.api.enums.*;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgOverDesignServiceLifeEqMapper;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgOverDesignServiceLifeMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IJgOverDesignServiceLifeService;
import com.yeejoin.amos.boot.module.jg.biz.config.LocalBadRequest;
import com.yeejoin.amos.boot.module.jg.biz.context.EquipUsedCheckStrategyContext;
import com.yeejoin.amos.boot.module.jg.biz.context.FlowingEquipRedisContext;
import com.yeejoin.amos.boot.module.jg.biz.event.CancellationEvent;
import com.yeejoin.amos.boot.module.jg.biz.event.publisher.EventPublisher;
import com.yeejoin.amos.boot.module.jg.biz.feign.TzsServiceFeignClient;
import com.yeejoin.amos.boot.module.jg.biz.service.ICmWorkflowService;
import com.yeejoin.amos.boot.module.jg.biz.service.ICompensateFlowDataOfRedis;
import com.yeejoin.amos.boot.module.jg.biz.service.IIdxBizJgInspectionDetectionInfoService;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgDesignInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgInspectionDetectionInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgRegisterInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.InspectionDetectionInfo;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.InspectionDetectionInfoMapper;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.systemctl.model.TaskV2Model;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowBatchDTO;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowStartDTO;
import com.yeejoin.amos.feign.workflow.model.ProcessTaskDTO;
import com.yeejoin.amos.feign.workflow.model.TaskResultDTO;
import io.seata.spring.annotation.GlobalTransactional;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import static java.util.stream.Collectors.toList;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2025-03-06
 */
@Slf4j
@Service
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class JgOverDesignServiceLifeServiceImpl extends BaseService<JgOverDesignServiceLife, JgOverDesignServiceLife, JgOverDesignServiceLifeMapper> implements IJgOverDesignServiceLifeService, ICompensateFlowDataOfRedis<JgOverDesignServiceLife> {

    private static final String DEFINITION_KEY = "overDesignServiceLife";
    public static final String SUBMIT_TYPE_FLOW = "1";
    public static final String SUBMIT_DATA = "0";
    private final List<String> NOT_FLOWING_STATE = Arrays.asList("使用单位待提交", "一级受理已驳回", "使用单位已撤回", "已作废", "已完成");
    private final CommonServiceImpl commonService;
    private final JgOverDesignServiceLifeEqServiceImpl jgOverDesignServiceLifeEqService;
    private final JgRegistrationHistoryServiceImpl jgRegistrationHistoryService;
    private final RedissonClient redissonClient;
    private final RedisUtils redisUtils;
    private final CmWorkflowServiceImpl cmWorkflowService;
    private final JgOverDesignServiceLifeEqMapper jgOverDesignServiceLifeEqMapper;
    private final IdxBizJgRegisterInfoServiceImpl idxBizJgRegisterInfoService;
    private final IdxBizJgInspectionDetectionInfoServiceImpl idxBizJgInspectionDetectionInfoService;
    private final TzsServiceFeignClient tzsServiceFeignClient;
    private final ICmWorkflowService workflowService;
    private final IdxBizJgDesignInfoServiceImpl idxBizJgDesignInfoServiceImpl;
    private final JgUseRegistrationManageServiceImpl useRegistrationManageService;
    private final IIdxBizJgInspectionDetectionInfoService iIdxBizJgInspectionDetectionInfoService;
    private final JgResumeInfoServiceImpl jgResumeInfoService;
    private final InspectionDetectionInfoMapper inspectionDetectionInfoMapper;
    private final SnowflakeIdUtil sequence;
    private final EventPublisher eventPublisher;
    private final EmqKeeper emqKeeper;
    private final DataDictionaryServiceImpl dataDictionaryServiceImpl;

    /**
     * 分页查询
     */
    public Page<Map<String, Object>> getPageList(Page<Map<String, Object>> page, String sort, JgOverDesignServiceLifeDto dto, String orgCode) {
        return this.baseMapper.getListPage(page, commonService.sortFieldConversion(sort), dto, orgCode);
    }

    /**
     * 新增（提交）车用气瓶
     *
     * @param map map
     * @return list
     */
    @Transactional(rollbackFor = Exception.class)
    @GlobalTransactional(rollbackFor = Exception.class)
    public List<JgOverDesignServiceLife> saveOrUpdate(JSONObject map, ReginParams reginParams) {
        CompanyBo company = reginParams.getCompany();
        try {
            if (SUBMIT_TYPE_FLOW.equals(map.get("submit"))) {
                JSONArray useRegistrationFormFile = map.getJSONArray("useRegistrationFormFile");
                if (CollUtil.isEmpty(useRegistrationFormFile)) {
                    throw new BadRequest("特种设备超设计使用年限变更证明（签章后）为空，请上传后再提交！");
                }
            }
            JgOverDesignServiceLifeDto overDesignDto = JSON.parseObject(JSON.toJSONString(map), JgOverDesignServiceLifeDto.class);
            Optional.ofNullable(map.get("useRegistrationFormFile"))
                    .map(JSONObject::toJSONString)
                    .ifPresent(overDesignDto::setUseRegistrationFormFile);
            map.put("userName", reginParams.getUserModel().getRealName());
            Map<String, Object> overDesign = commonService.getRegistrationChangeCertificateUrl(map);
            if (Objects.nonNull(overDesign)) {
                overDesignDto.setUseRegistrationFormUrl(String.valueOf(overDesign.get("useRegistrationFormUrl")));
            }
            List<Map<String, Object>> equipmentLists = (List<Map<String, Object>>) map.get("equipmentLists");
            if (CollectionUtils.isEmpty(equipmentLists)) {
                throw new BadRequest("请选择设备信息!");
            }
            if (SUBMIT_TYPE_FLOW.equals(map.get("submit"))) {
                this.repeatUsedEquipCheck(equipmentLists,
                        CompanyTypeEnum.INDIVIDUAL.getName().equals(company.getCompanyType()) ? company.getCompanyCode().split("_")[1] : company.getCompanyCode());
            }
            List<IdxBizJgInspectionDetectionInfo> inspectionDetectionInfoList = idxBizJgInspectionDetectionInfoService.checkInspectionInfo(
                    equipmentLists.stream()
                            .map(v -> (String) v.get("record"))
                            .collect(Collectors.toList())
            );
            if (equipmentLists.stream().anyMatch(info -> info.get("safetyAssessmentReport") == null || "".equals(info.get("safetyAssessmentReport")))) {
                throw new BadRequest("请补充设备安全评估报告信息后提交！");
            }

            if (inspectionDetectionInfoList.stream().anyMatch(info ->
                    ObjectUtils.isEmpty(info) || ObjectUtils.isEmpty(info.getInspectType()) ||
                            ObjectUtils.isEmpty(info.getInspectConclusion()) || ObjectUtils.isEmpty(info.getInspectOrgCode()))) {
                throw new BadRequest("请补充设备检验检测信息后提交！");
            }
            if ("2000".equals(Objects.toString(map.get("equListCode"))) && equipmentLists.stream().anyMatch(info -> !"WTJY".equals(info.get("inspectType")))) {
                throw new BadRequest("压力容器需要先做委托检验后提交！");
            }
            if (equipmentLists.stream()
                    .map(info -> (String) info.get("nextInspectDate"))
                    .filter(Objects::nonNull)
                    .anyMatch(dateStr -> {
                        try {
                            return LocalDate.parse(dateStr, DateTimeFormatter.ISO_DATE).isBefore(LocalDate.now());
                        } catch (Exception e) {
                            return false;
                        }
                    })) {
                throw new BadRequest("委托检验下次检验日期超期，请重新填写后提交！");
            }
            List<IdxBizJgDesignInfo> designInfoList = idxBizJgDesignInfoServiceImpl.checkOverDesignRegNum(
                    equipmentLists.stream()
                            .map(v -> (String) v.get("record"))
                            .collect(Collectors.toList())
            );
            if (designInfoList.stream().anyMatch(info -> info.getOverDesignRegNum() >= 2)) {
                log.error("超设计使用年限变更登记设备最多延期两次, 设备record: {}", designInfoList.stream().filter(info -> info.getOverDesignRegNum() >= 2)
                        .map(IdxBizJgDesignInfo::getRecord).collect(Collectors.joining(",")));
                throw new BadRequest("超设计使用年限变更登记设备最多延期两次！");
            }
            overDesignDto.setCreateDate(new Date());
            overDesignDto.setPromoter(reginParams.getUserModel().getUserId());

            List<String> registrationNoList = equipmentLists.stream()
                    .map(objectMap -> objectMap.get("useOrgCode"))
                    .filter(Objects::nonNull)
                    .map(Object::toString)
                    .collect(Collectors.toList());

            if ("个人主体".equals(company.getCompanyType())) {
                overDesignDto.setUseUnitName(company.getCompanyName().split("_")[1]);
                overDesignDto.setUseUnitCreditCode(company.getCompanyCode().split("_")[1]);
            } else {
                overDesignDto.setUseUnitName(company.getCompanyName());
                overDesignDto.setUseUnitCreditCode(company.getCompanyCode());
            }

            if (!StringUtils.isEmpty(overDesignDto.getReceiveOrgCode())) {
                String[] splitReceiveOrgCode = overDesignDto.getReceiveOrgCode().split("_");
                CompanyModel result = Privilege.companyClient.queryByCompanyCode(splitReceiveOrgCode[0]).getResult();
                overDesignDto.setReceiveOrgCode(splitReceiveOrgCode[0]);
                overDesignDto.setReceiveOrgName(splitReceiveOrgCode[1]);
                overDesignDto.setReceiveCompanyCode(result.getCompanyCode());
            }

            if (!ObjectUtils.isEmpty(map.get("otherAccessories"))) {
                overDesignDto.setOtherAccessories(JSONObject.toJSONString(map.get("otherAccessories")));
            }
            JgOverDesignServiceLife overDesignServiceLife = new JgOverDesignServiceLife();
            BeanUtils.copyProperties(overDesignDto, overDesignServiceLife);
            overDesignServiceLife.setCreateUserId(reginParams.getUserModel().getUserId());
            overDesignServiceLife.setCreateUserName(reginParams.getUserModel().getRealName());
            overDesignServiceLife.setUseRegistrationCode(String.join("，", registrationNoList));
            Function<String, String> getFirstValue = key -> equipmentLists.stream()
                    .findFirst()
                    .map(e -> Objects.toString(e.get(key), ""))
                    .orElse("");
            overDesignServiceLife.setEquList(getFirstValue.apply("equListCode"));
            overDesignServiceLife.setEquListName(getFirstValue.apply("equList"));
            overDesignServiceLife.setEquCategory(getFirstValue.apply("equCategoryCode"));
            overDesignServiceLife.setEquCategoryName(getFirstValue.apply("equCategory"));
            boolean hasId = StringUtils.isEmpty(overDesignDto.getSequenceNbr());
            //新增
            if (hasId) {
                String applyNo = Objects.toString(map.get("applyNo"), null);
                if (StringUtils.isEmpty(applyNo)) {
                    ResponseModel<List<String>> listResponseModel = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.BZDJ.getCode(), 1);
                    if (!listResponseModel.getResult().isEmpty()) {
                        applyNo = listResponseModel.getResult().get(0);
                    }
                }
                overDesignServiceLife.setApplyNo(applyNo);
                overDesignServiceLife.setStatus(SUBMIT_DATA.equals(map.get("submit")) ? WorkFlowStatusEnum.USE_SUBMIT.getPass() : WorkFlowStatusEnum.USE_RECEIVE.getPass());
                this.save(overDesignServiceLife);
            } else {
                this.getBaseMapper().updateById(overDesignServiceLife);
                LambdaQueryWrapper<JgOverDesignServiceLifeEq> lambda = new QueryWrapper<JgOverDesignServiceLifeEq>().lambda();
                lambda.eq(JgOverDesignServiceLifeEq::getOverDesignId, overDesignServiceLife.getSequenceNbr());
                jgOverDesignServiceLifeEqService.getBaseMapper().delete(lambda);
            }
            if (!CollectionUtils.isEmpty(equipmentLists)) {
                List<JgOverDesignServiceLifeEq> equipList = new ArrayList<>();
                equipmentLists.forEach(device -> {
                    JgOverDesignServiceLifeEq equip = new JgOverDesignServiceLifeEq();
                    equip.setEquId(String.valueOf(device.get("record")));
                    equip.setOverDesignId(Objects.toString(overDesignServiceLife.getSequenceNbr()));
                    equip.setDeviceInfo(JSONObject.toJSONString(device));
                    equip.setUseRegistrationCode(Objects.toString(device.get("useOrgCode"), ""));
                    equip.setEquList(Objects.toString(device.get("equListCode"), ""));
                    equip.setEquCategory(Objects.toString(device.get("equCategoryCode"), ""));
                    equip.setEquDefine(Objects.toString(device.get("equDefineCode"), ""));
                    equip.setSafetyAssessmentName(Objects.toString(device.get("safetyAssessmentName"), ""));
                    equip.setSafetyAssessmentCreditCode(Objects.toString(device.get("safetyAssessmentCreditCode"), ""));
                    equip.setSafetyAssessmentResult(Objects.toString(device.get("safetyAssessmentResult"), ""));
                    equip.setSafetyAssessmentDate(castDate2TimeStr(Objects.toString(device.get("safetyAssessmentDate"), null)));
                    equip.setSafetyAssessmentName(Objects.toString(device.get("equListCode"), ""));
                    if (!ObjectUtils.isEmpty(device.get("safetyAssessmentReport"))) {
                        equip.setSafetyAssessmentReport(JSONObject.toJSONString(device.get("safetyAssessmentReport")));
                    }
                    equipList.add(equip);
                    overDesignServiceLife.setEquList(Objects.toString(device.get("equListCode"), ""));
                    overDesignServiceLife.setEquListName(Objects.toString(device.get("equList"), ""));
                });
                //保存或更新检验信息
                this.updateOrCreateInspectionDetection(equipmentLists);
                jgOverDesignServiceLifeEqService.saveBatch(equipList);
            }
            if (SUBMIT_TYPE_FLOW.equals(map.get("submit"))) {
                List<String> roleListNext = new ArrayList<>();
                List<String> roleListAll = new ArrayList<>();
                if (StringUtils.isEmpty(overDesignServiceLife.getInstanceId())) {
                    ActWorkflowBatchDTO actWorkflowBatchDTO = new ActWorkflowBatchDTO();
                    List<ActWorkflowStartDTO> list = new ArrayList<>();
                    ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
                    dto.setProcessDefinitionKey(DEFINITION_KEY);
                    dto.setBusinessKey(overDesignServiceLife.getApplyNo());
                    dto.setCompleteFirstTask(Boolean.TRUE);
                    dto.setNextExecuteUserCompanyCode(overDesignServiceLife.getReceiveCompanyCode());
                    list.add(dto);
                    actWorkflowBatchDTO.setProcess(list);
                    List<ProcessTaskDTO> processTasks = workflowService.startBatch(actWorkflowBatchDTO);
                    this.buildRoleList(processTasks, roleListNext, roleListAll);
                    List<WorkflowResultDto> workflowResultDtoList = commonService.buildWorkFlowInfo(processTasks);
                    if (!ObjectUtils.isEmpty(workflowResultDtoList) && !ObjectUtils.isEmpty(workflowResultDtoList.get(0))) {
                        WorkflowResultDto workflowResultDto = workflowResultDtoList.get(0);
                        this.updateData(overDesignServiceLife.getSequenceNbr(), "0", workflowResultDto, Boolean.TRUE, String.valueOf(map.get("equDefineCode")));
                    }
                } else {
                    // 执行流程
                    flowExecute(overDesignServiceLife.getSequenceNbr(), overDesignServiceLife.getInstanceId(), "0", "", String.valueOf(map.get("nextTaskId")), String.valueOf(map.get("equDefineCode")));
                }
            } else {
                if (ObjectUtils.isEmpty(map.get("instanceId"))) {
                    ArrayList<TaskModelDto> list = new ArrayList<>();
                    TaskModelDto dto = new TaskModelDto();
                    TaskMessageDto taskMessageDto = new TaskMessageDto();
                    BeanUtil.copyProperties(overDesignServiceLife, taskMessageDto);
                    taskMessageDto.setEquipId(String.valueOf(map.get("equipId")));
                    dto.setModel(taskMessageDto);
                    dto.setTaskContent(String.format("来自%s的业务办理，【申请单号：%s】", ObjectUtils.isEmpty(overDesignServiceLife.getEquListName()) ? "" : overDesignServiceLife.getEquListName(),
                            overDesignServiceLife.getApplyNo()));
                    dto.setTaskCode(overDesignServiceLife.getApplyNo());
                    dto.setTaskType(String.valueOf(BusinessTypeEnum.JG_OVER_DESIGN_SERVICE_LIFE.getCode()));
                    dto.setRelationId(String.valueOf(overDesignServiceLife.getSequenceNbr()));
                    dto.setNextExecuteUser("");
                    list.add(dto);
                    commonService.buildTaskModel(list);
                }
            }
            commonService.saveOrUpdateHistory(BusinessTypeEnum.JG_OVER_DESIGN_SERVICE_LIFE.getName(), map, null, overDesignServiceLife.getSequenceNbr() + "");
            return Collections.singletonList(overDesignServiceLife);
        } catch (BadRequest | LocalBadRequest e) {
            log.error(e.getMessage(), e);
            this.rollBackForDelRedisData();
            throw e;
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            this.rollBackForDelRedisData();
            throw new BadRequest("保存失败！");
        } finally {
            FlowingEquipRedisContext.clean();
        }
    }

    private void buildRoleList(List<ProcessTaskDTO> processTasks, List<String> roleListNext, List<String> roleListAll) {
        processTasks.forEach(p -> {
            p.getNextCandidateGroups().values().forEach(e -> {
                roleListNext.addAll(e);
                roleListAll.addAll(e);
            });
            roleListAll.addAll(p.getCandidateGroups());
        });
    }

    private void rollBackForDelRedisData() {
        FlowingEquipRedisContext.getContext().forEach(e -> {
            EquipUsedCheckStrategyContext.getUsedStrategy(DEFINITION_KEY)
                    .delDataForCheckWithKey(e.getData(), e.getRedisKey());
        });
    }


    private void repeatUsedEquipCheck(List<Map<String, Object>> equipList, String companyCode) {
        equipList.forEach(equipMap -> EquipUsedCheckStrategyContext.getUsedStrategy(DEFINITION_KEY)
                .equipRepeatUsedCheck(String.valueOf(equipMap.get("record")), companyCode));
    }

    @Transactional(rollbackFor = Exception.class)
    @GlobalTransactional(rollbackFor = Exception.class)
    public Boolean deleteBatchBySequenceNbrs(List<Long> sequenceNbrs) {
        if (CollUtil.isNotEmpty(sequenceNbrs)) {
            for (Long sequenceNbr : sequenceNbrs) {
                JgOverDesignServiceLife overDesignServiceLife = this.baseMapper.selectById(sequenceNbr);
                // 删除代办 + 中止流程
                commonService.deleteTaskModel(String.valueOf(sequenceNbr), overDesignServiceLife.getInstanceId());
                // 删除单子
                LambdaUpdateWrapper<JgOverDesignServiceLife> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(JgOverDesignServiceLife::getSequenceNbr, sequenceNbr).set(JgOverDesignServiceLife::getIsDelete, true);
                this.update(updateWrapper);

                // 更新 eq 对应数据的 isDelete 字段为true（逻辑删除）
                LambdaUpdateWrapper<JgOverDesignServiceLifeEq> overDesignServiceLifeEqWrapper = new LambdaUpdateWrapper<JgOverDesignServiceLifeEq>()
                        .eq(JgOverDesignServiceLifeEq::getEquId, sequenceNbr)
                        .set(JgOverDesignServiceLifeEq::getIsDelete, true);
                jgOverDesignServiceLifeEqService.getBaseMapper().update(null, overDesignServiceLifeEqWrapper);
                // 删除单子对应历史表数据
                jgRegistrationHistoryService.getBaseMapper().update(null,
                        new LambdaUpdateWrapper<JgRegistrationHistory>()
                                .eq(JgRegistrationHistory::getCurrentDocumentId, overDesignServiceLife.getApplyNo())
                                .set(JgRegistrationHistory::getIsDelete, true)
                );
            }
        }
        return Boolean.TRUE;
    }

    /**
     * 撤回
     *
     * @param instanceId 流程id
     * @param nextTaskId 任务id
     * @param manageType 类型
     */
    @Transactional(rollbackFor = Exception.class)
    @GlobalTransactional(rollbackFor = Exception.class)
    public void cancel(String instanceId, String nextTaskId, String manageType) {
        String lockKey = CommonServiceImpl.buildJgExecuteLockKey(instanceId);
        RLock lock = redissonClient.getLock(lockKey);
        try {
            boolean isLocked = lock.tryLock(0, 180, TimeUnit.SECONDS);
            if (!isLocked) {
                throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
            }
            // 撤回校验
            commonService.checkForRevocationFlow(nextTaskId, instanceId);

            JgOverDesignServiceLife overDesign = new JgOverDesignServiceLife();
            ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
            ProcessTaskDTO processTaskDTO = cmWorkflowService.rollBack(instanceId);
            ArrayList<ProcessTaskDTO> processTaskDTOS = new ArrayList<>();
            processTaskDTOS.add(processTaskDTO);
            List<WorkflowResultDto> resultDto = commonService.buildWorkFlowInfo(processTaskDTOS);
            String taskCode = "";
            String roles = "";
            if (!ObjectUtils.isEmpty(resultDto) && !ObjectUtils.isEmpty(resultDto.get(0))) {
                taskCode = resultDto.get(0).getNextTaskCode();
                roles = resultDto.get(0).getNextExecutorRoleIds();
                overDesign.setNextTaskId(resultDto.get(0).getNextTaskId());
                overDesign.setNextExecuteUserIds(resultDto.get(0).getNextExecutorUserIds());
            }
            LambdaQueryWrapper<JgOverDesignServiceLife> lambda = new QueryWrapper<JgOverDesignServiceLife>().lambda();
            lambda.eq(JgOverDesignServiceLife::getInstanceId, instanceId);
            if (!ObjectUtils.isEmpty(taskCode)) {
                overDesign.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getRollBack());
            }
            overDesign.setPromoter(reginParams.getUserModel().getUserId());
            overDesign.setNextExecuteIds(roles);
            this.update(overDesign, lambda);
            LambdaQueryWrapper<JgOverDesignServiceLife> queryWrapper = new QueryWrapper<JgOverDesignServiceLife>().lambda();
            queryWrapper.eq(JgOverDesignServiceLife::getInstanceId, instanceId);
            queryWrapper.eq(JgOverDesignServiceLife::getIsDelete, false);
            JgOverDesignServiceLife data = this.baseMapper.selectOne(queryWrapper);
            // 设备信息
            JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(data));
            jsonObject.put("nextTaskId", data.getNextTaskId());
            jsonObject.put("nextExecuteUser", data.getNextExecuteIds());
            jsonObject.put("taskType", BusinessTypeEnum.JG_OVER_DESIGN_SERVICE_LIFE.getCode());
            jsonObject.put("flowStatus", commonService.getDictionaryCodeByName(overDesign.getStatus()));
            jsonObject.put("flowStatusLabel", overDesign.getStatus());
            jsonObject.remove("otherAccessories");
            jsonObject.remove("instanceStatus");
            setEquListCode2Json(data, jsonObject);
            // 非单位办理
            if (!"unit".equals(manageType)) {
                LambdaQueryWrapper<JgOverDesignServiceLifeEq> lambda1 = new QueryWrapper<JgOverDesignServiceLifeEq>().lambda();
                lambda1.eq(JgOverDesignServiceLifeEq::getOverDesignId, String.valueOf(data.getSequenceNbr()));
                lambda1.eq(JgOverDesignServiceLifeEq::getIsDelete, false);
                JgOverDesignServiceLifeEq jgOverDesignServiceLifeEq = jgOverDesignServiceLifeEqMapper.selectOne(lambda1);
                jsonObject.put("equipId", jgOverDesignServiceLifeEq.getEquId());
            }
            if (!WorkFlowStatusEnum.USE_SUBMIT.getCode().equals(taskCode)) {
                jsonObject.put("pageType", "look");
            }
            // 撤回删除代办
            commonService.rollbackTask(instanceId, jsonObject);
            // redis流程实时数据更新
            commonService.saveExecuteFlowData2Redis(instanceId, this.buildInstanceRuntimeData(data));
            this.clearDataForCheckEquipRepeatUsed(data);
        } catch (InterruptedException e) {
            e.printStackTrace();
        } finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }

    /**
     * 执行流程
     *
     * @param sequenceNbr sequenceNbr
     * @param instanceId  instanceId
     * @param operate     操作
     * @param comment     意见
     * @param nextTaskId  nextTaskId
     */
    @Transactional(rollbackFor = Exception.class)
    @GlobalTransactional(rollbackFor = Exception.class)
    public void flowExecute(Long sequenceNbr, String instanceId, String operate, String comment, String nextTaskId, String equDefineCode) {
        String lockKey = CommonServiceImpl.buildJgExecuteLockKey(instanceId);
        RLock lock = redissonClient.getLock(lockKey);
        try {
            boolean isLocked = lock.tryLock(0, 180, TimeUnit.SECONDS);
            // 解决并发问题：多个人同时操作一个流程（并发执行通过、驳回、撤回）
            if (!isLocked) {
                throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
            }
            // 流程执行时，状态及权限校验
            commonService.checkForExecuteFlow(nextTaskId, instanceId);

            JgOverDesignServiceLife jgOverDesignServiceLife = this.getBaseMapper().selectById(sequenceNbr);
            // 组装信息
            TaskResultDTO dto = new TaskResultDTO();
            dto.setResultCode("approvalStatus");
            dto.setTaskId(jgOverDesignServiceLife.getNextTaskId());
            dto.setComment(comment);
            HashMap<String, Object> map = new HashMap<>();
            map.put("approvalStatus", operate);
            if (jgOverDesignServiceLife.getStatus().equals(WorkFlowStatusEnum.USE_SUBMIT.getReject()) || jgOverDesignServiceLife.getStatus().equals(WorkFlowStatusEnum.USE_SUBMIT.getRollBack())) {
                map.put("approvalStatus", "提交");
            }
            dto.setVariable(map);
            // 接受机构
            if ("1".equals(operate) && WorkFlowStatusEnum.USE_RECEIVE.getPass().equals(jgOverDesignServiceLife.getStatus())) {
                // 驳回到使用单位
                dto.setNextExecuteUserCompanyCode(jgOverDesignServiceLife.getUseUnitCreditCode());
            } else {
                dto.setNextExecuteUserCompanyCode(jgOverDesignServiceLife.getReceiveCompanyCode());
            }
            ProcessTaskDTO complete = cmWorkflowService.completeOrReject(jgOverDesignServiceLife.getNextTaskId(), dto, operate);
            ArrayList<ProcessTaskDTO> processTaskDTOS = new ArrayList<>();
            processTaskDTOS.add(complete);
            List<WorkflowResultDto> resultDto = commonService.buildWorkFlowInfo(processTaskDTOS);
            if (!ObjectUtils.isEmpty(resultDto) && !ObjectUtils.isEmpty(resultDto.get(0))) {
                WorkflowResultDto workflowResultDto = resultDto.get(0);
                this.updateData(jgOverDesignServiceLife.getSequenceNbr(), operate, workflowResultDto, Boolean.FALSE, equDefineCode);
            }
            this.delRepeatUseEquipData(jgOverDesignServiceLife);
        } catch (InterruptedException e) {
            e.printStackTrace();
        } finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }

    /**
     * 更新数据
     *
     * @param sequenceNbr       sequenceNbr
     * @param operate           operate
     * @param workflowResultDto workflowResultDto
     * @param isFirst           isFirst
     */
    public void updateData(Long sequenceNbr, String operate, WorkflowResultDto workflowResultDto, Boolean isFirst, String equDefineCode) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())) + "", ReginParams.class);
        String role = workflowResultDto.getNextExecutorRoleIds();
        String taskCode = FlowStatusEnum.TO_BE_FINISHED.getName();
        if (!ObjectUtils.isEmpty(workflowResultDto.getNextTaskCode())) {
            taskCode = workflowResultDto.getNextTaskCode();
        }
        JgOverDesignServiceLife jgOverDesignServiceLife = this.getBaseMapper().selectById(sequenceNbr);

        jgOverDesignServiceLife.setNextTaskId(workflowResultDto.getNextTaskId());
        jgOverDesignServiceLife.setNextExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
        commonService.deleteTasksByRelationId(sequenceNbr + "");
        if (isFirst) {
            jgOverDesignServiceLife.setInstanceStatus(workflowResultDto.getExecutorRoleIds());
            jgOverDesignServiceLife.setInstanceId(workflowResultDto.getInstanceId());
        }
        //非完成
        if (!FlowStatusEnum.TO_BE_FINISHED.getName().equals(taskCode)) {
            jgOverDesignServiceLife.setNextExecuteIds(role);
            jgOverDesignServiceLife.setPromoter(reginParams.getUserModel().getUserId());
            if (!ObjectUtils.isEmpty(jgOverDesignServiceLife.getInstanceStatus())) {
                jgOverDesignServiceLife.setInstanceStatus(jgOverDesignServiceLife.getInstanceStatus() + "," + role);
            } else {
                jgOverDesignServiceLife.setInstanceStatus(role);
            }
            if ("0".equals(operate)) {
                // 通过操作
                jgOverDesignServiceLife.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getPass());
            } else {
                // 驳回操作
                jgOverDesignServiceLife.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getReject());
                jgOverDesignServiceLife.setPromoter("");
            }
            if (isFirst) {
                this.buildTask(jgOverDesignServiceLife, workflowResultDto);
            } else {
                // 更新代办状态
                HashMap<String, Object> params = new HashMap<>();
                params.put("relationId", jgOverDesignServiceLife.getInstanceId());
                params.put("flowStatus", commonService.getDictionaryCodeByName(jgOverDesignServiceLife.getStatus()));
                params.put("flowStatusLabel", jgOverDesignServiceLife.getStatus());
                params.put("taskStatus", commonService.getDictionaryCodeByName(jgOverDesignServiceLife.getStatus()));
                params.put("taskStatusLabel", jgOverDesignServiceLife.getStatus());
                TaskV2Model taskV2Model = commonService.updateTaskModel(params);
                // 创建新的代办
                if (!ObjectUtils.isEmpty(taskV2Model)) {
                    TaskModelDto taskModelDto = new TaskModelDto();
                    BeanUtils.copyProperties(taskV2Model, taskModelDto);
                    TaskMessageDto taskMessageDto = new TaskMessageDto();
                    BeanUtil.copyProperties(jgOverDesignServiceLife, taskMessageDto);
                    taskModelDto.setModel(taskMessageDto);
                    taskModelDto.setTaskName(workflowResultDto.getNextTaskName());
                    taskModelDto.setExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
                    taskModelDto.setTaskStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
                    taskModelDto.setNextExecuteUser(workflowResultDto.getNextExecutorRoleIds());
                    taskModelDto.setFlowCode(workflowResultDto.getNextTaskId());
                    if (WorkFlowStatusEnum.USE_SUBMIT.getCode().equals(taskCode) && "1".equals(operate)) {
                        taskModelDto.setPageType("edit");
                    }
                    commonService.buildTaskModel(Collections.singletonList(taskModelDto));
                } else {
                    workflowResultDto.setInstanceId(jgOverDesignServiceLife.getInstanceId());
                    buildTask(jgOverDesignServiceLife, workflowResultDto);
                }
            }
        } else {
            // 流程结束
            jgOverDesignServiceLife.setStatus(taskCode);
            jgOverDesignServiceLife.setNextExecuteUserIds("");

            LambdaQueryWrapper<JgRegistrationHistory> lambdaSelect = new QueryWrapper<JgRegistrationHistory>().lambda();
            lambdaSelect.eq(JgRegistrationHistory::getCurrentDocumentId, String.valueOf(sequenceNbr));
            lambdaSelect.eq(JgRegistrationHistory::getIsDelete, false);
            JgRegistrationHistory jgRegistrationHistory = jgRegistrationHistoryService.getBaseMapper().selectOne(lambdaSelect);
            String jsonData = jgRegistrationHistory.getChangeData();
            JSONObject jsonObject = JSONObject.parseObject(jsonData);
            HashMap<String, Object> params = new HashMap<>();
            params.put("relationId", jgOverDesignServiceLife.getInstanceId());
            params.put("flowStatus", commonService.getDictionaryCodeByName(jgOverDesignServiceLife.getStatus()));
            params.put("flowStatusLabel", jgOverDesignServiceLife.getStatus());
            params.put("taskStatus", FlowStatusEnum.TO_BE_FINISHED.getCode());
            params.put("taskStatusLabel", FlowStatusEnum.TO_BE_FINISHED.getName());
            TaskMessageDto taskMessageDto = new TaskMessageDto();
            BeanUtil.copyProperties(jgOverDesignServiceLife, taskMessageDto);
            params.put("model", taskMessageDto);
            TaskV2Model taskV2Model = commonService.updateTaskModel(params);
            this.updateEquipMessage(jsonObject, taskV2Model, jgOverDesignServiceLife);
        }
        this.getBaseMapper().updateById(jgOverDesignServiceLife);
        commonService.saveExecuteFlowData2Redis(jgOverDesignServiceLife.getInstanceId(), this.buildInstanceRuntimeData(jgOverDesignServiceLife));
    }

    private void updateEquipMessage(JSONObject jsonObject, TaskV2Model taskV2Model, JgOverDesignServiceLife jgOverDesignServiceLife) {
        List<Map<String, Object>> equipmentLists = (List<Map<String, Object>>) jsonObject.get("equipmentLists");
        List<String> useOrgCodes = equipmentLists.stream()
                .map(obj -> Objects.toString(obj.get("useOrgCode"), ""))
                .collect(Collectors.toList());
        List<String> records = equipmentLists.stream()
                .map(v -> Objects.toString(v.get("record"), ""))
                .collect(Collectors.toList());
        List<IdxBizJgDesignInfo> designInfoList = idxBizJgDesignInfoServiceImpl.checkOverDesignRegNum(records);
        if (CollectionUtils.isEmpty(designInfoList)) {
            throw new BadRequest("未查询到设备设计信息!");
        }
        // 更新检验检测信息
//        this.updateOrCreateInspectionDetection(equipmentLists);
        this.sendOverDesignMessage(equipmentLists);
        this.updateDesignInfo(taskV2Model, jgOverDesignServiceLife, equipmentLists, designInfoList);
        this.updateRegistrationManage(useOrgCodes);
    }

    private Date castDate2TimeStr(String date) {
        if (date == null) return null;
        try {
            return DateUtil.date(Long.parseLong(date));
        } catch (NumberFormatException e) {
            return DateUtil.parse(date, "yyyy-MM-dd");
        }
    }

    private void updateOrCreateInspectionDetection(List<Map<String, Object>> equipmentLists) {
        for (Map<String, Object> equipment : equipmentLists) {
            equipment.remove("recDate");
            InspectionDetectionInfo inspectionDetectionInfo = new InspectionDetectionInfo();
            BeanUtil.copyProperties(equipment, inspectionDetectionInfo);
            // 处理jySeq更新逻辑
            String jySeq = Objects.toString(equipment.get("jySeq"), "");
            if (!jySeq.isEmpty()) {
                InspectionDetectionInfo inspectionDetectionInfoDb = inspectionDetectionInfoMapper.selectById(jySeq);
                if (inspectionDetectionInfoDb != null) {
                    Bean.copyExistPropertis(inspectionDetectionInfo, inspectionDetectionInfoDb);
                    inspectionDetectionInfoDb.setRecDate(new Date());
                    inspectionDetectionInfoMapper.updateById(inspectionDetectionInfoDb);
                }
                continue;
            }
            // 处理新增逻辑
            String record = Objects.toString(equipment.get("record"), "");
            if (inspectionDetectionInfo.getInspectType() != null && inspectionDetectionInfo.getInspectConclusion() != null) {
                inspectionDetectionInfo.setRecord(record);
                inspectionDetectionInfo.setRecDate(new Date());
                inspectionDetectionInfo.setSequenceNbr(String.valueOf(sequence.nextId()));
                inspectionDetectionInfoMapper.insert(inspectionDetectionInfo);
            }
            //更新ES
            if (inspectionDetectionInfo.getNextInspectDate() != null) {
                tzsServiceFeignClient.commonUpdateEsDataByIds(Collections.singletonMap(record,
                        Collections.singletonMap("NEXT_INSPECT_DATE", inspectionDetectionInfo.getNextInspectDate().getTime())
                ));
            }
        }

    }

    private void updateDesignInfo(TaskV2Model taskV2Model, JgOverDesignServiceLife jgOverDesignServiceLife, List<Map<String, Object>> equipmentLists, List<IdxBizJgDesignInfo> designInfoList) {
        String equListCode = Objects.toString(equipmentLists.get(0).get("equListCode"), "");
        ZoneId zoneId = ZoneId.systemDefault();
        designInfoList.forEach(designInfo -> {
            List<IdxBizJgInspectionDetectionInfo> inspectionList =
                    iIdxBizJgInspectionDetectionInfoService.queryInspectionListByRecord(designInfo.getRecord());
            designInfo.setOverDesignRegNum(Math.min(designInfo.getOverDesignRegNum() + 1, 2));
            IdxBizJgInspectionDetectionInfo inspectionDetectionInfo = inspectionList.stream()
                    .filter(info -> "6000".equals(equListCode) || "WTJY".equals(info.getInspectType()))
                    .findFirst()
                    .orElse(null);
            if (inspectionDetectionInfo != null) {
                boolean is6000 = "6000".equals(equListCode);
                Date targetDate = is6000 ? inspectionDetectionInfo.getInspectDate() : inspectionDetectionInfo.getNextInspectDate();
                if (targetDate != null) {
                    // 将 targetDate 转换为 Instant，再转换为 LocalDate，避免解析错误
                    String resultDate = targetDate.toInstant() // 将 Date 转换为 Instant
                            .atZone(zoneId) // 转为 ZoneDateTime
                            .toLocalDate() // 转为 LocalDate
                            .plusYears(is6000 ? 4 : 0) // 根据条件加上年份
                            .toString(); // 转换为 String 类型
                    designInfo.setDelayServiceLifeDate(resultDate);
                }
            }

            idxBizJgDesignInfoServiceImpl.saveOrUpdateBatch(designInfoList);
            this.saveResumeInfo(taskV2Model, jgOverDesignServiceLife, designInfo);
        });
    }

    /**
     * 发送超设计使用年限消息
     *
     * @param equipmentLists 设备信息
     */
    private void sendOverDesignMessage(List<Map<String, Object>> equipmentLists) {
        log.info("发送超设计使用年限原始消息equipmentLists---->{}", equipmentLists);
        JSONArray jsonArray = JSON.parseArray(JSON.toJSONString(equipmentLists));
        log.info("发送超设计使用年限原始消息jsonArray---->{}", jsonArray);
        if (CollectionUtil.isNotEmpty(jsonArray)) {
            try {
                emqKeeper.getMqttClient().publish(SafetyProblemTypeEnum.SJNXDJ.getTopic(), jsonArray.toString().getBytes(StandardCharsets.UTF_8), 2, false);
            } catch (MqttException e) {
                log.error("发送超设计使用年限消息失败---->{}", e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }

    private void updateRegistrationManage(List<String> useOrgCodes) {
        List<JgUseRegistrationManage> registrationList = useRegistrationManageService.lambdaQuery()
                .in(JgUseRegistrationManage::getUseRegistrationCode, useOrgCodes)
                .eq(JgUseRegistrationManage::getIsDelete, 0)
                .eq(JgUseRegistrationManage::getCertificateStatus, CertificateStatusEnum.YIDENGJI.getName()).list();
        if (!CollectionUtils.isEmpty(registrationList)) {
            useRegistrationManageService.updateBatchById(
                    registrationList.stream().peek(v -> {
                        v.setIsOverDesign("1");
                        v.setVersion(v.getVersion() + 1);
                    }).collect(Collectors.toList())
            );
        }
    }

    private void saveResumeInfo(TaskV2Model taskV2Model, JgOverDesignServiceLife jgOverDesignServiceLife, IdxBizJgDesignInfo designInfo) {
        jgResumeInfoService.createWithModel(JgResumeInfoDto.builder()
                .applyNo(jgOverDesignServiceLife.getApplyNo())
                .businessType(BusinessTypeEnum.JG_OVER_DESIGN_SERVICE_LIFE.getName())
                .businessId(jgOverDesignServiceLife.getSequenceNbr() + "")
                .equId(designInfo.getRecord())
                .approvalUnit(jgOverDesignServiceLife.getReceiveOrgName())
                .approvalUnitCode(jgOverDesignServiceLife.getReceiveCompanyCode())
                .status("正常")
                .changeContent(BusinessTypeEnum.JG_OVER_DESIGN_SERVICE_LIFE.getName() + "业务办理")
                .routePath(taskV2Model.getRoutePath())
                .build());
    }

    private void buildTask(JgOverDesignServiceLife jgOverDesignServiceLife, WorkflowResultDto workflowResultDto) {
        // 代办消息
        ArrayList<TaskModelDto> list = new ArrayList<>();
        TaskModelDto dto = new TaskModelDto();
        dto.setTaskType(String.valueOf(BusinessTypeEnum.JG_OVER_DESIGN_SERVICE_LIFE.getCode()));
        dto.setTaskTypeLabel(BusinessTypeEnum.JG_OVER_DESIGN_SERVICE_LIFE.getName());
        dto.setFlowCreateDate(jgOverDesignServiceLife.getCreateDate());
        dto.setTaskName(workflowResultDto.getNextTaskName());
        dto.setTaskCode(workflowResultDto.getNextTaskCode());
        dto.setRelationId(workflowResultDto.getInstanceId());
        dto.setExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
        dto.setTaskStatus(commonService.getDictionaryCodeByName(WorkFlowStatusEnum.getMessage(workflowResultDto.getNextTaskCode()).getPass()));
        dto.setTaskStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
        dto.setFlowStatus(commonService.getDictionaryCodeByName(jgOverDesignServiceLife.getStatus()));
        dto.setFlowStatusLabel(jgOverDesignServiceLife.getStatus());
        dto.setStartUserId(jgOverDesignServiceLife.getCreateUserId());
        dto.setStartUser(jgOverDesignServiceLife.getCreateUserName());
        dto.setStartUserCompanyName(jgOverDesignServiceLife.getUseUnitName());
        dto.setStartDate(new Date());
        jgOverDesignServiceLife.setInstanceId(workflowResultDto.getInstanceId());
        // 设备信息
        jgOverDesignServiceLife.setNextExecuteIds(workflowResultDto.getNextExecutorRoleIds());
        TaskMessageDto taskMessageDto = new TaskMessageDto();
        BeanUtil.copyProperties(jgOverDesignServiceLife, taskMessageDto);
        dto.setModel(taskMessageDto);
        dto.setNextExecuteUser(workflowResultDto.getNextExecutorRoleIds());
        dto.setTaskContent(
                String.format("来自%s的业务办理，【申请单号：%s】",
                        ObjectUtils.isEmpty(jgOverDesignServiceLife.getEquListName()) ? "" : jgOverDesignServiceLife.getEquListName(),
                        jgOverDesignServiceLife.getApplyNo()));
        dto.setFlowCode(jgOverDesignServiceLife.getNextTaskId());
        list.add(dto);
        commonService.buildTaskModel(list);
    }

    private void setEquListCode2Json(JgOverDesignServiceLife jgOverDesignServiceLife, JSONObject jsonObject) {
        TaskMessageDto taskMessageDto = new TaskMessageDto();
        this.setEquListForWorkSpace(jgOverDesignServiceLife, taskMessageDto);
        jsonObject.put("equListCode", taskMessageDto.getEQU_LIST_CODE());
    }

    private void setEquListForWorkSpace(JgOverDesignServiceLife jgOverDesignServiceLife, TaskMessageDto taskMessageDto) {
        LambdaQueryWrapper<JgOverDesignServiceLifeEq> jgUseRegEqWrapper = new QueryWrapper<JgOverDesignServiceLifeEq>().lambda();
        jgUseRegEqWrapper.eq(JgOverDesignServiceLifeEq::getOverDesignId, String.valueOf(jgOverDesignServiceLife.getSequenceNbr()));
        List<JgOverDesignServiceLifeEq> jgUseRegistrationEqList = jgOverDesignServiceLifeEqMapper.selectList(jgUseRegEqWrapper);
        if (!jgUseRegistrationEqList.isEmpty()) {
            String equId = jgUseRegistrationEqList.get(0).getEquId();
            taskMessageDto.setEQU_LIST_CODE(this.getEquipListCode(equId));
        }
    }

    public String getEquipListCode(String record) {
        IdxBizJgRegisterInfo registerInfo = idxBizJgRegisterInfoService.getOne(new LambdaQueryWrapper<IdxBizJgRegisterInfo>().eq(IdxBizJgRegisterInfo::getRecord, record).select(TzsBaseEntity::getSequenceNbr, IdxBizJgRegisterInfo::getEquList));
        if (registerInfo != null) {
            return registerInfo.getEquList();
        }
        return null;
    }

    public InstanceRuntimeData buildInstanceRuntimeData(JgOverDesignServiceLife overDesign) {
        return InstanceRuntimeData.builder()
                .nextExecuteUserIds(overDesign.getNextExecuteUserIds())
                .promoter(overDesign.getPromoter())
                .nextTaskId(overDesign.getNextTaskId())
                .build();
    }

    /**
     * 删除 redis校验重复引用设备的数据
     */
    private void delRepeatUseEquipData(JgOverDesignServiceLife overDesignServiceLife) {
        if (NOT_FLOWING_STATE.contains(overDesignServiceLife.getStatus())) {
            LambdaQueryWrapper<JgOverDesignServiceLifeEq> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(JgOverDesignServiceLifeEq::getOverDesignId, overDesignServiceLife.getSequenceNbr());
            List<JgOverDesignServiceLifeEq> overDesignServiceLifeEqs = jgOverDesignServiceLifeEqService.list(queryWrapper);
            overDesignServiceLifeEqs.forEach(overDesignServiceLifeEq -> EquipUsedCheckStrategyContext.getUsedStrategy(DEFINITION_KEY)
                    .delDataForCheckEquipRepeatUsed(Collections.singletonList(overDesignServiceLifeEq.getEquId()), overDesignServiceLife.getUseUnitCreditCode()));
        }
    }

    private void clearDataForCheckEquipRepeatUsed(JgOverDesignServiceLife data) {
        // 新查询原因 useRegistration 数据状态是旧的
        JgOverDesignServiceLife overDesignServiceLife = this.getById(data.getSequenceNbr());
        LambdaQueryWrapper<JgOverDesignServiceLifeEq> lambda = new QueryWrapper<JgOverDesignServiceLifeEq>().lambda();
        lambda.eq(JgOverDesignServiceLifeEq::getOverDesignId, data.getSequenceNbr());
        lambda.select(JgOverDesignServiceLifeEq::getEquId);
        List<JgOverDesignServiceLifeEq> eqList = jgOverDesignServiceLifeEqMapper.selectList(lambda);
        // 在使用单位待提交、一级受理已驳回、使用单位已撤回后清除关联的设备，保证可以再次新提单子选择相同的设备进行提交及原有单子的提交校验数据准备
        if (NOT_FLOWING_STATE.contains(overDesignServiceLife.getStatus()) ||
                FlowStatusEnum.TO_BE_DISCARD.getName().equals(data.getStatus())) {
            List<String> records = eqList.stream().map(JgOverDesignServiceLifeEq::getEquId).collect(toList());
            EquipUsedCheckStrategyContext.getUsedStrategy(DEFINITION_KEY)
                    .delDataForCheckEquipRepeatUsed(records, data.getUseUnitCreditCode());
        }
    }

    public Map<String, Object> getDetail(Long sequenceNbr) {
        Map<String, Object> resultDataMap = new HashMap<>();
        JgOverDesignServiceLife overDesignServiceLife = this.getById(sequenceNbr);
        this.doCompensate(overDesignServiceLife);
        JgRegistrationHistory jgRegistrationHistory = jgRegistrationHistoryService.getBaseMapper()
                .selectOne(new QueryWrapper<JgRegistrationHistory>().lambda()
                        .eq(JgRegistrationHistory::getCurrentDocumentId, sequenceNbr)
                        .eq(JgRegistrationHistory::getIsDelete, false));
        JSONObject jsonObject = JSONObject.parseObject(jgRegistrationHistory.getChangeData());
        List<Map<String, Object>> equipmentLists = (List<Map<String, Object>>) jsonObject.get("equipmentLists");
        if (FlowStatusEnum.TO_BE_FINISHED.getName().equals(overDesignServiceLife.getStatus()) &&
                !ValidationUtil.isEmpty(jsonObject) &&
                !ValidationUtil.isEmpty(overDesignServiceLife)) {
            Map<String, Object> transferToMap = Bean.BeantoMap(overDesignServiceLife);
            resultDataMap.put("equipmentLists", jsonObject.get("equipmentLists"));
            resultDataMap.putAll(transferToMap);
        } else if (!ValidationUtil.isEmpty(overDesignServiceLife)) {
            List<String> records = equipmentLists.stream()
                    .map(v -> (String) v.get("record"))
                    .collect(Collectors.toList());
            resultDataMap.putAll(Bean.BeantoMap(overDesignServiceLife));
            List<Map<String, Object>> result = this.getBaseMapper().selectEquipList(records);
            jsonObject.remove("equipmentLists");
            resultDataMap.put("equipmentLists", result);
        }
        List<String> useOrgCodes = equipmentLists.stream()
                .map(obj -> ((JSONObject) obj).getString("useOrgCode"))
                .collect(Collectors.toList());
        List<JgUseRegistrationManage> registrationList = useRegistrationManageService.lambdaQuery()
                .in(JgUseRegistrationManage::getUseRegistrationCode, useOrgCodes)
                .eq(JgUseRegistrationManage::getIsDelete, 0)
                .eq(JgUseRegistrationManage::getCertificateStatus, CertificateStatusEnum.YIDENGJI.getName())
                .list();
        String companyAndOrg = overDesignServiceLife.getReceiveCompanyCode() + "_" + overDesignServiceLife.getReceiveOrgName();
        resultDataMap.put("receiveCompanyCode", companyAndOrg);
        resultDataMap.put("receiveOrgCode", companyAndOrg);
        resultDataMap.put("sequenceNbrs", registrationList.stream()
                .map(BaseEntity::getSequenceNbr)
                .collect(Collectors.toList()));
        commonService.convertStringToJsonobject(resultDataMap, new String[]{"otherAccessories"});
        commonService.convertStringToJsonobject(resultDataMap, new String[]{"useRegistrationFormFile"});
        return resultDataMap;
    }

    @Override
    public boolean beforeCheck(JgOverDesignServiceLife overDesignServiceLife) {
        return overDesignServiceLife.getInstanceId() != null && !overDesignServiceLife.getStatus().equals(FlowStatusEnum.TO_BE_FINISHED.getName()) && !overDesignServiceLife.getStatus().equals(FlowStatusEnum.TO_BE_DISCARD.getName());
    }

    @Override
    public void compensate(JgOverDesignServiceLife overDesignServiceLife) {
        commonService.saveExecuteFlowData2Redis(overDesignServiceLife.getInstanceId(), this.buildInstanceRuntimeData(overDesignServiceLife));
    }

    @Transactional(rollbackFor = Exception.class)
    public Boolean delete(Long sequenceNbr) {
        JgOverDesignServiceLife overDesignServiceLife = this.baseMapper.selectById(sequenceNbr);
        commonService.deleteTaskModel(String.valueOf(sequenceNbr), overDesignServiceLife.getInstanceId());
        this.baseMapper.deleteById(sequenceNbr);
        jgOverDesignServiceLifeEqService.remove(new LambdaQueryWrapper<JgOverDesignServiceLifeEq>()
                .eq(JgOverDesignServiceLifeEq::getOverDesignId, sequenceNbr));
        jgRegistrationHistoryService.remove(new LambdaQueryWrapper<JgRegistrationHistory>()
                .eq(JgRegistrationHistory::getCurrentDocumentId, sequenceNbr));
        return Boolean.TRUE;
    }

    @Transactional(rollbackFor = Exception.class)
    @GlobalTransactional(rollbackFor = Exception.class)
    public JgOverDesignServiceLife invalid(Long sequenceNbr, String cancelReason) {
        JgOverDesignServiceLife overDesignServiceLife = this.getById(sequenceNbr);
        String oldStatus = overDesignServiceLife.getStatus();
        overDesignServiceLife.setStatus(String.valueOf(FlowStatusEnum.TO_BE_DISCARD.getCode()));
        overDesignServiceLife.setCancelReason(cancelReason);
        overDesignServiceLife.setCancelDate(new Date());
        overDesignServiceLife.setCancelUserId(RequestContext.getExeUserId());
        overDesignServiceLife.setNextExecuteUserIds(null);
        overDesignServiceLife.setPromoter(null);
        this.updateById(overDesignServiceLife);
        // 2.更新关联的业务
        this.processElseDataByStatus(Objects.requireNonNull(FlowStatusEnum.getEumByCode(Integer.parseInt(oldStatus))), overDesignServiceLife);
        TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronization() {
            @Override
            public void afterCommit() {
                eventPublisher.publish(new CancellationEvent(this, getEquList(overDesignServiceLife)));
            }
        });
        return overDesignServiceLife;
    }

    private List<String> getEquList(JgOverDesignServiceLife overDesignServiceLife) {
        return jgOverDesignServiceLifeEqMapper.selectList(new LambdaQueryWrapper<JgOverDesignServiceLifeEq>()
                        .eq(JgOverDesignServiceLifeEq::getOverDesignId, overDesignServiceLife.getSequenceNbr()))
                .stream()
                .map(JgOverDesignServiceLifeEq::getEquId)
                .collect(toList());
    }

    private void processElseDataByStatus(FlowStatusEnum oldStatus, JgOverDesignServiceLife overDesignServiceLife) {
        switch (oldStatus) {
            case TO_BE_SUBMITTED:
                commonService.deleteTasksByRelationId(overDesignServiceLife.getSequenceNbr() + "");
                break;
            case TO_BE_FINISHED:
                this.delRepeatUseEquipData(overDesignServiceLife);
                this.recoverDesignInfoOfEquip(overDesignServiceLife);
                this.recoverUseRegistrationManage(overDesignServiceLife);
                break;
            default:
                this.finishedTask(overDesignServiceLife);
                cmWorkflowService.stopProcess(overDesignServiceLife.getInstanceId(), overDesignServiceLife.getCancelReason());
                this.delRepeatUseEquipData(overDesignServiceLife);
        }
    }

    private void recoverUseRegistrationManage(JgOverDesignServiceLife overDesignServiceLife) {
        List<String> useOrgCodes = jgOverDesignServiceLifeEqMapper.selectList(
                        new LambdaQueryWrapper<JgOverDesignServiceLifeEq>()
                                .eq(JgOverDesignServiceLifeEq::getOverDesignId, overDesignServiceLife.getSequenceNbr()))
                .stream()
                .map(JgOverDesignServiceLifeEq::getUseRegistrationCode)
                .collect(Collectors.toList());

        if (!useOrgCodes.isEmpty()) {
            List<JgUseRegistrationManage> registrationList = useRegistrationManageService.lambdaQuery()
                    .in(JgUseRegistrationManage::getUseRegistrationCode, useOrgCodes)
                    .eq(JgUseRegistrationManage::getIsDelete, 0)
                    .eq(JgUseRegistrationManage::getCertificateStatus, CertificateStatusEnum.YIDENGJI.getName())
                    .list();

            if (!registrationList.isEmpty()) {
                useRegistrationManageService.updateBatchById(
                        registrationList.stream().peek(v -> {
                            v.setIsOverDesign("0");
                            v.setVersion(v.getVersion() - 1);
                        }).collect(Collectors.toList())
                );
            }
        }
    }

    private void recoverDesignInfoOfEquip(JgOverDesignServiceLife overDesignServiceLife) {
        List<String> records = jgOverDesignServiceLifeEqMapper.selectList(
                        new LambdaQueryWrapper<JgOverDesignServiceLifeEq>()
                                .eq(JgOverDesignServiceLifeEq::getOverDesignId, overDesignServiceLife.getSequenceNbr()))
                .stream()
                .map(JgOverDesignServiceLifeEq::getEquId)
                .collect(Collectors.toList());
        List<IdxBizJgDesignInfo> designInfoList = idxBizJgDesignInfoServiceImpl.checkOverDesignRegNum(records);
        designInfoList.forEach(designInfo -> {
            designInfo.setOverDesignRegNum(Math.max(designInfo.getOverDesignRegNum() - 1, 0));
            designInfo.setDelayServiceLifeDate("");
            jgResumeInfoService.deleteByBusinessId(String.valueOf(overDesignServiceLife.getSequenceNbr()));
        });
    }

    private void finishedTask(JgOverDesignServiceLife overDesignServiceLife) {
        HashMap<String, Object> taskMap = new HashMap<>();
        taskMap.put("taskStatus", FlowStatusEnum.TO_BE_FINISHED.getCode());
        taskMap.put("taskStatusLabel", FlowStatusEnum.TO_BE_FINISHED.getName());
        taskMap.put("flowStatus", FlowStatusEnum.TO_BE_FINISHED.getCode());
        taskMap.put("flowStatusLabel", FlowStatusEnum.TO_BE_FINISHED.getName());
        taskMap.put("relationId", overDesignServiceLife.getInstanceId());
        TaskMessageDto taskMessageDto = new TaskMessageDto();
        overDesignServiceLife.setOtherAccessories(null);
        BeanUtils.copyProperties(overDesignServiceLife, taskMessageDto);
        this.setEquListForWorkSpace(overDesignServiceLife, taskMessageDto);
        taskMap.put("model", taskMessageDto);
        commonService.updateTaskModel(taskMap);
    }

    public Map<String, Object> getNewWTJYInspectionDetailByRecord(String record, String equListCode) {
        JgOverDesignServiceLifeEq overDesignServiceLifeEq = jgOverDesignServiceLifeEqMapper.selectOne(
                new LambdaQueryWrapper<JgOverDesignServiceLifeEq>()
                        .eq(JgOverDesignServiceLifeEq::getEquId, record)
                        .orderByDesc(JgOverDesignServiceLifeEq::getRecDate)
                        .last("LIMIT 1"));

        return iIdxBizJgInspectionDetectionInfoService.queryInspectionListByRecord(record).stream()
                .filter(v -> "6000".equals(equListCode) || "WTJY".equals(v.getInspectType()))
                .findFirst()
                .map(info -> {
                    Map<String, Object> result = new HashMap<>(Bean.BeantoMap(info));
                    result.put("inspectReport", JSON.parseArray(info.getInspectReport()));
                    result.put("inspectConclusionCode", info.getInspectConclusion());
                    result.put("inspectConclusion",
                            Optional.ofNullable(dataDictionaryServiceImpl.getByCode(info.getInspectConclusion(), "JYJL"))
                                    .map(DataDictionary::getName)
                                    .orElse(""));
                    result.put("jySeq", info.getSequenceNbr());
                    if (overDesignServiceLifeEq != null) {
                        result.put("safetyAssessmentName", overDesignServiceLifeEq.getSafetyAssessmentName());
                        result.put("safetyAssessmentCreditCode", overDesignServiceLifeEq.getSafetyAssessmentCreditCode());
                        result.put("safetyAssessmentReport", overDesignServiceLifeEq.getSafetyAssessmentReport());
                        result.put("safetyAssessmentResult", overDesignServiceLifeEq.getSafetyAssessmentResult());
                        result.put("safetyAssessmentDate", overDesignServiceLifeEq.getSafetyAssessmentDate());
                    }
                    commonService.convertStringToJsonobject(result, new String[]{"safetyAssessmentReport"});
                    return result;
                })
                .orElse(Collections.emptyMap());
    }
}