package com.yeejoin.amos.boot.module.jyjc.biz.feign;

import com.yeejoin.amos.boot.module.jyjc.biz.config.XidFeignConfiguration;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.systemctl.model.TaskV2Model;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * @author LiuLin
 * @apiNote 待办Feign调用
 * @date 2024-05-16
 */
@FeignClient(name = "AMOS-API-PRIVILEGE", path = "/systemctl/v2/task", configuration = {XidFeignConfiguration.class})
public interface TaskV2FeignService {

    /**
     * 批量新增任务
     *
     * @param modelList 新增待办
     * @return TaskV2Model
     * @throws InnerInvokException e
     */
    @RequestMapping(value = "/batch/add", method = RequestMethod.POST)
    FeignClientResult<List<TaskV2Model>> batchAdd(@RequestBody List<TaskV2Model> modelList) throws InnerInvokException;

    /**
     * 更新任务
     *
     * @param model       待办信息
     * @param sequenceNbr 主键
     * @return TaskV2Model
     * @throws InnerInvokException e
     */
    @RequestMapping(value = "/{sequenceNbr}", method = RequestMethod.PUT)
    FeignClientResult<TaskV2Model> update(@RequestBody TaskV2Model model, @PathVariable("sequenceNbr") Long sequenceNbr) throws InnerInvokException;

    /**
     * 创建任务
     *
     * @param model 待办
     * @return
     * @throws InnerInvokException
     */
    @RequestMapping(value = "", method = RequestMethod.POST)
    FeignClientResult<TaskV2Model> create(@RequestBody TaskV2Model model) throws InnerInvokException;

    /**
     * 批量删除任务
     *
     * @param ids 主键
     * @return Long
     * @throws InnerInvokException e
     */
    @RequestMapping(value = "/{ids}", method = RequestMethod.DELETE)
    FeignClientResult<List<Long>> delete(@PathVariable("ids") String ids) throws InnerInvokException;

    /**
     * 查询指定任务
     *
     * @param relationId 关联Id
     * @return List<TaskV2Model>
     * @throws InnerInvokException
     */
    @RequestMapping(value = "/queryByRelationId/{relationId}", method = RequestMethod.GET)
    FeignClientResult<List<TaskV2Model>> selectListByRelationId(@PathVariable("relationId") String relationId) throws InnerInvokException;

    /**
     * 批量修改任务
     */
    @RequestMapping(value = "/batch/update", method = RequestMethod.PUT)
    FeignClientResult<List<TaskV2Model>> batchUpdate(@RequestBody List<TaskV2Model> modelList) throws InnerInvokException;
}
