package com.yeejoin.equipmanage.controller;

import java.util.ArrayList;
import java.util.List;

import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import com.yeejoin.equipmanage.common.entity.vo.MainIotMonitorVo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * @Description: 物联监控首页面统计预览
 * @Author: Wanglulu
 * @Date: 2020/12/22 20:12
 * @Version 0.0.1
 */
@RestController
@Api(tags = "物联监控首页面")
@RequestMapping(value = "/iot/monitor", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class MainIotMonitorController extends AbstractBaseController {

    @GetMapping(value = "matrix")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "矩阵统计", notes = "接口已不再使用")
    public List<MainIotMonitorVo> getMatrixReport() {
        //return mainIotMonitorSerivce.getMatrixReport();
        return new ArrayList<>();
    }

}
