package com.yeejoin.precontrol.common.listener.event.listener;

import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import com.yeejoin.precontrol.common.listener.event.TranslateEvent;
import com.yeejoin.precontrol.common.service.IBaseService;
import com.yeejoin.precontrol.common.utils.RedisUtil;
import com.yeejoin.precontrol.common.utils.TranslateUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

/**
 * @description: 翻译服务专用监听器
 * @author: duanwei
 * @date: 2020-08-05 15:20
 **/
@Component
@Slf4j
public class TranslateEventListener implements ApplicationListener<TranslateEvent> {

    @Autowired
    IBaseService iBaseService;

    @Autowired
    RedisUtil redisUtil;

    @Override
    public void onApplicationEvent(TranslateEvent translateEvent) {
        Object obj = translateEvent.getObjMsg();
        log.info("接收到缓存翻译服务更新消息,更新redis表 数据:{}", obj.toString());
        TranslateUtil.setDictionary((BaseEntity) obj, "name", redisUtil);
    }
}
