package com.yeejoin.amos.boot.module.elevator.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.annotation.ResubmitCheck;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.excel.ExcelUtil;
import com.yeejoin.amos.boot.biz.common.feign.AmosFeignService;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.common.api.feign.EquipFeignClient;
import com.yeejoin.amos.boot.module.elevator.api.common.BizCommonConstant;
import com.yeejoin.amos.boot.module.elevator.api.dto.*;
import com.yeejoin.amos.boot.module.elevator.api.entity.Elevator;
import com.yeejoin.amos.boot.module.elevator.api.entity.MaintainInfo;
import com.yeejoin.amos.boot.module.elevator.api.entity.TestInfo;
import com.yeejoin.amos.boot.module.elevator.api.mapper.ElevatorMapper;
import com.yeejoin.amos.boot.module.elevator.api.service.IElevatorRelationService;
import com.yeejoin.amos.boot.module.elevator.api.service.IElevatorService;
import com.yeejoin.amos.boot.module.elevator.biz.service.impl.ESElevatorServiceImpl;
import com.yeejoin.amos.boot.module.elevator.biz.service.impl.ElevatorServiceImpl;
import com.yeejoin.amos.boot.module.elevator.biz.service.impl.MaintainInfoServiceImpl;
import com.yeejoin.amos.boot.module.elevator.biz.service.impl.TestInfoServiceImpl;
import com.yeejoin.amos.boot.module.elevator.biz.utils.BeanDtoVoUtils;
import com.yeejoin.amos.boot.module.elevator.biz.utils.RedisUtil;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import com.yeejoin.amos.feign.systemctl.model.RegionModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 电梯Api
 *
 * @author tb
 * @date 2021-06-01
 */
@RestController
@Api(tags = "电梯Api")
@RequestMapping(value = "/elevator")
public class ElevatorController extends BaseController {

    private final Logger logger = LoggerFactory.getLogger(ElevatorController.class);

    @Autowired
    IElevatorService iElevatorService;

    @Autowired
    ElevatorServiceImpl elevatorService;

    @Autowired
    private AmosFeignService amosFeignService;

    @Autowired
    private MaintainInfoServiceImpl maintainInfoService;
	 @Autowired
	private EquipFeignClient equipFeignClient;
    @Autowired
    private TestInfoServiceImpl testInfoService;

    @Autowired
    ESElevatorServiceImpl esElevatorService;

    @Autowired
    private EmqKeeper emqKeeper;

    @Value("${mqtt.topic.elevator.push}")
    private String elevatorpushTopic;

    @Autowired
    private IElevatorRelationService elevatorRelationService;

    @Autowired
    private ElevatorMapper elevatorMapper;

    @Autowired
    DataDictionaryServiceImpl iDataDictionaryService;

    @Autowired
    private RedisUtil redisUtil;

    private static final String STREET = "STREET";
    /**
     * 新增电梯
     *
     * @param elevatorDto 新增参数
     * @return 返回结果
     */
    @ResubmitCheck
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增电梯", notes = "新增电梯")
    public ResponseModel<com.yeejoin.amos.boot.module.elevator.api.dto.ElevatorDto> saveElevator(@RequestBody com.yeejoin.amos.boot.module.elevator.api.dto.ElevatorDto elevatorDto) {
        return ResponseHelper.buildResponse(elevatorService.saveElevator(elevatorDto));
    }

    /**
     * 根据id批量删除
     *
     * @param idList id
     * @return 返回结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/delete", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public ResponseModel<Boolean> deleteById(@RequestParam String idList) {
        return ResponseHelper.buildResponse(elevatorService.deleteBatchBySeq(idList));
    }

    /**
     * 修改电梯
     *
     * @param elevatorDto 修改参数
     * @return 返回结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改电梯", notes = "修改电梯")
    public ResponseModel<com.yeejoin.amos.boot.module.elevator.api.dto.ElevatorDto> updateByIdElevator(@RequestBody com.yeejoin.amos.boot.module.elevator.api.dto.ElevatorDto elevatorDto) {
        return ResponseHelper.buildResponse(elevatorService.updateElevator(elevatorDto));
    }


    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr sequenceNbr
     * @return 返回结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{sequenceNbr}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public ResponseModel<com.yeejoin.amos.boot.module.elevator.api.dto.ElevatorDto> selectById(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(elevatorService.selectBySeq(sequenceNbr));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/ocp/{sequenceNbr}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public ResponseModel<Map<String, Object>> selectByRecord(@PathVariable String sequenceNbr) {
        return ResponseHelper.buildResponse(elevatorService.selectByRecord(sequenceNbr));
    }


    /**
     * 列表分页查询
     *
     * @param pageNum     当前页
     * @param pageSize    每页大小
     * @param elevatorDto 查询参数
     * @return 返回结果
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public ResponseModel<IPage<ElevatorDto>> listPage(String pageNum, String pageSize, com.yeejoin.amos.boot.module.elevator.api.dto.ElevatorDto elevatorDto) {
        Elevator elevator = BeanDtoVoUtils.convert(elevatorDto, Elevator.class);
        Page<Elevator> pageBean;
        QueryWrapper<Elevator> elevatorQueryWrapper = new QueryWrapper<>();
        Class<? extends Elevator> aClass = elevator.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(elevator);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) o;
                        elevatorQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) o;
                        elevatorQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) o;
                        elevatorQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) o;
                        elevatorQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
                logger.error(e.getMessage());
            }
        });
        IPage<Elevator> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iElevatorService.page(pageBean, elevatorQueryWrapper);
        IPage<ElevatorDto> elevatorVoIPage = BeanDtoVoUtils.elevatorIPageDto(page);
        return ResponseHelper.buildResponse(elevatorVoIPage);
    }


    /**
     * 相似电梯模糊查询
     *
     * @param elevatorNewDto 查询参数
     * @return 返回结果
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/page/similar", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "相似电梯模糊查询", notes = "相似电梯模糊查询")
    public ResponseModel<List<Map<String,Object>>> similar(@RequestBody ElevatorNewDto elevatorNewDto) {
        Elevator elevator = BeanDtoVoUtils.convert(elevatorNewDto.getElevatorDto(), Elevator.class);
//        QueryWrapper<Elevator> elevatorQueryWrapper = new QueryWrapper<>();
//        Class<? extends Elevator> aClass = elevator.getClass();
//        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
//            try {
//                field.setAccessible(true);
//                Object o = field.get(elevator);
//                if (o != null) {
//                    String name = NameUtils.camel2Underline(field.getName());
//                    if ("rescue_code".equalsIgnoreCase(name)) {
//                        Integer fileValue = (Integer) o;
//                        elevatorQueryWrapper.like(name, fileValue);
//                    } else if ("city".equalsIgnoreCase(name) || "district".equalsIgnoreCase(name)) {
//                        String fileValue = (String) o;
//                        elevatorQueryWrapper.eq(name, fileValue);
//                    } else {
//                        String fileValue = (String) o;
//                        elevatorQueryWrapper.like(name, fileValue);
//                    }
//                }
//            } catch (Exception e) {
//                logger.error(e.getMessage());
//            }
//        });
//       List<Elevator> elevators =  iElevatorService.list(elevatorQueryWrapper);
        List<Map<String,Object>> maps =  iElevatorService.selectElevatorList(elevator);
//       List<ElevatorDto> elevatorDtoList = new ArrayList<>();
//        for (Elevator ele : elevators ) {
//            ElevatorDto eleDto = new ElevatorDto();
//            BeanUtils.copyProperties(ele,eleDto);
//            if(!ValidationUtil.isEmpty(eleDto.getUseSiteCategory())) {
//                LambdaQueryWrapper<DataDictionary> wrapper = new LambdaQueryWrapper<>();
//                wrapper.eq(DataDictionary::getCode, eleDto.getUseSiteCategory());
//                DataDictionary dataDictionary = iDataDictionaryService.getOne(wrapper);
//                if (!ValidationUtil.isEmpty(dataDictionary)) {
//                    eleDto.setUseSiteCategory(dataDictionary.getName());
//                }
//            }
//            elevatorDtoList.add(eleDto);
//        }

        List<LinkedHashMap<String, Object>> streetList;
        if (redisUtil.hasKey(STREET)) {
            streetList = (List<LinkedHashMap<String, Object>>) redisUtil.get(STREET);
        } else {
            streetList = null;
        }
        maps.forEach(map->{
            if (!ObjectUtils.isEmpty(map.get("street")) && !ObjectUtils.isEmpty(streetList)) {
                List<LinkedHashMap<String, Object>> collect = streetList.stream().filter(item -> item.get("regionCode").toString().equals(map.get("street").toString())).collect(Collectors.toList());
                if (!ObjectUtils.isEmpty(collect)) {
                    map.put("street", collect.get(0).get("regionName"));
                }

            }
        });
        return ResponseHelper.buildResponse(maps);
    }

    /**
     * 分页查询电梯信息
     *
     * @param pageNum     当前页
     * @param pageSize    每页大小
     * @param elevatorDto 查询参数
     * @return 查询结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/query_elevator_list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "分页查询电梯信息", notes = "分页查询电梯信息")
    public ResponseModel<IPage<ElevatorDto>> queryElevatorList(String pageNum, String pageSize,com.yeejoin.amos.boot.module.elevator.api.dto.ElevatorDto elevatorDto) {
        Elevator elevator = BeanDtoVoUtils.convert(elevatorDto, Elevator.class);
        Page<Elevator> pageBean;
        QueryWrapper<Elevator> elevatorQueryWrapper = new QueryWrapper<>();
        Class<? extends Elevator> aClass = elevator.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(elevator);
                if (o != null) {
                    String name = NameUtils.camel2Underline(field.getName());
                    if ("rescue_code".equalsIgnoreCase(name)) {
                        Integer fileValue = (Integer) o;
                        elevatorQueryWrapper.like(name, fileValue);
                    } else if ("city".equalsIgnoreCase(name) || "district".equalsIgnoreCase(name)) {
                        String fileValue = (String) o;
                        elevatorQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) o;
                        elevatorQueryWrapper.like(name, fileValue);
                    }
                }
            } catch (Exception e) {
                logger.error(e.getMessage());
            }
        });
        IPage<Elevator> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iElevatorService.page(pageBean, elevatorQueryWrapper);
        IPage<ElevatorDto> elevatorDtoIPage = BeanDtoVoUtils.elevatorIPageDto(page);
        return ResponseHelper.buildResponse(elevatorDtoIPage);
    }


//    @TycloudOperation(ApiLevel = UserType.AGENCY)
//    @RequestMapping(value = "/ocp/query_elevator_list", method = RequestMethod.GET)
//    @ApiOperation(httpMethod = "GET", value = "分页查询电梯信息（数据源切换）", notes = "分页查询电梯信息（数据源切换）")
//    public ResponseModel<Page<Map<String, Object>>> selectElevatorList(Long pageNum, Long pageSize,ElevatorDto dto) {
//        Page<Map<String, Object>> mapPage = new Page<>(pageNum, pageSize);
//        Page<Map<String, Object>> list = iElevatorService.selectElevators(mapPage, dto);
//        return ResponseHelper.buildResponse(list);
//    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/ocp/query_elevator_list")
    @ApiOperation(httpMethod = "GET", value = "电梯列表", notes = "电梯列表")
    public ResponseModel<Page<JSONObject>> viewJgAll( @RequestParam Map<String,Object> map) {
        JSONObject jsonObject = new JSONObject(map);
        return ResponseHelper.buildResponse(iElevatorService.queryByKeys(jsonObject));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/ocp/exportData")
    @ApiOperation(httpMethod = "GET", value = "设备信息导出", notes = "设备信息导出")
    public void exportData(HttpServletResponse response, ElevatorDto dto) {
        List<ElevatorDtoNew> equipExportData = iElevatorService.selectExportDataNew(dto);
        ExcelUtil.createTemplate(response, "设备信息", "设备信息", equipExportData, ElevatorDtoNew.class, null, false);
    }

    /**
     * 获取电梯使用单位
     * @return
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/usesiteCategory", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取电梯使用单位", notes = "获取电梯使用单位")
    public ResponseModel<List<DictionarieValueModel>> selectUsesiteCategory() {
        List<DictionarieValueModel>  elevatorUseSiteCategory = null;
        try {
            elevatorUseSiteCategory = amosFeignService.listDictionaryByDictCode("ELEVATOR_USE_SITE_CATEGORY");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResponseHelper.buildResponse(elevatorUseSiteCategory);
    }

    /**
     * 根据电梯id或电梯救援识别码获取电梯信息
     * @return
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/getElevatorInfo", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据电梯id或电梯救援识别码获取电梯信息", notes = "根据电梯id或电梯救援识别码获取电梯信息")
    public ResponseModel<ElevatorInfoDto> getElevatorInfo(Long sequenceNbr,String rescueCode, String openId) {

        if(StringUtils.isBlank(rescueCode) && sequenceNbr == null && StringUtils.isBlank(openId)) {
            throw new BadRequest("参数错误");
        }
        Elevator elevator;
        ElevatorInfoDto elevatorInfoDto = new ElevatorInfoDto();
        if(null != sequenceNbr) {
            ElevatorBaseInfoDto baseInfoDto = new ElevatorBaseInfoDto();
            elevator = elevatorService.getById(sequenceNbr);
            Bean.toPo(elevator,baseInfoDto);
            elevatorInfoDto.setElevatorBaseInfoDto(baseInfoDto);
        } else  {
            QueryWrapper<Elevator> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("rescue_code",rescueCode);
            elevator = elevatorService.getOne(queryWrapper);
            if(null == elevator) {
                throw new BadRequest("电梯应急救援码错误");
            }
            ElevatorBaseInfoDto baseInfoDto = new ElevatorBaseInfoDto();
            Bean.toPo(elevator,baseInfoDto);
            elevatorInfoDto.setElevatorBaseInfoDto(baseInfoDto);
        }

        QueryWrapper<MaintainInfo> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("enevator_id", null == sequenceNbr ? elevator.getSequenceNbr() : String.valueOf(sequenceNbr));
        MaintainInfo maintainInfo =   maintainInfoService.getOne(queryWrapper);
        if(null != maintainInfo) {
            ElevatorMaintenanceInfoDto elevatorMaintenanceInfoDto = new ElevatorMaintenanceInfoDto();
            Bean.toPo(maintainInfo,elevatorMaintenanceInfoDto);
            elevatorInfoDto.setElevatorMaintenanceInfoDto(elevatorMaintenanceInfoDto);
        }

        QueryWrapper<TestInfo> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.eq("enevator_id", null == sequenceNbr ? elevator.getSequenceNbr() : String.valueOf(sequenceNbr));
        TestInfo testInfo =   testInfoService.getOne(queryWrapper1);
        if(null != testInfo) {
            ElevatorTestInfoDto elevatorTestInfoDto = new ElevatorTestInfoDto();
            Bean.toPo(testInfo,elevatorTestInfoDto);
            elevatorInfoDto.setElevatorTestInfoDto(elevatorTestInfoDto);
        }
        if(elevator != null) {
            elevatorInfoDto.setHasFocus(elevatorRelationService.hasFocusElevator(openId, elevator.getSequenceNbr()));
        }

        return ResponseHelper.buildResponse(elevatorInfoDto);
    }

    /**
               * 视频列表分页查询
     *
     * @return
     */

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/getVideo", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "分页获取视频", notes = "分页获取视频")
    public ResponseModel<Object> getVideo(Integer current, Integer size)throws Exception {
      ResponseModel<Page<Map<String, Object>>> data=  equipFeignClient.pageVideo(current,size,null,null,null);
      return ResponseHelper.buildResponse(data!=null?data.getResult():null);
    }

    /**
     *
     * @return
     */
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/init", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "电梯信息放入es", notes = "电梯信息放入es")
    public ResponseModel<String> init(@RequestParam(value = "num",required = false) Integer num) {
        Integer count = iElevatorService.selectUseInfoCount();
        Integer times = 0;
        if (ValidationUtil.isEmpty(num) && count != 0) {
            times = count / 1000;
            int last = count % 1000;
            if (last > 0) {
                times++;
            }
        } else if (count != 0) {
            times = num;
        }

        for(int i = 0; i <= times ;  i ++  ) {
            List<Map<String,Object>> mapList = iElevatorService.selectElevatorEsList(0,1000);
            if (!ObjectUtils.isEmpty(mapList)){
                esElevatorService.saveEsElevator2ES(mapList);
            }
//            for (Elevator el:elevatorPage.getRecords()
//                 ) {
//                esElevatorService.saveEsElevatorToES(el);
//            }
        }
        return ResponseHelper.buildResponse("success");
    }


    /**
     * ES查询电梯信息
     *
     * @param elevatorDto 查询参数
     * @return 查询结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/query_elevator_list_es", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "ES查询电梯信息", notes = "ES查询电梯信息")
    public ResponseModel<List<EsElevatorDto>> queryElevatorListEs(
            @RequestBody EsElevatorDto elevatorDto){
        List<EsElevatorDto>  page = esElevatorService.queryByKeys(elevatorDto);
        return ResponseHelper.buildResponse(page);
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr sequenceNbr
     * @return 返回结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/pushInfo/{sequenceNbr}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据电梯id 给主屏推送电梯信息", notes = "根据电梯id 给主屏推送电梯信息")
    public ResponseModel<Boolean> pushElevatorInfo(@PathVariable Long sequenceNbr) {

        ElevatorDto elevator = elevatorService.selectBySeq(sequenceNbr);
        AgencyUserModel user =getUserInfo();
        // 推送经纬度 人员姓名 电话 警情id
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("userId",user.getUserId());
        jsonObject.put("elevatorId",elevator.getSequenceNbr());
        jsonObject.put("rescueCode",elevator.getRescueCode());
        jsonObject.put("registerCode",elevator.getRegisterCode());
        jsonObject.put("address",elevator.getAddress());
        jsonObject.put("useUnit",elevator.getUseUnit());
        jsonObject.put("useStatus",elevator.getUseStatus());
        jsonObject.put("useSiteCategory",elevator.getUseSiteCategory());
        jsonObject.put("city",elevator.getCity());
        jsonObject.put("district",elevator.getDistrict());
        try {
            emqKeeper.getMqttClient().publish(elevatorpushTopic, jsonObject.toString().getBytes("UTF-8"), 1, false);
        } catch (MqttException e) {
            logger.error("mqtt发送失败" +jsonObject );
        } catch (UnsupportedEncodingException e) {
            logger.error("mqtt发送失败" +jsonObject );
        }
        return ResponseHelper.buildResponse(true);
    }



    /**
     * 查询电梯物联信息
     *
     * @param elevatorDto 查询参数
     * @return 查询结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/query_elevator_list_wl", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "查询电梯信息", notes = "查询电梯信息")
    public ResponseModel<IPage<ElevatorWlInfoDto>> queryElevatorList(
            ElevatorWlInfoDto elevatorDto){
        IPage<ElevatorWlInfoDto> iPage = new Page<>();
        iPage.setCurrent((elevatorDto.getPage()-1)*elevatorDto.getSize());
        iPage.setSize(elevatorDto.getSize());
        iPage.setRecords( elevatorService.queryElevatorList(elevatorDto));
        iPage.setTotal(elevatorService.queryElevatorListCount());
        return ResponseHelper.buildResponse(iPage);
    }

    /**
     * 查询电梯物联信息详情
     *
     * @param elevatorDto 查询参数
     * @return 查询结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/query_elevator_list_wl_details", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "查询电梯信息", notes = "查询电梯信息")
    public ResponseModel<ElevatorWlInfoDto> queryElevato(
            @RequestBody ElevatorWlInfoDto elevatorDto){
        if(null == elevatorDto.getSequenceNbr()) {
            throw new BadRequest("参数错误");
        }
        List<ElevatorWlInfoDto>  page = elevatorService.queryElevatorListDetails(elevatorDto);
        if(page.size()>0) {
            return ResponseHelper.buildResponse(page.get(0));
        }
        return ResponseHelper.buildResponse(null);
    }

    /**
     * 关注电梯
     * @param elevatorId
     * @param openId
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/focusElevator/{elevatorId}/{openId}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "关注电梯", notes = "关注电梯")
    public ResponseModel<Boolean> focusElevator(@PathVariable String elevatorId, @PathVariable String openId){
        return ResponseHelper.buildResponse(elevatorRelationService.focusElevator(openId,elevatorId));
    }

    /**
     * 取消关注电梯
     * @param elevatorId
     * @param openId
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/cancelFocusElevator/{elevatorId}/{openId}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "取消关注电梯", notes = "取消关注电梯")
    public ResponseModel<Boolean> cancelFocusElevator(@PathVariable String elevatorId, @PathVariable String openId){
        return ResponseHelper.buildResponse(elevatorRelationService.cancelFocusElevator(openId,elevatorId));
    }

    /**
     * 获取关注电梯列表
     * @param openId
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/getMyFocusElevator/{openId}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取关注电梯列表", notes = "获取关注电梯列表")
    public ResponseModel<List<ElevatorListDto>> cancelFocusElevator(@PathVariable String openId){
        return ResponseHelper.buildResponse(elevatorRelationService.getMyFocusElevator(openId));
    }
    /**获取电梯的安装地址*/
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/getAddressList",method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "获取电梯的安装地址", notes = "获取电梯的安装地址")
    public ResponseModel<List<ElevatorMessageDto>> getAddressList(@RequestBody ElevatorListDto elevatorListDto){
//        List<ElevatorDto> elevatorList = elevatorMapper.getAddressList(elevatorListDto.getElevatorAddress());
//        for(ElevatorDto elevatorDto : elevatorList){
//            if(!ValidationUtil.isEmpty(elevatorDto.getUseSiteCategory())) {
//                LambdaQueryWrapper<DataDictionary> wrapper = new LambdaQueryWrapper<>();
//                wrapper.eq(DataDictionary::getCode, elevatorDto.getUseSiteCategory());
//                DataDictionary dataDictionary = iDataDictionaryService.getOne(wrapper);
//                if (!ValidationUtil.isEmpty(dataDictionary)) {
//                    elevatorDto.setUseSiteCategory(dataDictionary.getName());
//                }
//            }
//        }
        List<LinkedHashMap<String, Object>> list = null;
        if (redisUtil.hasKey(STREET)) {
            list = (List<LinkedHashMap<String, Object>>) redisUtil.get(STREET);
        }
        List<ElevatorMessageDto> addressListNew = elevatorMapper.getAddressListNew(elevatorListDto.getElevatorAddress());
        if (!ObjectUtils.isEmpty(addressListNew) && !ObjectUtils.isEmpty(list)) {
            List<LinkedHashMap<String, Object>> finalList = list;
            addressListNew.forEach(item -> {
                if (!ObjectUtils.isEmpty(item.getStreet())) {
                    List<LinkedHashMap<String, Object>> streetList = finalList.stream().filter(street -> street.get("regionCode").toString().equals(item.getStreet())).collect(Collectors.toList());
                    if (!ObjectUtils.isEmpty(streetList) && !ObjectUtils.isEmpty(streetList.get(0))) {
                        item.setStreet(String.valueOf(streetList.get(0).get("regionName")));
                    }
                }
            });
        }
        return ResponseHelper.buildResponse(addressListNew);
    }

}

