package com.yeejoin.amos.boot.module.cylinder.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * <pre>
 * 气瓶字典枚举
 * </pre>
 *
 * @author gwb
 * @version $Id: LiftStatusEnum.java, v 0.1 2021年9月29日 上午9:32:16 gwb Exp $
 */
public enum CylDictEnum {

	isValid_0(3125,0,"isValid"),
	isValid_1(3126,1,"isValid"),
	same_0(3127,0,"same"),
	same_1(3128,1,"same"),
	SecurityDocuments_0(3137,0,"SecurityDocuments"),
	SecurityDocuments_1(3138,1,"SecurityDocuments"),
	isComplete_0(3135,0,"isComplete"),
	isComplete_1(3136,1,"isComplete"),
	haveStillPressure_0(3133,0,"haveStillPressure"),
	haveStillPressure_1(3134,1,"haveStillPressure"),
	isComplianceWithGBT_0(3131,0,"isComplianceWithGBT"),
	isComplianceWithGBT_1(3132,1,"isComplianceWithGBT"),
	isRegulations_0(3129,0,"isRegulations"),
	isRegulations_1(3130,1,"isRegulations"),
	withinScope_0 (3141,0, "withinScope"),
	withinScope_1 (3142,1, "withinScope"),
	sealedState_0 (3143,0, "sealedState"),
	sealedState_1 (3144,1, "sealedState"),
	defective_0 (3145,0, "defective"),
	defective_1 (3146,1, "defective"),
	abnormaLTemperature_0 (3147,0, "abnormaLTemperature"),
	abnormaLTemperature_1 (3148,1, "abnormaLTemperature"),
	warningSign_0 (3149,0, "warningSign"),
	warningSign_1 (3150,1, "warningSign"),
	cylinder_Status_0 (3114,0, "cylinder_Status"),
	cylinder_Status_1 (3115,1, "cylinder_Status"),
	cylinder_Status_2 (3116,2, "cylinder_Status"),
	cylinder_Status_3 (3117,3, "cylinder_Status"),
	cylinder_Variety_1 (3145,1, "cylinder_Variety"),
	cylinder_Variety_2 (3146,2, "cylinder_Variety"),
	cylinder_Variety_3 (3147,3, "cylinder_Variety"),
	cylinder_Variety_4 (3148,4, "cylinder_Variety"),
	cylinder_Variety_5 (3149,5, "cylinder_Variety");

	/**
	 * 主键
	 */
	private Integer seqNbr;

	/**
	 * 编码
	 */
	private Integer code;

	/**
	 * key
	 */
	private String key;

	// 构造方法
	CylDictEnum(Integer seqNbr, Integer code, String key) {
		this.seqNbr = seqNbr;
		this.code = code;
		this.key = key;
	}

	public Integer getSeqNbr() {
		return seqNbr;
	}

	public Integer getCode()
	{
		return code;
	}

	public String getKey()
	{
		return key;
	}
	
	public static CylDictEnum getEnum(Integer code, String key)
	{
		for (CylDictEnum cylDictEnum : CylDictEnum.values())
		{
			if (cylDictEnum.getCode().equals(code) && cylDictEnum.getKey().equals(key))
			{
				return cylDictEnum;
			}
		}
		return null;
	}
}
