package com.yeejoin.amos.avic.face.webservice;

import javax.activation.DataHandler;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlMimeType;

import com.yeejoin.amos.avic.face.model.AvicCustomPathModel;


@WebService(targetNamespace = "http://service.avic.amos.yeejoin.com")
public interface FileFransferService {
	
	/**
	 * 利用中航码传输文件
	 * @param handler
	 * @param fileName
	 * @param path
	 */
	@WebMethod
	public void useCodetransferFile(
			@WebParam(name = "dataHandler")
			@XmlMimeType(value = "application/octet-stream") DataHandler handler, 
			@WebParam(name = "fileName") String fileName, 
			@WebParam(name = "path") String path, 
			@WebParam(name = "code") String code);
	/**
	 * 传输文件
	 * @param handler
	 * @param fileName
	 * @param path
	 */
	@WebMethod
	public void transferFile(
			@WebParam(name = "dataHandler")
			@XmlMimeType(value = "application/octet-stream") DataHandler handler, 
			@WebParam(name = "fileName") String fileName, 
			@WebParam(name = "path") String path);
	
	/**
	 * 传输目录配置
	 * @param name
	 * @param path
	 * @param desc
	 */
	@WebMethod
	public void transferPathConfig(@WebParam(name="model") AvicCustomPathModel model);
}
