package com.yeejoin.amos.boot.module.common.biz.controller;

import java.util.*;

import javax.servlet.http.HttpServletRequest;

import com.yeejoin.amos.boot.biz.common.controller.DataDictionaryController;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.biz.common.utils.Menu;
import com.yeejoin.amos.boot.biz.common.utils.TreeParser;
import com.yeejoin.amos.boot.module.common.api.mapper.OrgUsrMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.constants.CommonConstant;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.interceptors.PermissionInterceptorContext;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.common.api.core.framework.PersonIdentify;
import com.yeejoin.amos.boot.module.common.api.dto.CheckObjectDto;
import com.yeejoin.amos.boot.module.common.api.dto.CompanyPerson;
import com.yeejoin.amos.boot.module.common.api.dto.ESOrgUsrDto;
import com.yeejoin.amos.boot.module.common.api.dto.OrgDepartmentDto;
import com.yeejoin.amos.boot.module.common.api.dto.OrgMenuDto;
import com.yeejoin.amos.boot.module.common.api.dto.OrgUsrDto;
import com.yeejoin.amos.boot.module.common.api.dto.OrgUsrFormDto;
import com.yeejoin.amos.boot.module.common.api.dto.UserDto;
import com.yeejoin.amos.boot.module.common.api.dto.UserUnitDto;
import com.yeejoin.amos.boot.module.common.api.entity.FireTeam;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.common.api.feign.EquipFeignClient;
import com.yeejoin.amos.boot.module.common.api.mapper.FireTeamMapper;
import com.yeejoin.amos.boot.module.common.api.service.IOrgUsrService;
import com.yeejoin.amos.boot.module.common.biz.service.impl.ESOrgUsrService;
import com.yeejoin.amos.boot.module.common.biz.service.impl.OrgUsrServiceImpl;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 部门信息修改
 *
 * @author tb
 * @date 2021-06-18
 */
@RestController
@Api(tags = "单位Api")
@RequestMapping(value = "/org-usr")
public class OrgUsrController extends BaseController {

	@Autowired
	DataDictionaryServiceImpl iDataDictionaryService;

	@Autowired
	OrgUsrServiceImpl iOrgUsrService;

	@Autowired
	private IOrgUsrService orgUsrService;

	@Autowired
	ESOrgUsrService eSOrgUsrService;

	@Autowired
	FireTeamMapper fireTeamMapper;

	@Autowired
	OrgUsrMapper orgUsrMapper;

	@Autowired
	EmqKeeper emqKeeper;
	@Value("${jcs.company.topic.delete:jcs/company/topic/delete}")
	private String airportDeleteTopic;

	@Autowired
	EquipFeignClient equipFeignClient;

	@Autowired
	DataDictionaryController dataDictionaryController;
	@Value("special-dept")
	String deptKey;
	@Value("special-deptType")
	String deptTypeKey;
	/**
	 * 新增单位信息
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "新增单位信息", notes = "新增单位信息")
	public ResponseModel<Object> saveOrgUsr(HttpServletRequest request, @RequestBody OrgUsrDto OrgUsrVo)
			throws Exception {
		OrgUsrVo.setBizOrgType(CommonConstant.BIZ_ORG_TYPE_COMPANY);

		return ResponseHelper.buildResponse(iOrgUsrService.saveOrgUsr(OrgUsrVo));
	}

	/**
	 * 根据id删除
	 *
	 * @param id
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
	public ResponseModel<String> deleteById(HttpServletRequest request, @PathVariable Long id) {

		// 删除时，只作逻辑删除
		// BUG 2741 首先判断是否为公司 如果公司底下有人员不可直接删除 bykongfm
		// bug 2882 判断是否为部门 如果部门底下有人员不可直接删除 chenzhao 2021-09-27 start
		OrgUsr tempOrg = iOrgUsrService.getById(id.toString());
		// 当前登录人不能删除自己
		AgencyUserModel user = getUserInfo();

		if (tempOrg.getAmosOrgId() != null && tempOrg.getAmosOrgId().equals(user.getUserId())) {

			return ResponseHelper.buildResponse("-1");
		}

		if (tempOrg.getBizOrgType().equals("COMPANY") || tempOrg.getBizOrgType().equals("DEPARTMENT")) {
			List<OrgUsr> tempList = iOrgUsrService
					.list(new LambdaQueryWrapper<OrgUsr>().eq(OrgUsr::getParentId, id).eq(OrgUsr::getIsDelete, false));
			/* bug3031 删除机场单位后，队伍所属单位字段数据未清空 2021-10-13 start */
			List<FireTeam> fireTeams = fireTeamMapper.byTeamId(id);
			if (tempList.size() > 0 || fireTeams.size() > 0) {
				return ResponseHelper.buildResponse("-1");
			}
			/* bug3031 删除机场单位后，队伍所属单位字段数据未清空 2021-10-13 end */
		}
		// bug 2882 判断是否为部门 如果部门底下有人员不可直接删除 chenzhao 2021-09-27 end
//        iOrgUsrService.update(new UpdateWrapper<OrgUsr>().eq("sequence_nbr", id).set("is_delete", CommonConstant.IS_DELETE_01));
		/* bug 2812 一次删除多条数据 传入类型修改为string 问题解决 2021-09-09 陈召 开始 */
		iOrgUsrService.update(new UpdateWrapper<OrgUsr>().eq("sequence_nbr", String.valueOf(id)).set("is_delete",
				CommonConstant.IS_DELETE_01));
		/* bug 2812 一次删除多条数据 传入类型修改为string 问题解决 2021-09-09 陈召 结束 */
		try {
			eSOrgUsrService.deleteById(id);
			emqKeeper.getMqttClient().publish(airportDeleteTopic, JSON.toJSONString(id).getBytes(), 2, false);
		} catch (Exception e) {
			e.printStackTrace();
			throw new RuntimeException();
		}
		return ResponseHelper.buildResponse("0");
	}

	/**
	 * 更新单位数据
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/{id}", method = RequestMethod.PUT)
	@ApiOperation(httpMethod = "PUT", value = "更新单位数据", notes = "更新单位数据")
	public ResponseModel<?> updateByIdOrgUsr(HttpServletRequest request, @RequestBody OrgUsrDto OrgUsrVo,
			@PathVariable Long id) throws Exception {
		OrgUsrVo.setBizOrgType(CommonConstant.BIZ_ORG_TYPE_COMPANY);
//        iOrgUsrService.updateByIdOrgUsr(OrgUsrVo, id);
		return ResponseHelper.buildResponse(iOrgUsrService.updateByIdOrgUsr(OrgUsrVo, id));
	}

	/**
	 * 根据id查询单位
	 *
	 * @param id
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/getUnit/{id}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "获取单位详情", notes = "获取单位详情")
	public ResponseModel<OrgUsrFormDto> selectById(HttpServletRequest request, @PathVariable Long id) throws Exception {
		return ResponseHelper.buildResponse(iOrgUsrService.selectCompanyById(id));
	}

	/**
	 * 根据bizOrgType分页查询
	 *
	 * @param bizOrgType
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/selectByBizOrgType/{bizOrgType}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据bizOrgType分页查询", notes = "根据bizOrgType分页查询")
	public ResponseModel<IPage<OrgUsr>> bizOrgTypeListPage(String pageNum, String pageSize,
			@PathVariable String bizOrgType) throws Exception {
		return ResponseHelper
				.buildResponse(iOrgUsrService.page(iOrgUsrService.bizOrgTypeListPage(pageNum, pageSize, bizOrgType)));
	}

	/**
	 * 获取单位部门树
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/companyTree", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "获取单位部门树(key为物理主键)", notes = "获取单位部门树(key为物理主键)\"")
	public ResponseModel<List<OrgMenuDto>> selectCompanyTree() throws Exception {
		List<OrgMenuDto> menus = iOrgUsrService.getTree(null, iOrgUsrService.selectCompanyDepartmentMsg(),
				OrgUsr.class.getName(), "getSequenceNbr", 2, "getBizOrgName", "getParentId", "getBizOrgType");
		return ResponseHelper.buildResponse(menus);
	}

	/**
	 * 获取单位部门树
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/orgTree", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "获取单位部门树(bizOrgCode为物理主键)", notes = "获取单位部门树(bizOrgCode为物理主键)\"")
	public ResponseModel<List<OrgMenuDto>> selectCompanyTreeCode() throws Exception {
		List<OrgMenuDto> menus = OrgUsrServiceImpl.buildTreeParallel(iOrgUsrService.selectCompanyDepartmentMsg());
		return ResponseHelper.buildResponse(menus);
	}

	/**
	 * 获取单位部门树
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/org/company/tree", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "获取单位树(bizOrgCode为物理主键)", notes = "获取单位树(bizOrgCode为物理主键)")
	public ResponseModel<List<OrgMenuDto>> getCompanyTree() {
		List<OrgMenuDto> menus = OrgUsrServiceImpl.buildTreeParallel(iOrgUsrService.selectCompanyList());
		return ResponseHelper.buildResponse(menus);
	}

	/**
	 * 列表分页查询
	 *
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public IPage<OrgUsr> listPage(String pageNum, String pageSize, OrgUsr orgUsr) {
		Page<OrgUsr> pageBean;
		QueryWrapper<OrgUsr> orgUsrQueryWrapper = new QueryWrapper<>();
		Class<? extends OrgUsr> aClass = orgUsr.getClass();
		Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
			try {
				field.setAccessible(true);
				Object o = field.get(orgUsr);
				if (o != null) {
					Class<?> type = field.getType();
					String name = NameUtils.camel2Underline(field.getName());
					if (type.equals(Integer.class)) {
						Integer fileValue = (Integer) field.get(orgUsr);
						orgUsrQueryWrapper.eq(name, fileValue);
					} else if (type.equals(Long.class)) {
						Long fileValue = (Long) field.get(orgUsr);
						orgUsrQueryWrapper.eq(name, fileValue);
					} else if (type.equals(String.class)) {
						String fileValue = (String) field.get(orgUsr);
						orgUsrQueryWrapper.eq(name, fileValue);
					} else {
						String fileValue = (String) field.get(orgUsr);
						orgUsrQueryWrapper.eq(name, fileValue);
					}
				}
			} catch (Exception e) {
			}
		});
		orgUsrQueryWrapper.eq("is_delete", 0);
		IPage<OrgUsr> page;
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = iOrgUsrService.page(pageBean, orgUsrQueryWrapper);
		return page;
	}

	/**
	 * 列表分页查询
	 *
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/new-list", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "新列表分页查询---只查询当前登录人本单位下的对应数据信息", notes = "新列表分页查询---只查询当前登录人本单位下的对应数据信息")
	public IPage<OrgUsr> newlistPage(String pageNum, String pageSize, OrgUsr orgUsr) {
		ReginParams reginParams = getSelectedOrgInfo();
		String companyIdString = reginParams.getPersonIdentity().getCompanyId();
		orgUsr.setParentId(companyIdString);
		Page<OrgUsr> pageBean;
		QueryWrapper<OrgUsr> orgUsrQueryWrapper = new QueryWrapper<>();
		Class<? extends OrgUsr> aClass = orgUsr.getClass();
		Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
			try {
				field.setAccessible(true);
				Object o = field.get(orgUsr);
				if (o != null) {
					Class<?> type = field.getType();
					String name = NameUtils.camel2Underline(field.getName());
					if (type.equals(Integer.class)) {
						Integer fileValue = (Integer) field.get(orgUsr);
						orgUsrQueryWrapper.eq(name, fileValue);
					} else if (type.equals(Long.class)) {
						Long fileValue = (Long) field.get(orgUsr);
						orgUsrQueryWrapper.eq(name, fileValue);
					} else if (type.equals(String.class)) {
						String fileValue = (String) field.get(orgUsr);
						orgUsrQueryWrapper.eq(name, fileValue);
					} else {
						String fileValue = (String) field.get(orgUsr);
						orgUsrQueryWrapper.eq(name, fileValue);
					}
				}
			} catch (Exception e) {
			}
		});
		orgUsrQueryWrapper.eq("is_delete", 0);
		IPage<OrgUsr> page;
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = iOrgUsrService.page(pageBean, orgUsrQueryWrapper);
		return page;
	}

	/**
	 * 导入部门信息
	 *
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/saveDepartment", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "导入部门信息", notes = "导入部门信息")
	public ResponseModel<?> saveDepartment(HttpServletRequest request,
			@RequestBody List<OrgDepartmentDto> OrgDepartmentVo, @PathVariable Long id) throws Exception {
		iOrgUsrService.saveDepartment(OrgDepartmentVo, id);
		return ResponseHelper.buildResponse(null);
	}

	/**
	 * 导入单位信息
	 *
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/saveCompany", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "导入单位信息", notes = "导入单位信息")
	public ResponseModel<?> saveCompany(HttpServletRequest request, @RequestBody List<OrgUsrDto> OrgUsrVo)
			throws Exception {
		iOrgUsrService.saveCompany(OrgUsrVo);
		return ResponseHelper.buildResponse(null);
	}

	/**
	 * 根据id获取单位人员列表
	 *
	 * @param ids
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/{ids}/users", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据id获取单位人员列表", notes = "根据id获取单位人员列表")
	public ResponseModel<List<Map<String, Object>>> selectUsersByOrgCode(HttpServletRequest request,
			@PathVariable List<Long> ids) throws Exception {
		return ResponseHelper.buildResponse(iOrgUsrService.returnCompanyPersonMsg(ids));
	}

	/**
	 * 根据id获取单位人员列表
	 *
	 * @param ids
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/company/{ids}/person", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据id获取单位人员列表", notes = "根据id获取单位人员列表")
	public ResponseModel<List<CompanyPerson>> selectCompanyPerson(@PathVariable List<Long> ids) throws Exception {
		return ResponseHelper.buildResponse(iOrgUsrService.returnCompanyPerson(ids));
	}

	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/company/person/{amosUserId}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据amosUserId获取单位ID", notes = "根据amosUserId获取单位ID")
	public ResponseModel<String> selectPersonId(@PathVariable String amosUserId) throws Exception {
		return ResponseHelper.buildResponse(iOrgUsrService.getParentId(amosUserId));
	}

	/**
	 * 根据id获取单位人员列表
	 *
	 * @param amosUserId
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/company/{amosUserId}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据amos userid获取单位", notes = "根据amos userid获取单位")
	public ResponseModel<OrgUsrDto> selectCompany(@PathVariable String amosUserId) throws Exception {
		return ResponseHelper.buildResponse(iOrgUsrService.getOrg(amosUserId));
	}

	/**
	 * 获取当前登陆人所在机场单位人员
	 *
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/company/users/{orgUnitId}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据amos userid获取单位", notes = "根据amos userid获取单位")
	public ResponseModel<List<OrgUsr>> selectCompanyUsers(@PathVariable Long orgUnitId) throws Exception {

		return ResponseHelper.buildResponse(iOrgUsrService.selectCompanyUsers(orgUnitId));
	}

	/**
	 * 根据名称模糊匹配
	 *
	 * @param name
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/getdataList/unit", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据名称模糊匹配单位", notes = "根据名称模糊匹配单位")
	public ResponseModel<Set<ESOrgUsrDto>> selectByIddata(HttpServletRequest request, String name) throws Exception {
		return ResponseHelper.buildResponse(eSOrgUsrService.queryByKeys(name));
	}

	/**
	 * 获取单位部门树
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/companyTreeByUser", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据登陆人获取单位部门树", notes = "根据登陆人获取单位部门树")
	public ResponseModel<List<OrgMenuDto>> selectCompanyTreeByUser() throws Exception {
		// 获取登陆人角色
		AgencyUserModel user = getUserInfo();
		List<OrgMenuDto> menus = iOrgUsrService.companyTreeByUser(user);
		return ResponseHelper.buildResponse(menus);
	}

	@PersonIdentify
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/companyTreeByUserAndType", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据登录人及类型获取公司部门树", notes = "根据登录人及类型获取公司部门树")
	public ResponseModel<List<OrgMenuDto>> companyTreeByUserAndType() {
		// 获取登陆人角色
		ReginParams reginParams = getSelectedOrgInfo();
		List<OrgMenuDto> menus = iOrgUsrService.companyTreeByUserNumber(reginParams);
		return ResponseHelper.buildResponse(menus);
	}

	@PersonIdentify
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/companyTreeByUserCurrent", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据登录人获取当前公司部门树", notes = "根据登录人获取当前公司部门树")
	public ResponseModel<List<OrgMenuDto>> companyTreeByUser() {
		// 获取登陆人角色
		ReginParams reginParams = getSelectedOrgInfo();
		List<OrgMenuDto> menus = iOrgUsrService.companyTreeByUser(reginParams);
		return ResponseHelper.buildResponse(menus);
	}

	/**
	 * 获取单位部门树
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/companyUserTreeByUser", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据登陆人获取单位部门用户树", notes = "根据登陆人获取单位部门用户树")
	public ResponseModel<List<OrgMenuDto>> companyUserTreeByUser() {
		// 获取登陆人角色
		AgencyUserModel user = getUserInfo();
		List<OrgMenuDto> menus = iOrgUsrService.companyUserTreeByUser(user);
		return ResponseHelper.buildResponse(menus);
	}

	/**
	 * 获取单位列表
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/companyListByUser", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据登陆人获取单位列表", notes = "根据登陆人获取单位列表")
	public ResponseModel<List<CheckObjectDto>> companyListByUser() {
		String bizOrgCodeString=	getOrgCode();
		// 获取登陆人角色
		AgencyUserModel user = getUserInfo();
		List<CheckObjectDto> menus = iOrgUsrService.companyListByUser(user,bizOrgCodeString);
		return ResponseHelper.buildResponse(menus);
	}

	/**
	 * 获取用户单位归属
	 *
	 * @param userId
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/{userId}/userUnit", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "获取用户单位归属", notes = "获取用户单位归属")
	public ResponseModel<UserUnitDto> getUserUnit(@PathVariable String userId) {
		return ResponseHelper.buildResponse(iOrgUsrService.getUserUnit(userId));
	}

	/**
	 * 获取用户信息
	 *
	 * @param userId
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/{userId}/userInfo", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "获取用户信息", notes = "获取用户信息")
	public ResponseModel<List<UserDto>> getUserInfo(@PathVariable String userId) {
		return ResponseHelper.buildResponse(iOrgUsrService.getUserInfo(userId));
	}

	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/{userId}/getUserParentInfo", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "获取用户本级及父级信息", notes = "获取用户本级及父级信息")
	public UserDto getUserParentInfo(@PathVariable String userId) {
		return orgUsrService.getUserParentInfo(userId);
	}

	/**
	 * 获取登陆人绑定的人员关系
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = { "/getLoginUserDetails/{userId}", "/getLoginUserDetails" }, method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "获取登陆人绑定的人员关系", notes = "获取登陆人绑定的人员关系")
	public ResponseModel<List<Map<String, Object>>> getLoginUserDetails(@PathVariable(required = false) String userId) {
		AgencyUserModel user = getUserInfo();
		String userIds = userId;
		if (StringUtils.isEmpty(userIds)) {
			userIds = user.getUserId();
		}
		List<Map<String, Object>> loginUserDetails = iOrgUsrService.getLoginUserDetails(userIds, user);
		return ResponseHelper.buildResponse(loginUserDetails);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/getParentBuilding/{id}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "获取最上级station", notes = "获取最上级建筑信息")
	public ResponseModel<JSONObject> getBuliding(@PathVariable Long id) {
		JSONObject equipjSONObject = this.getBulid(id);
		return ResponseHelper.buildResponse(equipjSONObject);
	}

	public JSONObject getBulid(Long id) {
		ResponseModel<Object> equipObj = equipFeignClient.getOne(id);
		JSONObject equipjSONObject = JSONObject.parseObject(JSONObject.toJSONString(equipObj.getResult()));
		if (!equipjSONObject.containsKey("parentId")) {
			return null;
		}
		if (!"0".equals(equipjSONObject.getString("parentId"))) {
			String parentId = equipjSONObject.getString("parentId");
			if (StringUtils.isNotBlank(parentId)) {
				return getBulid(Long.parseLong(parentId));
			}
		}
		return equipjSONObject;
	}

	/**
	 * 判断关联账户是否已关联
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/getAmosId/{amosId}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "判断关联账户是否已关联", notes = "判断关联账户是否已关联")
	public ResponseModel<Object> getAmosId(@PathVariable String amosId) {
		return ResponseHelper.buildResponse(iOrgUsrService.amosIdExist(amosId));
	}

	/**
	 * 判断关联账户是否已关联-队伍
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/getAmosIdTeam/{amosId}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "判断关联账户是否已关联", notes = "判断关联账户是否已关联")
	public ResponseModel<Object> getAmosIdTeam(@PathVariable String amosId) {
		return ResponseHelper.buildResponse(iOrgUsrService.amosIdExistTeam(amosId));
	}

	/**
	 * 根据机场人员id获取amos平台人员id
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据机场人员id获取amos平台人员信息", notes = "根据机场人员id获取amos平台人员信息")
	@GetMapping(value = "/amos/{orgUserId}")
	public ResponseModel<AgencyUserModel> getAmosIdByOrgUserId(@PathVariable String orgUserId) throws Exception {
		return ResponseHelper.buildResponse(iOrgUsrService.getAmosIdByOrgUserId(orgUserId));
	}

	/**
	 * 根据机场人员id(逗号分割)获取amos平台人员id列表
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据机场人员id(逗号分割)获取amos平台人员id列表", notes = "根据机场人员id(逗号分割)获取amos平台人员id列表")
	@GetMapping(value = "/amos/orgUserIds")
	public ResponseModel<List<String>> getAmosIdListByOrgUserId(@RequestParam String orgUserIds) throws Exception {
		return ResponseHelper.buildResponse(iOrgUsrService.getAmosIdListByOrgUserId(orgUserIds));
	}

	/**
	 * 根据单位id列表或未同步的机场单位列表
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/unSync/orgCompany")
	@ApiOperation(httpMethod = "GET", value = "将所有机场单位数据同步到消防监督服务p_point表", notes = "将所有机场单位数据同步到消防监督服务p_point表")
	public ResponseModel getUnSyncOrgCompanyList(@RequestParam List<Long> companyIdList) {
		return ResponseHelper.buildResponse(iOrgUsrService.getUnSyncOrgCompanyList(companyIdList));
	}

	/**
	 * 根据机场单位id获取各单位下部门数量
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据机场单位id获取各单位下部门数量", notes = "根据机场单位id获取各单位下部门数量")
	@GetMapping(value = "/amos/companyIds")
	public ResponseModel<Map<String, Integer>> getDeptCountByCompanyIds(@RequestParam List<String> companyIdList)
			throws Exception {
		return ResponseHelper.buildResponse(iOrgUsrService.getDeptCountByCompanyIds(companyIdList));
	}

	/**
	 * 根据机场人员ids获取amos平台人员列表
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据机场人员ids获取amos平台人员列表", notes = "根据机场人员ids获取amos平台人员列表")
	@GetMapping(value = "/amos/list/{orgUserId}")
	public ResponseModel<List<AgencyUserModel>> getAmosUserByOrgUser(@PathVariable String orgUserId) throws Exception {
		return ResponseHelper.buildResponse(iOrgUsrService.getAmosUserByOrgUser(orgUserId));
	}

	/**
	 * 根据机场单位id获取单位人员列表
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据机场单位id获取单位人员列表", notes = "根据机场单位id获取单位人员列表")
	@GetMapping(value = "/{companyId}/person/list")
	public ResponseModel<List<OrgUsr>> getPersonListByCompanyId(@PathVariable String companyId) {
		return ResponseHelper.buildResponse(iOrgUsrService.getPersonListByCompanyId(companyId));
	}

	/**
	 * 根据机场单位id获取单位人员列表
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "当前角色为单位防火监督检查负责人 --下的-- 根据机场单位id获取单位人员列表", notes = "当前角色为单位防火监督检查负责人 --下的--根据机场单位id获取单位人员列表")
	@GetMapping(value = "/{companyId}/person/newList")
	public ResponseModel<List<OrgUsr>> getNewPersonListByCompanyId(@PathVariable String companyId) {
		ReginParams reginParams = getSelectedOrgInfo();
		String roleNameString = reginParams.getRole().getRoleName();
		String currentCompanyId = getCompanyId(reginParams);
		if (companyId.equals(currentCompanyId) && roleNameString.contains("Person_charge_unit_fire_protection_supervision_inspection")) {//单位防火监督检查负责人 
			return ResponseHelper.buildResponse(iOrgUsrService.getPersonListByCompanyId(companyId));
		}
		return null;
	}

	/**
	 * 根据id获取单位人员列表
	 *
	 * @param amosUserId
	 * @return
	 */
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/getOrgUser/byAmosUserId", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据amos userid模糊匹配获取对应机场单位人员信息列表", notes = "根据amos userid模糊匹配获取对应机场单位人员信息列表")
	public ResponseModel<Object> getOrgUserByAmosUserId(@RequestParam String amosUserId) throws Exception {
		return ResponseHelper.buildResponse(iOrgUsrService.getOrgUserByAmosUserId(amosUserId));
	}

	/**
	 * 根据机构类型和登陆人bizOrgCode获取列表不分页
	 *
	 * @param orgTypes 机构类型（逗号分割）
	 * @return list不分页
	 */
	@PersonIdentify
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据机构类型(逗号分割),机构编码获取列表不分页", notes = "根据机构类型(逗号分割),机构编码获取列表不分页")
	@GetMapping(value = "/amos/getListByBizOrgTypesCode")
	public ResponseModel<List<OrgUsr>> getListByBizOrgTypeCode(@RequestParam(required = false) String orgTypes) {
		ReginParams reginParams = getSelectedOrgInfo();
		ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
		String bizOrgCode = personIdentity.getBizOrgCode();
		return ResponseHelper.buildResponse(iOrgUsrService.getListByBizOrgTypeCode(orgTypes, bizOrgCode));
	}

	@PersonIdentify
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据机构类型(逗号分割),机构编码获取列表不分页", notes = "根据机构类型(逗号分割),机构编码获取列表不分页")
	@GetMapping(value = "/{authKey}/listWithAuth")
	public ResponseModel<List<OrgUsr>> getListWithAuth(@RequestParam(required = false) String orgTypes,
			@PathVariable String authKey) throws Exception {
		ReginParams reginParams = getSelectedOrgInfo();
		ReginParams.PersonIdentity personIdentity = reginParams.getPersonIdentity();
		String bizOrgCode = personIdentity.getBizOrgCode();


		//拿到数据字典中存储的 特殊类型 特殊部门
		QueryWrapper<DataDictionary> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("type", "SpecialType").or().eq("type", "SpecialDepartment");
		Collection<DataDictionary> list = iDataDictionaryService.list(queryWrapper);
		List<String> objects = new ArrayList<>();
		list.stream().forEach(e->objects.add(e.getCode()));
		//判断当前登录人权限是否处于特殊类型
		if (objects.contains(authKey)){
			//判断当前登录人部门是否处于特殊部门
				if (objects.contains(personIdentity.getCompanyId())) {
					//查询当前登录人所属单位/部门
					OrgUsr orgUsr = orgUsrMapper.selectById(personIdentity.getCompanyId());

					//查询当前登录人父级单位
					LambdaQueryWrapper<OrgUsr> wrapper = new LambdaQueryWrapper<>();
					wrapper.eq(OrgUsr::getSequenceNbr,orgUsr.getParentId());
					wrapper.eq(BaseEntity::getIsDelete,false);
					OrgUsr result = orgUsrMapper.selectOne(wrapper);
					bizOrgCode = result.getBizOrgCode() != null? result.getBizOrgCode() : personIdentity.getBizOrgCode();
				}
		}
		// 权限处理
		PermissionInterceptorContext.setDataAuthRule(authKey);
		return ResponseHelper.buildResponse(iOrgUsrService.getListByBizOrgTypeCode(orgTypes, bizOrgCode));
	}



	@PersonIdentify
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/{authKey}/treeWithAuth", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据权限查询公司部门树", notes = "根据权限查询公司部门树")
	public ResponseModel<List<OrgMenuDto>> getCompanyTreeWithAuth(@RequestParam(required = false) String orgType,
			@PathVariable String authKey) {
		// 获取登陆人角色
		ReginParams reginParams = getSelectedOrgInfo();
		// 权限处理
		PermissionInterceptorContext.setDataAuthRule(authKey);
		List<OrgMenuDto> menus = iOrgUsrService.companyTreeByUserAndType(reginParams, orgType);
		return ResponseHelper.buildResponse(menus);
	}

	/**
	 * 查询多个组织机构下面的所有人员列表信息
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "查询多个组织机构下面的所有人员列表信息", notes = "查询多个组织机构下面的所有人员列表信息")
	@GetMapping(value = "/company/person/list")
	public ResponseModel<List<OrgUsr>> getPersonListByCompanyIdList(@RequestParam String companyIds) {
		List<OrgUsr> orgUserList = Lists.newArrayList();
		if (!ValidationUtil.isEmpty(companyIds)) {
			List<String> companyIdList = Lists.newArrayList(companyIds.split(","));
			orgUserList = iOrgUsrService.getPersonListByCompanyIdList(companyIdList);
		}
		return ResponseHelper.buildResponse(orgUserList);
	}

	/**
	 * 查询多个组织机构下面的所有人员列表信息
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "查询上级单位", notes = "查询上级单位")
	@GetMapping(value = "/company/bizOrgCode/list")
	public ResponseModel<OrgUsrDto> getCompanyByBizOrgCodeList(@RequestParam String bizOrgCode) {
		if (ValidationUtil.isEmpty(bizOrgCode)) {
			return ResponseHelper.buildResponse(new OrgUsrDto());
		}
		return ResponseHelper.buildResponse(iOrgUsrService.getCompanyByBizOrgCodeList(bizOrgCode));
	}

	/**
	 * 查询多个组织机构下面的所有人员列表信息
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "查询当前人员所属的第一级公司", notes = "查询当前人员所属的第一级公司")
	@GetMapping(value = "find/getCompanyByUserId")
	public ResponseModel<Object> getCompanyByUserId(@RequestParam Long userId) {
		return ResponseHelper.buildResponse(iOrgUsrService.getCompanyByUserId(userId));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "查询当前人员的身份证号码", notes = "查询当前人员的身份证号码")
	@GetMapping(value = "find/getIdNumberByAmosId")
	public ResponseModel<String> getIdNumberByAmosId(@RequestParam String amosId) {
		return ResponseHelper.buildResponse(iOrgUsrService.getIdNumberByAmosId(amosId));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据平台Id查询人员", notes = "根据平台Id查询人员")
	@GetMapping(value = "find/getByAmosId")
	public ResponseModel<List<OrgUsr>> getByAmosId(@RequestParam List<String> amosIds) {
		return ResponseHelper.buildResponse(iOrgUsrService.getByAmosId(amosIds));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据bizOrgCode查询公司部门 非树", notes = "根据bizOrgCode查询公司部门 非树")
	@GetMapping(value = "find/getByOrgCode")
	public ResponseModel<Object> getByOrgCode(@RequestParam String bizOrgCode) {
		return ResponseHelper.buildResponse(iOrgUsrService.getByOrgCode(bizOrgCode));
	}

}