package com.yeejoin.amos.boot.module.tzs.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.yeejoin.amos.boot.module.tzs.api.dto.AlertMsgDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.AlertPaperInfoDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.MsgLogDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.MsgLog;
import com.yeejoin.amos.boot.module.tzs.api.mapper.MsgLogMapper;
import com.yeejoin.amos.boot.module.tzs.api.service.IMsgLogService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;

/**
 * 消息流水表服务实现类
 *
 * @author system_generator
 * @date 2022-04-20
 */
@Service
public class MsgLogServiceImpl extends BaseService<MsgLogDto,MsgLog,MsgLogMapper> implements IMsgLogService {

    Logger logger = LoggerFactory.getLogger(MsgLogServiceImpl.class);

    @Autowired
    AlertCalledServiceImpl alertCalledService;

    /**
     * 分页查询
     */
    public Page<MsgLogDto> queryForMsgLogPage(Page<MsgLogDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<MsgLogDto> queryForMsgLogList()   {
        return this.queryForList("" , false);
    }

    public List<MsgLogDto> queryForWebMsgLogList(String terminalType)   {
        return this.queryForList("" , false, terminalType);
    }

    public List<AlertMsgDto> queryForAlertMsg(List<String> regionCodes) {
        List<AlertMsgDto> alertMsgDtoList = Lists.newArrayList();
        // 查询电梯警情预报消息
        List<AlertPaperInfoDto> alertPaperInfoDtoList =
                alertCalledService.getAlertPaperInfoList(alertCalledService.authRegionCodeList(regionCodes), false);
        if (!ValidationUtil.isEmpty(alertPaperInfoDtoList)) {
            alertPaperInfoDtoList.forEach(msg -> {
                AlertMsgDto alertMsgDto = new AlertMsgDto();
                alertMsgDto.setBody(msg.getAddress() + "发生" + msg.getAlarmType() + "事件");
                alertMsgDto.setFrom("elevator");
                alertMsgDto.setRelationId(String.valueOf(msg.getAlertId()));
                alertMsgDto.setTime(msg.getCallTime());
                alertMsgDto.setType(msg.getAlarmType());

                alertMsgDtoList.add(alertMsgDto);
            });
        }
        // 查询气瓶预警消息
        List<MsgLog> msgLogList = this.list(new LambdaQueryWrapper<MsgLog>().eq(MsgLog::getTerminalType, "WEB"));
        if (!ValidationUtil.isEmpty(msgLogList)) {
            msgLogList.forEach(msg -> {
                AlertMsgDto alertMsgDto = new AlertMsgDto();
                alertMsgDto.setBody(msg.getBody());
                alertMsgDto.setFrom("cylinder");
                alertMsgDto.setRelationId(String.valueOf(msg.getSequenceNbr()));
                alertMsgDto.setTime(msg.getSendTime());
                alertMsgDto.setType(msg.getMsgTypeName());

                alertMsgDtoList.add(alertMsgDto);
            });
        }

        return alertMsgDtoList;
    }

    public Integer countByTerminalType(String terminalType) {
        return this.list(new LambdaQueryWrapper<MsgLog>().eq(StringUtils.isNotEmpty(terminalType), MsgLog::getTerminalType, terminalType)).size();
    }
}