package com.yeejoin.amos.boot.module.jg.biz.edit.backup;

import com.yeejoin.amos.boot.module.jg.api.dto.FieldChangeMeta;
import com.yeejoin.amos.boot.module.jg.api.entity.IdxBizJgPipelineOperationHist;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.equip.PieLineDataChangeServiceImpl;
import org.springframework.context.ApplicationContext;

import java.util.List;
import java.util.stream.Collectors;

public abstract class DefaultEquipBackupManager implements DataBackupManager {

    protected ApplicationContext applicationContext;

    public DefaultEquipBackupManager(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void backup(String bizId) {
        EquipBackupHandler handler = applicationContext.getBean(EquipBackupHandler.class);
        handler.backup2Db(getBizType(), bizId, getRecords(bizId));
    }

    public Boolean restore(String bizId) {
        EquipBackupHandler handler = applicationContext.getBean(EquipBackupHandler.class);
        return handler.restoreFormBackup(getBizType(), bizId);
    }

    public void updateLastOne(String bizId, List<FieldChangeMeta> changeMetas) {
        List<String> insertRecord = changeMetas.stream().filter(e -> e.getColumnKey().equals(PieLineDataChangeServiceImpl.PIE_LINE_KEY) && e.getColumnFamily().equals(PieLineDataChangeServiceImpl.PIE_LINE_CREATE)).map(FieldChangeMeta::getColumnNewValue).collect(Collectors.toList());
        List<String> deleteRecords = changeMetas.stream().filter(e -> e.getColumnKey().equals(PieLineDataChangeServiceImpl.PIE_LINE_KEY) && e.getColumnFamily().equals(PieLineDataChangeServiceImpl.PIE_LINE_DELETE)).map(FieldChangeMeta::getColumnOldValue).collect(Collectors.toList());
        insertRecord.remove(null);
        insertRecord.remove("");
        deleteRecords.remove(null);
        deleteRecords.remove("");
        EquipBackupHandler handler = applicationContext.getBean(EquipBackupHandler.class);
        handler.updateOperateRecords(bizId, getBizType(), insertRecord, deleteRecords);
    }

    public List<IdxBizJgPipelineOperationHist> listAll(String bizId){
        EquipBackupHandler handler = applicationContext.getBean(EquipBackupHandler.class);
        return handler.listAllBackupOfOneBizId(getBizType(), bizId);
    }

    public abstract List<String> getRecords(String bizId);

    public abstract String getBizType();
}
