package com.yeejoin.equipmanage.common.utils;

import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.List;

public class CommonPageParamUtil {

	public static CommonPageInfoParam fillCommonPageInfoParam(List<CommonRequest> queryRequests, CommonPageable commonPageable) {	
		CommonPageInfoParam param = new CommonPageInfoParam();
		for(int i=0;i<queryRequests.size();i++){
			String name = queryRequests.get(i).getName();
			if("name".equals(name)){
				param.setName(toString(queryRequests.get(i).getValue()));
			}else if("equipType".equals(name)){
				param.setEquipType(toString(queryRequests.get(i).getValue()));
			}else if("productArea".equals(name)){
				param.setProductArea(toString(queryRequests.get(i).getValue()));
			}else if("protectObj".equals(name)){
				param.setProtectObj(toString(queryRequests.get(i).getValue()));
			}else if("evalModelId".equals(name)){
				param.setEvalModelId(toLong(queryRequests.get(i).getValue()));
			}else if("equipClassify".equals(name)){
				param.setEquipClassify(toLong(queryRequests.get(i).getValue()));
			}else if("id".equals(name)){
				param.setId(toLong(queryRequests.get(i).getValue()));
			}else if("code".equals(name)){
				param.setCode(toString(queryRequests.get(i).getValue()));
			}else if("beginDate".equals(name)){
				param.setBeginDate(toString(queryRequests.get(i).getValue()));
			}else if("endDate".equals(name)){
				param.setEndDate(toString(queryRequests.get(i).getValue()));
			}else if("riskSourceId".equals(name)){
				param.setRiskSourceId(toLong(queryRequests.get(i).getValue()));
			}else if("warehouseStructureName".equals(name)){
				param.setWarehouseStructureName(toString(queryRequests.get(i).getValue()));
			}else if("equipCode".equals(name)){
				param.setEquipCode(toString(queryRequests.get(i).getValue()));
			}else if("confirmType".equals(name)){
				param.setConfirmType(toString(queryRequests.get(i).getValue()));
			}else if("alarmType".equals(name)){
				param.setAlarmType(toString(queryRequests.get(i).getValue()));
			} else if("orgCode".equals(name)){
				param.setOrgCode(toString(queryRequests.get(i).getValue()));
			}else if("type".equals(name)){
				param.setType(toString(queryRequests.get(i).getValue()));
			} else if("system".equals(name)){
				param.setSystem(toString(queryRequests.get(i).getValue()));
			} else if("handleStatus".equals(name)){
				param.setHandleStatus(toString(queryRequests.get(i).getValue()));
			}  else if("systemCode".equals(name)){
                param.setSystemCode(toString(queryRequests.get(i).getValue()));
            } else if("buildId".equals(name)){
				param.setBuildId(toString(queryRequests.get(i).getValue()));
			} else if("buildIds".equals(name)){
				param.setBuildIds((List<String>)queryRequests.get(i).getValue());
			} else if("status".equals(name)){
				param.setStatus(toString(queryRequests.get(i).getValue()));
			} else if("cleanStatus".equals(name)){
				param.setCleanStatus(toString(queryRequests.get(i).getValue()));
			} else if("isRemoveShield".equals(name)){
				param.setIsRemoveShield(toString(queryRequests.get(i).getValue()));
			}
		}
		if(commonPageable !=null){
			param.setPageNumber(commonPageable.getPageNumber());
			param.setPageSize(commonPageable.getPageSize());	
		}
		return param;
	}
	
	private static String toString(Object value) {
		if(null ==value || value =="" || "null".equals(value.toString()) || "''".equals(value.toString())){
			return null;
		}else{
			return value.toString();
		}		
	}
	
	private static Long toLong(Object value) {
		if(null ==value || value ==""){
			return null;
		}else{
			return Long.parseLong(value.toString());
		}		
	}


	public static Object getValue(String propertyName,List<CommonRequest> queryRequests)
	{
		Object  value = null;
		if(!CollectionUtils.isEmpty(queryRequests))
		{
			for(CommonRequest request : queryRequests)
				if(propertyName.equals(request.getName()))
					value = request.getValue();
		}
		return value;
	}

}
