package com.yeejoin.amos.api.openapi.controller;

import com.yeejoin.amos.api.common.restful.utils.ResponseHelper;
import com.yeejoin.amos.api.common.restful.utils.ResponseModel;
import com.yeejoin.amos.api.openapi.face.model.*;
import com.yeejoin.amos.api.openapi.face.service.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.component.event.RestEventTrigger;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping(value = "/cylinder")
@Api(tags = "cylinder-气瓶数据对接")
public class CylinderController {
	private static final Logger logger = LogManager.getLogger(CylinderController.class);
	@Autowired
	private TmCylinderUnitService cylinderUnitService;
	@Autowired
	private TmCylinderFillingCheckService cylinderFillingCheckService;
	@Autowired
	private TmCylinderFillingExamineService cylinderFillingExamineService;
	@Autowired
	private TmCylinderFillingRecordService cylinderFillingRecordService;
	@Autowired
	private TmCylinderFillingService cylinderFillingService;
	@Autowired
	private TmCylinderInfoService cylinderInfoService;
	@Autowired
	private TmCylinderInspectionService cylinderInspectionService;
	@Autowired
	private TmCylinderTagsService cylinderTagsService;
	@Autowired
	private CylinderFillingDataValidationService cylinderFillingDataValidationService;

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "气瓶企业信息")
	@PostMapping(value = "/unit")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> cylinderUnit(@RequestBody List<TmCylinderUnitModel> unitData) {
		cylinderFillingDataValidationService.validateCylinderUnit(unitData);
		return ResponseHelper.buildResponse(cylinderUnitService.createCylinderUnit(unitData));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "气瓶基础数据")
	@PostMapping(value = "/info")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> cylinderInfo(@RequestBody List<TmCylinderInfoModel> infoData) {
		cylinderFillingDataValidationService.validateCylinderInfo(infoData);
		return ResponseHelper.buildResponse(cylinderInfoService.createCylinderInfo(infoData));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "气瓶标签数据")
	@PostMapping(value = "/tag")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> cylinderTagInfo(@RequestBody List<TmCylinderTagsModel> tagData) {
		cylinderFillingDataValidationService.validateCylinderTag(tagData);
		return ResponseHelper.buildResponse(cylinderTagsService.createCylinderTag(tagData));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "气瓶检验数据")
	@PostMapping(value = "/inspection")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> cylinderInspectionInfo(@RequestBody List<TmCylinderInspectionModel> inspectionData) {
		cylinderFillingDataValidationService.validateCylinderInspection(inspectionData);
		return ResponseHelper.buildResponse(cylinderInspectionService.createCylinderInspection(inspectionData));

	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "气瓶充装数据")
	@PostMapping(value = "/filling")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> cylinderFillingInfo(@RequestBody String fillingData) throws Exception {

		JSONObject jsonobject = JSONObject.fromObject(fillingData);

		cylinderFillingDataValidationService.validateFilling(jsonobject);

		Map<String, Class> classMap = new HashMap<>();
		classMap.put("fillingBefore", TmCylinderFillingModel.class);
		classMap.put("filling", TmCylinderFillingRecordModel.class);
		classMap.put("fillingAfter", TmCylinderFillingCheckModel.class);
		TmCylinderFillingModelList cylinderFillingModelList = (TmCylinderFillingModelList) JSONObject.toBean(jsonobject,
				TmCylinderFillingModelList.class, classMap);

		List<TmCylinderFillingModel> fillingBeforeList = cylinderFillingModelList.getFillingBefore();
		List<TmCylinderFillingRecordModel> fillingList = cylinderFillingModelList.getFilling();
		List<TmCylinderFillingCheckModel> fillingAfterList = cylinderFillingModelList.getFillingAfter();
		if (ValidationUtil.isEmpty(fillingBeforeList) && ValidationUtil.isEmpty(fillingList) && ValidationUtil.isEmpty(fillingAfterList)) {
			throw new BadRequest("液化气体气瓶充装信息-充装前检查信息、液化气体气瓶充装信息-充装记录信息、液化气体气瓶充装信息-充装后复查信息为空.");
		}
		cylinderFillingService.createCylinderFillingBefore(fillingBeforeList);
		cylinderFillingRecordService.createCylinderFilling(fillingList);
		cylinderFillingCheckService.createCylinderFillingAfter(fillingAfterList);
		return ResponseHelper.buildResponse("OK");
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(value = "气瓶充装审核数据")
	@PostMapping(value = "/fillingAudit")
	@RestEventTrigger(value = "openapiLogEventHandler")
	public ResponseModel<String> cylinderFillingAudit(@RequestBody List<TmCylinderFillingExamineModel> fillingAuditData) {
		cylinderFillingDataValidationService.validateCylinderFillingExamineModel(fillingAuditData);
		return ResponseHelper.buildResponse(cylinderFillingExamineService.createCylinderFillingExamine(fillingAuditData));

	}
}
