package com.yeejoin.amos.api.openapi.face.service;


import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.api.openapi.face.model.TmCylinderFillingRecordModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.ESCylinderFillingRecordRepository;
import com.yeejoin.amos.api.openapi.face.orm.dao.TmCylinderFillingRecordMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.TmCylinderFillingRecord;
import com.yeejoin.amos.api.openapi.service.MyBaseServiceImpl;
import com.yeejoin.amos.api.openapi.util.MultiFieldKey;
import com.yeejoin.amos.boot.module.cylinder.api.entity.ESCylinderFillingRecordDto;
import com.yeejoin.amos.boot.module.cylinder.flc.api.mapper.CylinderFillingRecordMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.utils.Bean;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 
 * <pre>
 * 液化气体气瓶充装信息-充装记录 服务类
 * </pre>
 *
 * @author gwb
 * @version $Id: ElevatorService.java, v 0.1 2021年9月30日 下午3:28:55 gwb Exp $
 */
@Component
public class TmCylinderFillingRecordService extends MyBaseServiceImpl<TmCylinderFillingRecordModel, TmCylinderFillingRecord, TmCylinderFillingRecordMapper> {
    @Autowired
    private RedisTemplate redisTemplate;

	@Autowired
	CylinderFillingRecordMapper cylinderFillingRecordMapper;

	@Autowired
	ESCylinderFillingRecordRepository esCylinderFillingRecordRepository;

	@Autowired
	private SyncCylinderDataService syncCylinderDataService;

	@DSTransactional
	@Transactional(rollbackFor = Exception.class)
	public void createCylinderFilling(List<TmCylinderFillingRecordModel> model) {
		Date now = new Date();
		String appId = getAppId();
		for (TmCylinderFillingRecordModel cylinderFillingRecordModel : model) {
			cylinderFillingRecordModel.setSequenceNbr(null);
			cylinderFillingRecordModel.setRecDate(now);
			cylinderFillingRecordModel.setAppId(appId);
		}
		// 同步至气瓶业务库
		syncCylinderFilling(model);

		List<TmCylinderFillingRecord> tmCylinderFillingRecordList = Bean.toModels(model, TmCylinderFillingRecord.class);
		this.saveOrUpdateBatchByUniqueFields(
				tmCylinderFillingRecordList,
				tmCylinderFillingRecord -> new LambdaQueryWrapper<TmCylinderFillingRecord>()
						.eq(TmCylinderFillingRecord::getAppId, tmCylinderFillingRecord.getAppId())
						.eq(TmCylinderFillingRecord::getSequenceCode, tmCylinderFillingRecord.getSequenceCode())
						.eq(TmCylinderFillingRecord::getFillingRecordId, tmCylinderFillingRecord.getFillingRecordId()),
				entity -> new MultiFieldKey(entity.getAppId(), entity.getSequenceCode(), entity.getFillingRecordId()),
				"appId",
				"sequenceCode",
				"fillingRecordId"
		);
	}

	@DS("tzs")
	private void syncCylinderFilling(List<TmCylinderFillingRecordModel> model) {
		syncCylinderDataService.syncCylinderFillingRecord(model);

		ArrayList<ESCylinderFillingRecordDto> models = Bean.toModels(model, ESCylinderFillingRecordDto.class);
		syncCylinderDataService.createCylinderFillingRecord(models);
	}

	public List<String> getDateList() {
    	return baseMapper.getDateList();
	}

}	
